/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.io.CharSource;
import com.google.common.io.MoreFiles;
import com.google.errorprone.annotations.MustBeClosed;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Stream;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.Parser;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFABuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.DynamicBindingCreator;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.Scope;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.THDotBuilder;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierarchy;
import org.sosy_lab.cpachecker.exceptions.JParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;

@Options
class EclipseJavaParser
implements Parser {
    @Option(secure=true, name="java.encoding", description="use the following encoding for java files")
    private Charset encoding = StandardCharsets.UTF_8;
    @Option(secure=true, name="java.version", description="Specifies the java version of source code accepted")
    private String version = "1.7";
    @Option(secure=true, name="java.sourcepath", description="Specify the source code path to search for java class or interface definitions")
    private String javaSourcepath = "";
    @Option(secure=true, name="java.classpath", description="Specify the class code path to search for java class or interface definitions")
    private String javaClasspath = "";
    @Option(secure=true, name="java.exportTypeHierarchy", description="export TypeHierarchy as .dot file")
    private boolean exportTypeHierarchy = true;
    @Option(secure=true, name="java.typeHierarchyFile", description="export TypeHierarchy as .dot file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportTypeHierarchyFile = Path.of("typeHierarchy.dot", new String[0]);
    private final ASTParser parser = ASTParser.newParser((int)4);
    private final LogManager logger;
    private final Timer parseTimer = new Timer();
    private final Timer cfaTimer = new Timer();
    private final String entryMethod;
    private ImmutableList<Path> javaSourcePaths = ImmutableList.of();
    private ImmutableList<Path> javaClassPaths = ImmutableList.of();
    private final List<Path> parsedFiles = new ArrayList<Path>();
    private static final boolean IGNORE_METHOD_BODY = true;
    private static final boolean PARSE_METHOD_BODY = false;
    static final String JAVA_SOURCE_FILE_EXTENSION = ".java";

    public EclipseJavaParser(LogManager pLogger, Configuration config, String pEntryMethod) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
        this.entryMethod = pEntryMethod;
        if (!this.javaSourcepath.isEmpty() && this.javaClasspath.isEmpty()) {
            this.javaClasspath = this.javaSourcepath;
        }
        if (!this.javaClasspath.isEmpty()) {
            this.javaClassPaths = this.convertToPathList(this.javaClasspath);
            this.javaSourcePaths = this.javaSourcepath.isEmpty() ? this.javaClassPaths : this.convertToPathList(this.javaSourcepath);
            if (this.javaSourcePaths.isEmpty()) {
                throw new InvalidConfigurationException("No valid Paths could be found.");
            }
        }
    }

    private ImmutableList<Path> convertToPathList(String javaPath) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String pathAsString : Splitter.on((String)File.pathSeparator).trimResults().omitEmptyStrings().split((CharSequence)javaPath)) {
            Path path = Path.of(pathAsString, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                this.logger.log(Level.WARNING, new Object[]{"Path", path, "could not be found."});
                continue;
            }
            result.add((Object)path);
        }
        return result.build();
    }

    @Override
    public ParseResult parseFiles(List<String> sourceFiles) throws ParserException, IOException, InvalidConfigurationException {
        Preconditions.checkArgument((!sourceFiles.isEmpty() ? 1 : 0) != 0);
        String firstSourceFile = sourceFiles.get(0);
        if (sourceFiles.size() == 1 && this.searchForClassFile(firstSourceFile).isPresent()) {
            return this.parse(firstSourceFile);
        }
        if (sourceFiles.size() != 1 || Files.exists(Path.of(firstSourceFile, new String[0]), new LinkOption[0])) {
            ImmutableList sourcePaths = Collections3.transformedImmutableListCopy(sourceFiles, x$0 -> Path.of(x$0, new String[0]));
            this.javaClassPaths = FluentIterable.concat(this.javaClassPaths, (Iterable)sourcePaths).toList();
            this.javaSourcePaths = FluentIterable.concat(this.javaSourcePaths, (Iterable)sourcePaths).toList();
            return this.parse(this.entryMethod);
        }
        if (this.javaSourcePaths.isEmpty()) {
            throw new JParserException("Path '" + firstSourceFile + "' does not exist. If this is the name of the main class, then either class path or source path need to be given with -classpath/-sourcepath.");
        }
        throw new JParserException("Could not find class " + firstSourceFile + " in the specified paths");
    }

    private ParseResult parse(String entryPoint) throws JParserException, IOException {
        String mainClass = entryPoint;
        Optional<Path> mainClassFile = this.searchForClassFile(mainClass);
        if (mainClassFile.isEmpty() && mainClass.contains(".")) {
            mainClass = mainClass.substring(0, mainClass.lastIndexOf(46));
            mainClassFile = this.searchForClassFile(mainClass);
        }
        if (mainClassFile.isEmpty()) {
            throw new JParserException("Could not find class " + mainClass + " in the specified paths");
        }
        Scope scope = this.prepareScope(mainClass);
        ParseResult result = this.buildCFA(this.parse(mainClassFile.orElseThrow()), scope);
        this.exportTypeHierarchy(scope);
        return result;
    }

    private void exportTypeHierarchy(Scope pScope) {
        if (this.exportTypeHierarchy && this.exportTypeHierarchyFile != null) {
            try (Writer w = IO.openOutputFile((Path)this.exportTypeHierarchyFile, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]);){
                THDotBuilder.generateDOT(w, pScope);
            }
            catch (IOException e) {
                this.logger.logUserException(Level.WARNING, (Throwable)e, "Could not write TypeHierarchy to dot file");
            }
        }
    }

    private Scope prepareScope(String mainClassName) throws JParserException, IOException {
        List<JavaFileAST> astsOfFoundFiles = this.getASTsOfProgram();
        TypeHierarchy typeHierarchy = TypeHierarchy.createTypeHierachy(this.logger, astsOfFoundFiles);
        return new Scope(mainClassName, typeHierarchy, this.logger);
    }

    private List<JavaFileAST> getASTsOfProgram() throws IOException {
        ArrayList<JavaFileAST> astsOfFoundFiles = new ArrayList<JavaFileAST>();
        HashSet<Path> alreadyParsedPaths = new HashSet<Path>();
        for (Path directory : this.javaSourcePaths) {
            Stream<Path> files = this.getJavaFilesInPath(directory);
            try {
                for (Path filePath : (ImmutableList)files.collect(ImmutableList.toImmutableList())) {
                    if (!alreadyParsedPaths.add(filePath)) continue;
                    CompilationUnit ast = this.parse(filePath, true);
                    astsOfFoundFiles.add(new JavaFileAST(filePath, ast));
                }
            }
            finally {
                if (files == null) continue;
                files.close();
            }
        }
        return astsOfFoundFiles;
    }

    @MustBeClosed
    private Stream<Path> getJavaFilesInPath(Path mainDirectory) throws IOException {
        return Files.walk(mainDirectory, FileVisitOption.FOLLOW_LINKS).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(file -> file.toString().endsWith(JAVA_SOURCE_FILE_EXTENSION)).filter(file -> {
            if (Files.isReadable(file)) {
                return true;
            }
            this.logger.log(Level.WARNING, new Object[]{"No permission to read java file %s.", file});
            return false;
        });
    }

    @Override
    public ParseResult parseString(Path pFilename, String pCode) throws JParserException {
        throw new JParserException("Function not yet implemented");
    }

    private CompilationUnit parse(Path file) throws IOException {
        return this.parse(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompilationUnit parse(Path file, boolean ignoreMethodBody) throws IOException {
        if (!this.parsedFiles.contains(file)) {
            this.parsedFiles.add(file);
        }
        String[] encodings = Collections.nCopies(this.javaSourcePaths.size(), this.encoding.name()).toArray(new String[0]);
        this.parser.setEnvironment(this.asStrings((List<Path>)this.javaClassPaths), this.asStrings((List<Path>)this.javaSourcePaths), encodings, false);
        this.parser.setResolveBindings(true);
        this.parser.setStatementsRecovery(true);
        this.parser.setBindingsRecovery(true);
        Hashtable options = JavaCore.getOptions();
        JavaCore.setComplianceOptions((String)this.version, (Map)options);
        this.parser.setCompilerOptions((Map)options);
        this.parseTimer.start();
        try {
            this.parser.setUnitName(file.normalize().toString());
            this.parser.setSource(IO.toCharArray((CharSource)MoreFiles.asCharSource((Path)file, (Charset)this.encoding, (OpenOption[])new OpenOption[0])));
            this.parser.setIgnoreMethodBodies(ignoreMethodBody);
            CompilationUnit compilationUnit = (CompilationUnit)this.parser.createAST(null);
            return compilationUnit;
        }
        finally {
            this.parseTimer.stop();
        }
    }

    private String[] asStrings(List<Path> files) {
        return (String[])files.stream().map(Path::toString).toArray(String[]::new);
    }

    private ParseResult buildCFA(CompilationUnit ast, Scope scope) throws IOException, JParserException {
        this.cfaTimer.start();
        CFABuilder builder = new CFABuilder(this.logger, scope);
        try {
            ast.accept((ASTVisitor)builder);
            while (scope.hasLocalClassPending()) {
                AnonymousClassDeclaration nextLocalClassToBeParsed = scope.getNextLocalClass();
                nextLocalClassToBeParsed.accept((ASTVisitor)builder);
            }
            String nextClassToBeParsed = scope.getNextClass();
            while (nextClassToBeParsed != null) {
                Optional<Path> classFile = this.searchForClassFile(nextClassToBeParsed);
                if (classFile.isPresent()) {
                    this.cfaTimer.stop();
                    CompilationUnit astNext = this.parse(classFile.orElseThrow());
                    this.cfaTimer.start();
                    astNext.accept((ASTVisitor)builder);
                }
                while (scope.hasLocalClassPending()) {
                    AnonymousClassDeclaration nextLocalClassToBeParsed = scope.getNextLocalClass();
                    nextLocalClassToBeParsed.accept((ASTVisitor)builder);
                }
                nextClassToBeParsed = scope.getNextClass();
            }
            DynamicBindingCreator tracker = new DynamicBindingCreator(builder);
            tracker.trackAndCreateDynamicBindings();
            ParseResult parseResult = new ParseResult(builder.getCFAs(), builder.getCFANodes(), builder.getStaticFieldDeclarations(), this.parsedFiles);
            return parseResult;
        }
        catch (CFAGenerationRuntimeException e) {
            throw new JParserException(e);
        }
        finally {
            this.cfaTimer.stop();
        }
    }

    private Optional<Path> searchForClassFile(String nextClassToBeParsed) {
        String classFilePathPart = nextClassToBeParsed.replace('.', File.separatorChar) + JAVA_SOURCE_FILE_EXTENSION;
        return this.javaSourcePaths.stream().map(sourcePath -> sourcePath.resolve(classFilePathPart)).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst();
    }

    @Override
    public Timer getParseTime() {
        return this.parseTimer;
    }

    @Override
    public Timer getCFAConstructionTime() {
        return this.cfaTimer;
    }

    static final class JavaFileAST {
        private final Path file;
        private final CompilationUnit ast;

        public JavaFileAST(Path pFile, CompilationUnit pAst) {
            this.file = pFile;
            this.ast = pAst;
        }

        public CompilationUnit getAst() {
            return this.ast;
        }

        public Path getFile() {
            return this.file;
        }
    }
}

