/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

final class NameConverter {
    private static final String DELIMITER = "_";

    private NameConverter() {
    }

    public static String convertName(IMethodBinding binding) {
        StringBuilder name = new StringBuilder(NameConverter.convertClassOrInterfaceToFullName(binding.getDeclaringClass()) + DELIMITER + binding.getName());
        Object[] parameterTypes = binding.getParameterTypes();
        if (parameterTypes.length > 0) {
            name.append(DELIMITER);
        }
        Joiner.on((String)DELIMITER).appendTo(name, (Iterable)FluentIterable.from((Object[])parameterTypes).transform(NameConverter::convertTypeName));
        return name.toString();
    }

    private static String convertTypeName(ITypeBinding binding) {
        if (binding.getBinaryName().equals("String") || binding.getQualifiedName().equals("java.lang.String")) {
            return "java_lang_String";
        }
        if (binding.isArray()) {
            ITypeBinding elementType = binding.getElementType();
            if (elementType.getBinaryName().equals("String") || elementType.getQualifiedName().equals("java.lang.String")) {
                return "String[]";
            }
            return elementType.getQualifiedName() + "[]";
        }
        return binding.getQualifiedName();
    }

    public static String convertName(IVariableBinding vb) {
        StringBuilder name = new StringBuilder();
        if (vb.isField() && vb.getDeclaringClass() != null) {
            String declaringClassName = NameConverter.convertClassOrInterfaceToFullName(vb.getDeclaringClass());
            name.append(declaringClassName + DELIMITER);
        }
        name.append(vb.getName());
        return name.toString();
    }

    public static String convertClassOrInterfaceToFullName(ITypeBinding classBinding) {
        if (classBinding.isAnonymous()) {
            String key = classBinding.getKey();
            assert (key.charAt(key.length() - 1) == ';');
            return key.substring(0, key.length() - 1);
        }
        if (classBinding.isRecovered()) {
            try {
                String name = classBinding.getName();
                Class.forName("java.lang." + name);
                return "java.lang." + classBinding.getName();
            }
            catch (ClassNotFoundException e) {
                return classBinding.getQualifiedName();
            }
        }
        return classBinding.getQualifiedName();
    }

    public static String convertClassOrInterfaceToSimpleName(ITypeBinding classBinding) {
        if (classBinding.isAnonymous()) {
            String key = classBinding.getKey();
            assert (key.charAt(key.length() - 1) == ';');
            return key.substring(0, key.length() - 1);
        }
        return classBinding.getName();
    }

    public static String convertDefaultConstructorName(ITypeBinding classBinding) {
        if (classBinding.isAnonymous()) {
            return NameConverter.convertAnonymousClassConstructorName(classBinding, (List<JType>)ImmutableList.of());
        }
        return NameConverter.convertClassOrInterfaceToFullName(classBinding) + DELIMITER + NameConverter.convertClassOrInterfaceToSimpleName(classBinding);
    }

    public static String convertAnonymousClassConstructorName(ITypeBinding pClassBinding, List<JType> pParameters) {
        ITypeBinding declaringClassBinding = pClassBinding.getDeclaringClass();
        assert (declaringClassBinding != null) : "Anonymous class must be nested!";
        StringBuilder name = new StringBuilder(NameConverter.convertClassOrInterfaceToFullName(declaringClassBinding) + "." + NameConverter.convertClassOrInterfaceToFullName(pClassBinding) + DELIMITER + NameConverter.convertClassOrInterfaceToSimpleName(pClassBinding));
        if (!pParameters.isEmpty()) {
            name.append(DELIMITER);
        }
        ArrayList<String> parameterTypeNames = new ArrayList<String>(pParameters.size());
        for (JType t : pParameters) {
            parameterTypeNames.add(t.toString());
        }
        Joiner.on((String)DELIMITER).appendTo(name, parameterTypeNames);
        return name.toString();
    }

    public static String createQualifiedName(String pMethodName, String pVariableName) {
        return pMethodName + "::" + pVariableName;
    }
}

