/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.java.JConstructorDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.NameConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierarchy;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JConstructorType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JMethodType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

class Scope {
    private static final String RETURN_VAR_NAME = "__retval__";
    private final TypeHierarchy typeHierarchy;
    private final ArrayDeque<Map<String, JSimpleDeclaration>> varsStack = new ArrayDeque();
    private final ArrayDeque<Map<String, JSimpleDeclaration>> varsList = new ArrayDeque();
    private final Deque<Map<String, JSimpleDeclaration>> varsStackWitNewNames = new ArrayDeque<Map<String, JSimpleDeclaration>>();
    private final ArrayDeque<Map<String, JSimpleDeclaration>> varsListWithNewNames = new ArrayDeque();
    private Map<String, JMethodDeclaration> methods;
    private Map<String, JFieldDeclaration> fields;
    private String currentMethodName = null;
    private Optional<JVariableDeclaration> returnVariable;
    private final Deque<JClassOrInterfaceType> classStack = new ArrayDeque<JClassOrInterfaceType>();
    private final String fullyQualifiedMainClassName;
    private final Queue<String> classesToBeParsed = new ConcurrentLinkedQueue<String>();
    private final Queue<AnonymousClassDeclaration> localClassesToBeParsed = new ConcurrentLinkedQueue<AnonymousClassDeclaration>();
    private final Set<String> registeredClasses = new HashSet<String>();
    private final LogManager logger;

    public Scope(String pFullyQualifiedMainClassName, TypeHierarchy pTypeHierarchy, LogManager pLogger) {
        this.fullyQualifiedMainClassName = pFullyQualifiedMainClassName;
        this.enterProgramScope();
        this.registeredClasses.add(this.fullyQualifiedMainClassName);
        this.methods = pTypeHierarchy.getMethodDeclarations();
        this.fields = pTypeHierarchy.getFieldDeclarations();
        this.typeHierarchy = pTypeHierarchy;
        this.logger = pLogger;
    }

    private void enterProgramScope() {
        this.varsStack.addLast(new HashMap());
        this.varsList.addLast(this.varsStack.getLast());
        this.varsStackWitNewNames.addLast(new HashMap());
        this.varsListWithNewNames.addLast(this.varsStackWitNewNames.getLast());
    }

    public boolean isProgramScope() {
        return this.varsStack.size() == 1 && this.classStack.isEmpty();
    }

    public boolean isTopClassScope() {
        return this.varsStack.size() == 1 && this.classStack.size() == 1;
    }

    public void enterMethod(JMethodDeclaration methodDef) {
        this.currentMethodName = methodDef.getOrigName();
        this.returnVariable = Optional.ofNullable(this.createFunctionReturnVariable(methodDef));
        this.enterBlock();
    }

    private JVariableDeclaration createFunctionReturnVariable(JMethodDeclaration pMethod) {
        FileLocation fileLocation = pMethod.getFileLocation();
        JType returnType = pMethod.getType().getReturnType();
        String qualifiedReturnVarName = this.createQualifiedName(RETURN_VAR_NAME);
        if (JSimpleType.getVoid().equals(returnType)) {
            return null;
        }
        return new JVariableDeclaration(fileLocation, returnType, RETURN_VAR_NAME, RETURN_VAR_NAME, qualifiedReturnVarName, null, false);
    }

    public Optional<JVariableDeclaration> getReturnVariable() {
        Preconditions.checkState((this.returnVariable != null ? 1 : 0) != 0);
        return this.returnVariable;
    }

    public String createQualifiedName(String pVariableName) {
        return NameConverter.createQualifiedName(this.getCurrentMethodName(), pVariableName);
    }

    public void enterClass(JClassOrInterfaceType enteredClassType) {
        if (!this.typeHierarchy.containsType(enteredClassType)) {
            throw new CFAGenerationRuntimeException("Could not find Type for Class" + enteredClassType.getName());
        }
        this.classStack.push(enteredClassType);
    }

    public void leaveClass() {
        if (this.classStack.isEmpty()) {
            throw new CFAGenerationRuntimeException("Could not find enclosing class of nested class " + this.classStack.peek());
        }
        this.classStack.pop();
    }

    public void leaveMethod() {
        Preconditions.checkState((!this.isTopClassScope() ? 1 : 0) != 0);
        this.varsStack.removeLast();
        while (this.varsList.size() > this.varsStack.size()) {
            this.varsList.removeLast();
        }
        while (this.varsListWithNewNames.size() > this.varsStackWitNewNames.size()) {
            this.varsListWithNewNames.removeLast();
        }
        this.currentMethodName = null;
    }

    public void enterBlock() {
        this.varsStack.addLast(new HashMap());
        this.varsList.addLast(this.varsStack.getLast());
        this.varsStackWitNewNames.addLast(new HashMap());
        this.varsListWithNewNames.addLast(this.varsStackWitNewNames.getLast());
    }

    public void leaveBlock() {
        Preconditions.checkState((this.varsStack.size() > 2 ? 1 : 0) != 0);
        this.varsStack.removeLast();
        this.varsStackWitNewNames.removeLast();
    }

    public boolean variableNameInUse(String name, String origName) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)origName);
        Iterator<Map<String, JSimpleDeclaration>> it = this.varsListWithNewNames.descendingIterator();
        while (it.hasNext()) {
            Map<String, JSimpleDeclaration> vars = it.next();
            JSimpleDeclaration binding = vars.get(name);
            if (binding != null && binding.getName().equals(name)) {
                return true;
            }
            binding = vars.get(name);
            if (binding == null || !binding.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public JSimpleDeclaration lookupVariable(String name) {
        Preconditions.checkNotNull((Object)name);
        Iterator<Map<String, JSimpleDeclaration>> it = this.varsStack.descendingIterator();
        while (it.hasNext()) {
            Map<String, JSimpleDeclaration> vars = it.next();
            JSimpleDeclaration binding = vars.get(name);
            if (binding == null) continue;
            return binding;
        }
        return this.fields.getOrDefault(name, null);
    }

    public JMethodDeclaration lookupMethod(String name) {
        return this.methods.get(Preconditions.checkNotNull((Object)name));
    }

    public boolean isMethodRegistered(String name) {
        return this.methods.containsKey(Preconditions.checkNotNull((Object)name));
    }

    public void registerDeclarationOfThisClass(JSimpleDeclaration declaration) {
        Preconditions.checkArgument((declaration instanceof JVariableDeclaration || declaration instanceof JParameterDeclaration ? 1 : 0) != 0, (String)"Tried to register a declaration which does not define a name in the standard namespace: %s", (Object)declaration);
        Preconditions.checkArgument((!(declaration instanceof JFieldDeclaration) ? 1 : 0) != 0, (Object)"Can't register a field declaration, it has to be updated within the type Hierarchy");
        String name = declaration.getOrigName();
        assert (name != null);
        Map<String, JSimpleDeclaration> vars = this.varsStack.getLast();
        Map<String, JSimpleDeclaration> varsWithNewNames = this.varsStackWitNewNames.getLast();
        if (this.isProgramScope()) {
            throw new CFAGenerationRuntimeException("Could not find Class for Declaration " + declaration.getName(), declaration);
        }
        if (vars.containsKey(declaration.getName())) {
            throw new CFAGenerationRuntimeException("Variable " + name + " already declared", declaration);
        }
        vars.put(name, declaration);
        varsWithNewNames.put(declaration.getName(), declaration);
    }

    public String getCurrentMethodName() {
        return this.currentMethodName;
    }

    public String toString() {
        return "Functions: " + Joiner.on((char)' ').join(this.methods.keySet());
    }

    public void registerClass(ITypeBinding classBinding) {
        String className = NameConverter.convertClassOrInterfaceToFullName(classBinding);
        String topClassName = this.getTopLevelClass(classBinding);
        ArrayDeque<? extends JClassOrInterfaceType> toBeAdded = new ArrayDeque<JClassOrInterfaceType>();
        if (!this.registeredClasses.contains(className)) {
            if (!this.registeredClasses.contains(topClassName)) {
                this.classesToBeParsed.add(topClassName);
            }
            this.registeredClasses.add(className);
        } else if (!this.fullyQualifiedMainClassName.equals(className)) {
            return;
        }
        JClassOrInterfaceType type = this.typeHierarchy.getType(className);
        if (type == null) {
            this.logger.log(Level.WARNING, new Object[]{"Could not resolve type of ", className});
            type = classBinding.isInterface() ? JInterfaceType.createUnresolvableType() : JClassType.createUnresolvableType();
        }
        toBeAdded.addAll(type.getAllSubTypesOfType());
        for (JClassOrInterfaceType jClassOrInterfaceType : toBeAdded) {
            String name = jClassOrInterfaceType.getName();
            if (!this.registeredClasses.add(name)) continue;
            this.classesToBeParsed.add(name);
        }
    }

    private String getTopLevelClass(ITypeBinding classBinding) {
        ITypeBinding nextClass = classBinding;
        ITypeBinding declaringClass = nextClass.getDeclaringClass();
        while (declaringClass != null) {
            nextClass = declaringClass;
            declaringClass = nextClass.getDeclaringClass();
        }
        assert (nextClass.isTopLevel());
        return NameConverter.convertClassOrInterfaceToFullName(nextClass);
    }

    public String getNextClass() {
        assert (!this.hasLocalClassPending()) : "Local classes need to be parsed first!";
        if (this.classesToBeParsed.isEmpty()) {
            return null;
        }
        return this.classesToBeParsed.poll();
    }

    public boolean hasLocalClassPending() {
        return !this.localClassesToBeParsed.isEmpty();
    }

    public AnonymousClassDeclaration getNextLocalClass() {
        return this.localClassesToBeParsed.poll();
    }

    public String getFullyQualifiedMainClassName() {
        return this.fullyQualifiedMainClassName;
    }

    public JClassOrInterfaceType getCurrentClassType() {
        return this.classStack.peek();
    }

    public Set<JFieldDeclaration> getFieldDeclarations(JClassOrInterfaceType pType) {
        return this.typeHierarchy.getFieldDeclarations(pType);
    }

    public Map<String, JFieldDeclaration> getStaticFieldDeclarations() {
        HashMap<String, JFieldDeclaration> result = new HashMap<String, JFieldDeclaration>();
        for (JFieldDeclaration declaration : this.fields.values()) {
            if (!declaration.isStatic()) continue;
            result.put(declaration.getName(), declaration);
        }
        return result;
    }

    public Map<String, JFieldDeclaration> getNonStaticFieldDeclarationOfClass(JClassOrInterfaceType pType) {
        if (this.typeHierarchy.isExternType(pType)) {
            return ImmutableMap.of();
        }
        Set<JFieldDeclaration> fieldDecls = this.getFieldDeclarations(pType);
        for (JFieldDeclaration declaration : fieldDecls) {
            if (declaration.isStatic()) continue;
            return ImmutableMap.of((Object)declaration.getName(), (Object)declaration);
        }
        return ImmutableMap.of();
    }

    public Path getFileOfCurrentType() {
        return this.typeHierarchy.getFileOfType(this.classStack.peek());
    }

    public boolean containsInterfaceType(String typeName) {
        return this.typeHierarchy.containsInterfaceType(typeName);
    }

    public JInterfaceType getInterfaceType(String typeName) {
        return this.typeHierarchy.getInterfaceType(typeName);
    }

    public boolean containsClassType(String pTypeName) {
        return this.typeHierarchy.containsClassType(pTypeName);
    }

    public JClassType getClassType(String pTypeName) {
        return this.typeHierarchy.getClassType(pTypeName);
    }

    public JInterfaceType createNewInterfaceType(ITypeBinding pTypeBinding) {
        this.typeHierarchy.updateTypeHierarchy(pTypeBinding);
        String newTypeName = NameConverter.convertClassOrInterfaceToFullName(pTypeBinding);
        if (this.containsInterfaceType(newTypeName)) {
            return this.getInterfaceType(newTypeName);
        }
        return JInterfaceType.createUnresolvableType();
    }

    public JClassType createNewClassType(ITypeBinding pTypeBinding) {
        this.typeHierarchy.updateTypeHierarchy(pTypeBinding);
        String newTypeName = NameConverter.convertClassOrInterfaceToFullName(pTypeBinding);
        if (this.containsClassType(newTypeName)) {
            return this.getClassType(newTypeName);
        }
        return JClassType.createUnresolvableType();
    }

    public JClassType addAnonymousClassDeclaration(AnonymousClassDeclaration pDeclaration) {
        this.typeHierarchy.updateTypeHierarchy(pDeclaration, this.getFileOfCurrentType(), this.logger);
        this.methods = this.typeHierarchy.getMethodDeclarations();
        this.fields = this.typeHierarchy.getFieldDeclarations();
        String pDeclarationName = NameConverter.convertClassOrInterfaceToFullName(pDeclaration.resolveBinding());
        this.localClassesToBeParsed.add(pDeclaration);
        return (JClassType)Preconditions.checkNotNull((Object)this.typeHierarchy.getClassType(pDeclarationName));
    }

    public JMethodDeclaration createExternMethodDeclaration(JMethodType pConvertMethodType, String pName, String pSimpleName, VisibilityModifier pPublic, boolean pFinal, boolean pAbstract, boolean pStatic, boolean pNative, boolean pSynchronized, boolean pStrictFp, JClassOrInterfaceType pDeclaringClassType) {
        JMethodDeclaration decl = JMethodDeclaration.createExternMethodDeclaration(pConvertMethodType, pName, pSimpleName, pPublic, pFinal, pAbstract, pStatic, pNative, pSynchronized, pStrictFp, pDeclaringClassType);
        Preconditions.checkArgument((!this.methods.containsKey(decl.getName()) ? 1 : 0) != 0);
        this.methods.put(decl.getName(), decl);
        return decl;
    }

    public JConstructorDeclaration createExternConstructorDeclaration(JConstructorType pConvertConstructorType, String pName, String pSimpleName, VisibilityModifier pVisibility, boolean pStrictFp, JClassType pDeclaringClassType) {
        JConstructorDeclaration decl = JConstructorDeclaration.createExternConstructorDeclaration(pConvertConstructorType, pName, pSimpleName, pVisibility, pStrictFp, pDeclaringClassType);
        Preconditions.checkArgument((!this.methods.containsKey(decl.getName()) ? 1 : 0) != 0);
        this.methods.put(decl.getName(), decl);
        return decl;
    }

    public boolean isFieldRegistered(String pFieldName) {
        return this.fields.containsKey(pFieldName);
    }

    public JFieldDeclaration lookupField(String pFieldName) {
        Preconditions.checkArgument((boolean)this.fields.containsKey(pFieldName));
        return this.fields.get(pFieldName);
    }

    public JFieldDeclaration createExternFieldDeclaration(JType pType, String pName, String pSimpleName, boolean pIsFinal, boolean pIsStatic, VisibilityModifier pVisibility, boolean pIsVolatile, boolean pIsTransient) {
        JFieldDeclaration decl = JFieldDeclaration.createExternFieldDeclaration(pType, pName, pSimpleName, pIsFinal, pIsStatic, pIsTransient, pIsVolatile, pVisibility);
        Preconditions.checkArgument((!this.fields.containsKey(decl.getName()) ? 1 : 0) != 0);
        this.fields.put(decl.getName(), decl);
        return decl;
    }

    public TypeHierarchy getTypeHierarchy() {
        return this.typeHierarchy;
    }
}

