/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Preconditions;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.CFAGenerationRuntimeException;
import org.sosy_lab.cpachecker.cfa.types.java.JArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JSimpleType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

abstract class TypeConverter {
    TypeConverter() {
    }

    public final JType convert(Type t) {
        if (t.getNodeType() == 39) {
            return this.convert((PrimitiveType)t);
        }
        if (t.getNodeType() == 5) {
            return this.convert((ArrayType)t);
        }
        if (t.getNodeType() == 75) {
            return this.convert((QualifiedType)t);
        }
        if (t.getNodeType() == 43) {
            return this.convert((SimpleType)t);
        }
        if (t.getNodeType() == 74) {
            return this.convert(((ParameterizedType)t).getType());
        }
        return JSimpleType.getUnspecified();
    }

    private JType convert(QualifiedType t) {
        boolean canBeResolved;
        ITypeBinding binding = t.resolveBinding();
        boolean bl = canBeResolved = binding != null;
        if (canBeResolved) {
            return this.convert(binding);
        }
        return JSimpleType.getUnspecified();
    }

    private JType convert(SimpleType t) {
        boolean canBeResolved;
        ITypeBinding binding = t.resolveBinding();
        boolean bl = canBeResolved = binding != null;
        if (canBeResolved) {
            return this.convert(binding);
        }
        return JSimpleType.getUnspecified();
    }

    public final JType convert(ITypeBinding t) {
        if (t == null) {
            return JSimpleType.getUnspecified();
        }
        if (t.isPrimitive()) {
            return this.convertPrimitiveType(t.getName());
        }
        if (t.isArray()) {
            return new JArrayType(this.convert(t.getElementType()), t.getDimensions());
        }
        if (t.isClass() || t.isEnum()) {
            return this.convertClassType(t);
        }
        if (t.isInterface()) {
            return this.convertInterfaceType(t);
        }
        return JSimpleType.getUnspecified();
    }

    public final JType convert(Expression pExpression) {
        ITypeBinding binding = pExpression.resolveTypeBinding();
        return this.convert(binding);
    }

    public abstract JClassType convertClassType(ITypeBinding var1);

    public abstract JInterfaceType convertInterfaceType(ITypeBinding var1);

    public final JClassOrInterfaceType convertClassOrInterfaceType(ITypeBinding pT) {
        Preconditions.checkArgument((pT.isClass() || pT.isEnum() || pT.isInterface() ? 1 : 0) != 0);
        if (pT.isInterface()) {
            return this.convertInterfaceType(pT);
        }
        return this.convertClassType(pT);
    }

    private JSimpleType convert(PrimitiveType t) {
        PrimitiveType.Code primitiveTypeName = t.getPrimitiveTypeCode();
        return this.convertPrimitiveType(primitiveTypeName.toString());
    }

    private JSimpleType convertPrimitiveType(String primitiveTypeName) {
        JSimpleType type;
        switch (primitiveTypeName) {
            case "boolean": {
                type = JSimpleType.getBoolean();
                break;
            }
            case "char": {
                type = JSimpleType.getChar();
                break;
            }
            case "double": {
                type = JSimpleType.getDouble();
                break;
            }
            case "float": {
                type = JSimpleType.getFloat();
                break;
            }
            case "int": {
                type = JSimpleType.getInt();
                break;
            }
            case "void": {
                type = JSimpleType.getVoid();
                break;
            }
            case "long": {
                type = JSimpleType.getLong();
                break;
            }
            case "short": {
                type = JSimpleType.getShort();
                break;
            }
            case "byte": {
                type = JSimpleType.getByte();
                break;
            }
            default: {
                throw new CFAGenerationRuntimeException("Unknown primitive type " + primitiveTypeName);
            }
        }
        return type;
    }

    private JArrayType convert(ArrayType t) {
        return new JArrayType(this.convert(t.getElementType()), t.getDimensions());
    }
}

