/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.EclipseJavaParser;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.THTypeConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierachyConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierarchy;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.exceptions.JParserException;

class TypeHierachyCreator
extends ASTVisitor {
    private static final boolean VISIT_CHILDREN = true;
    private static final boolean SKIP_CHILDREN = false;
    private static final int FIRST = 0;
    private final LogManager logger;
    private final TypeHierarchy.THTypeTable typeTable;
    private final TypeHierachyConverter converter;
    private Path fileOfCU;
    private boolean classNameException = false;
    private String className;
    private String expectedName;

    public TypeHierachyCreator(LogManager pLogger, TypeHierarchy.THTypeTable pTypeTable) {
        this.logger = pLogger;
        this.typeTable = pTypeTable;
        this.converter = new TypeHierachyConverter(this.logger, this.typeTable);
    }

    public TypeHierachyCreator(LogManager pLogger, TypeHierarchy.THTypeTable pTypeTable, Path fileName) {
        this.logger = pLogger;
        this.typeTable = pTypeTable;
        this.converter = new TypeHierachyConverter(this.logger, this.typeTable);
        this.fileOfCU = fileName;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void createTypeHierachy(List<EclipseJavaParser.JavaFileAST> pJavaProgram) throws JParserException {
        Path oldFileOfCU = this.fileOfCU;
        for (EclipseJavaParser.JavaFileAST ast : pJavaProgram) {
            this.fileOfCU = ast.getFile();
            CompilationUnit cu = ast.getAst();
            cu.accept((ASTVisitor)this);
            if (!this.classNameException) continue;
            throw new JParserException("The top-level class " + this.className + " is not declared within a file with the expected filename " + this.expectedName + ".\n It is instead declared in " + this.fileOfCU);
        }
        this.fileOfCU = oldFileOfCU;
    }

    public boolean visit(MethodDeclaration pMd) {
        JMethodDeclaration decl = this.converter.convert(pMd, this.fileOfCU);
        this.typeTable.registerMethodDeclaration(decl);
        return false;
    }

    public boolean visit(FieldDeclaration fD) {
        Set<JFieldDeclaration> decl = this.converter.convert(fD, this.fileOfCU);
        VariableDeclarationFragment vdf = (VariableDeclarationFragment)fD.fragments().get(0);
        IVariableBinding variableBinding = vdf.resolveBinding();
        Preconditions.checkNotNull((Object)variableBinding);
        ITypeBinding typeBinding = variableBinding.getDeclaringClass();
        Preconditions.checkNotNull((Object)typeBinding);
        JClassOrInterfaceType declaringClass = this.converter.convertClassOrInterfaceType(typeBinding);
        this.typeTable.registerFieldDeclaration(decl, declaringClass);
        return false;
    }

    public boolean visit(EnumDeclaration node) {
        ITypeBinding typeBinding = node.resolveBinding();
        if (typeBinding != null) {
            JClassOrInterfaceType type = this.converter.convertClassOrInterfaceType(typeBinding);
            this.typeTable.registerFileNameOfType(type, this.fileOfCU);
        }
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        ITypeBinding typeBinding = node.resolveBinding();
        if (typeBinding != null) {
            if (typeBinding.isTopLevel()) {
                String simpleName;
                String expectedFilename;
                boolean isPublic = false;
                for (Object mod : node.modifiers()) {
                    if (!(mod instanceof Modifier) || !((Modifier)mod).isPublic()) continue;
                    isPublic = true;
                    break;
                }
                if (isPublic && !(expectedFilename = (simpleName = node.getName().getIdentifier()) + ".java").equals(this.fileOfCU.getFileName().toString())) {
                    this.classNameException = true;
                    this.expectedName = expectedFilename;
                    this.className = simpleName;
                    return false;
                }
            }
            JClassOrInterfaceType type = this.converter.convertClassOrInterfaceType(typeBinding);
            this.typeTable.registerFileNameOfType(type, this.fileOfCU);
        } else {
            this.logger.logf(Level.WARNING, "Type %s has no binding.", new Object[]{node.toString()});
        }
        return !this.classNameException;
    }

    public boolean visit(AnonymousClassDeclaration pDeclaration) {
        ITypeBinding classBinding = pDeclaration.resolveBinding();
        Preconditions.checkNotNull((Object)classBinding);
        Preconditions.checkArgument((classBinding.isClass() || classBinding.isEnum() || classBinding.isInterface() ? 1 : 0) != 0);
        THTypeConverter typeConverter = new THTypeConverter(this.typeTable);
        JClassOrInterfaceType classType = typeConverter.convertClassOrInterfaceType(classBinding);
        this.typeTable.registerFileNameOfType(classType, this.fileOfCU);
        return true;
    }

    public TypeHierarchy.THTypeTable getTypeTable() {
        return this.typeTable;
    }
}

