/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.eclipse.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.java.JFieldDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.java.JMethodDeclaration;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.EclipseJavaParser;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.THTypeConverter;
import org.sosy_lab.cpachecker.cfa.parser.eclipse.java.TypeHierachyCreator;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;
import org.sosy_lab.cpachecker.exceptions.JParserException;

final class TypeHierarchy {
    private Map<String, JClassOrInterfaceType> types;
    private Map<JClassOrInterfaceType, Path> fileOfTypes;
    private Map<JClassOrInterfaceType, Set<JMethodDeclaration>> methodDeclarationsOfType;
    private Map<JClassOrInterfaceType, ImmutableSet<JFieldDeclaration>> fieldDeclarationsOfType;
    private THTypeTable typeTable;

    private TypeHierarchy(THTypeTable pTypeTable) {
        Preconditions.checkNotNull((Object)pTypeTable);
        this.typeTable = pTypeTable;
        this.types = pTypeTable.getTypes();
        this.fileOfTypes = pTypeTable.getTypeOfFiles();
        this.methodDeclarationsOfType = pTypeTable.getMethodDeclarationsOfType();
        this.fieldDeclarationsOfType = pTypeTable.getFieldDeclarationsOfType();
    }

    public Set<JClassOrInterfaceType> getTypes() {
        HashSet<JClassOrInterfaceType> typeSet = new HashSet<JClassOrInterfaceType>();
        for (JClassOrInterfaceType type : this.types.values()) {
            Preconditions.checkArgument((!typeSet.contains(type) ? 1 : 0) != 0);
            typeSet.add(type);
        }
        return typeSet;
    }

    public Map<JClassOrInterfaceType, Path> getFileOfTypes() {
        return this.fileOfTypes;
    }

    public Map<String, JMethodDeclaration> getMethodDeclarations() {
        HashMap<String, JMethodDeclaration> declarations = new HashMap<String, JMethodDeclaration>();
        for (Set<JMethodDeclaration> decls : this.methodDeclarationsOfType.values()) {
            for (JMethodDeclaration decl : decls) {
                String name = decl.getName();
                Preconditions.checkArgument((!declarations.containsKey(name) ? 1 : 0) != 0);
                declarations.put(name, decl);
            }
        }
        return declarations;
    }

    public Set<JMethodDeclaration> getMethodDeclarations(JClassOrInterfaceType type) {
        Preconditions.checkArgument((!this.isExternType(type) ? 1 : 0) != 0, (Object)"Can't get the declarations of extern types.");
        return this.methodDeclarationsOfType.get(type);
    }

    public Map<String, JFieldDeclaration> getFieldDeclarations() {
        HashMap<String, JFieldDeclaration> declarations = new HashMap<String, JFieldDeclaration>();
        for (Set set : this.fieldDeclarationsOfType.values()) {
            for (JFieldDeclaration decl : set) {
                String name = decl.getName();
                Preconditions.checkArgument((!declarations.containsKey(name) ? 1 : 0) != 0);
                declarations.put(name, decl);
            }
        }
        return declarations;
    }

    public Set<JFieldDeclaration> getFieldDeclarations(JClassOrInterfaceType type) {
        Preconditions.checkArgument((!this.isExternType(type) ? 1 : 0) != 0, (Object)"Can't get the declarations of extern types.");
        return (Set)this.fieldDeclarationsOfType.get(type);
    }

    public static TypeHierarchy createTypeHierachy(LogManager pLogger, List<EclipseJavaParser.JavaFileAST> pJavaProgram) throws JParserException {
        TypeHierachyCreator creator = new TypeHierachyCreator(pLogger, new THTypeTable());
        creator.createTypeHierachy(pJavaProgram);
        return new TypeHierarchy(creator.getTypeTable());
    }

    public boolean containsType(JClassOrInterfaceType pType) {
        return this.types.containsKey(pType.getName());
    }

    public boolean containsType(String pFullyQualifiedTypeName) {
        return this.types.containsKey(pFullyQualifiedTypeName);
    }

    public @Nullable JClassOrInterfaceType getType(String pFullyQualifiedTypeName) {
        return this.types.get(pFullyQualifiedTypeName);
    }

    public @Nullable Path getFileOfType(JClassOrInterfaceType pType) {
        return this.fileOfTypes.get(pType);
    }

    public boolean isExternType(JClassOrInterfaceType pType) {
        return !this.fileOfTypes.containsKey(pType);
    }

    public boolean containsInterfaceType(String pTypeName) {
        boolean exists = this.types.containsKey(pTypeName);
        boolean isInterface = this.types.get(pTypeName) instanceof JInterfaceType;
        return exists && isInterface;
    }

    public JInterfaceType getInterfaceType(String pTypeName) {
        JClassOrInterfaceType type = this.types.get(pTypeName);
        Preconditions.checkState((boolean)(type instanceof JInterfaceType), (Object)"Interface Type does not exist");
        return (JInterfaceType)this.types.get(pTypeName);
    }

    public boolean containsClassType(String pTypeName) {
        boolean exists = this.types.containsKey(pTypeName);
        boolean isClass = this.types.get(pTypeName) instanceof JClassType;
        return exists && isClass;
    }

    public JClassType getClassType(String pTypeName) {
        JClassOrInterfaceType type = this.types.get(pTypeName);
        Preconditions.checkState((boolean)(type instanceof JClassType), (Object)"Interface Type does not exist");
        return (JClassType)this.types.get(pTypeName);
    }

    void updateTypeHierarchy(ITypeBinding classOrInterfaceBinding) {
        Preconditions.checkNotNull((Object)classOrInterfaceBinding);
        Preconditions.checkArgument((classOrInterfaceBinding.isClass() || classOrInterfaceBinding.isEnum() || classOrInterfaceBinding.isInterface() ? 1 : 0) != 0);
        THTypeConverter converter = new THTypeConverter(this.typeTable);
        converter.convertClassOrInterfaceType(classOrInterfaceBinding);
        this.updateFromTypeTable(this.typeTable);
    }

    void updateTypeHierarchy(JClassType pJClassType) {
        if (this.typeTable.containsType(pJClassType.getName())) {
            return;
        }
        this.typeTable.registerType(pJClassType);
        for (JClassType superClass = pJClassType.getParentClass(); superClass != null && !this.typeTable.containsType(superClass.getName()); superClass = superClass.getParentClass()) {
            this.typeTable.registerType(superClass);
        }
        this.updateFromTypeTable(this.typeTable);
    }

    private void updateFromTypeTable(THTypeTable pTypeTable) {
        this.types = pTypeTable.getTypes();
        this.fileOfTypes = pTypeTable.getTypeOfFiles();
        this.methodDeclarationsOfType = pTypeTable.getMethodDeclarationsOfType();
        this.fieldDeclarationsOfType = pTypeTable.getFieldDeclarationsOfType();
        this.typeTable = pTypeTable;
    }

    void updateTypeHierarchy(AnonymousClassDeclaration pDeclaration, Path pFileName, LogManager pLogger) {
        TypeHierachyCreator hierarchyCreator = new TypeHierachyCreator(pLogger, this.typeTable, pFileName);
        pDeclaration.accept((ASTVisitor)hierarchyCreator);
        this.updateFromTypeTable(hierarchyCreator.getTypeTable());
    }

    static class THTypeTable {
        private final Map<String, JClassOrInterfaceType> types = new HashMap<String, JClassOrInterfaceType>();
        private final Map<JClassOrInterfaceType, Path> typeOfFiles = new HashMap<JClassOrInterfaceType, Path>();
        private final Map<JClassOrInterfaceType, Set<JMethodDeclaration>> methodDeclarationsOfType = new HashMap<JClassOrInterfaceType, Set<JMethodDeclaration>>();
        private final Map<JClassOrInterfaceType, ImmutableSet<JFieldDeclaration>> fieldDeclarationsOfType = new HashMap<JClassOrInterfaceType, ImmutableSet<JFieldDeclaration>>();

        private THTypeTable() {
            JClassType objectType = JClassType.getTypeOfObject();
            this.registerType(objectType);
        }

        public Map<String, JClassOrInterfaceType> getTypes() {
            return ImmutableMap.copyOf(this.types);
        }

        public Map<JClassOrInterfaceType, Path> getTypeOfFiles() {
            return new HashMap<JClassOrInterfaceType, Path>(this.typeOfFiles);
        }

        public void registerType(JClassOrInterfaceType pType) {
            this.types.put(pType.getName(), pType);
            this.methodDeclarationsOfType.put(pType, new HashSet());
            this.fieldDeclarationsOfType.put(pType, (ImmutableSet<JFieldDeclaration>)ImmutableSet.of());
        }

        public void registerMethodDeclaration(JMethodDeclaration pDecl) {
            JClassOrInterfaceType declaringClass = pDecl.getDeclaringClass();
            Preconditions.checkArgument((boolean)this.methodDeclarationsOfType.containsKey(declaringClass));
            Preconditions.checkArgument((!this.methodDeclarationsOfType.get(declaringClass).contains(pDecl) ? 1 : 0) != 0);
            this.methodDeclarationsOfType.get(declaringClass).add(pDecl);
        }

        public void registerFieldDeclaration(JFieldDeclaration pDecl, JClassOrInterfaceType declaringClass) {
            Preconditions.checkArgument((boolean)this.fieldDeclarationsOfType.containsKey(declaringClass));
            Preconditions.checkArgument((!this.fieldDeclarationsOfType.get(declaringClass).contains((Object)pDecl) ? 1 : 0) != 0);
            ImmutableSet jFieldDeclarations = this.fieldDeclarationsOfType.get(declaringClass);
            jFieldDeclarations = new ImmutableSet.Builder().addAll(jFieldDeclarations).add((Object)pDecl).build();
            this.fieldDeclarationsOfType.put(declaringClass, (ImmutableSet<JFieldDeclaration>)jFieldDeclarations);
        }

        public void registerFileNameOfType(JClassOrInterfaceType type, Path fileName) {
            this.typeOfFiles.put(type, fileName);
        }

        public boolean containsType(String typeName) {
            return this.types.containsKey(typeName);
        }

        public JClassOrInterfaceType getType(String typeName) {
            return this.types.get(typeName);
        }

        public Map<JClassOrInterfaceType, Set<JMethodDeclaration>> getMethodDeclarationsOfType() {
            return ImmutableMap.copyOf((Map)Maps.transformValues(this.methodDeclarationsOfType, ImmutableSet::copyOf));
        }

        public Map<JClassOrInterfaceType, ImmutableSet<JFieldDeclaration>> getFieldDeclarationsOfType() {
            return ImmutableMap.copyOf((Map)Maps.transformValues(this.fieldDeclarationsOfType, ImmutableSet::copyOf));
        }

        public void registerFieldDeclaration(Set<JFieldDeclaration> pDecl, JClassOrInterfaceType pDeclaringClass) {
            for (JFieldDeclaration decl : pDecl) {
                this.registerFieldDeclaration(decl, pDeclaringClass);
            }
        }
    }
}

