/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.llvm;

import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.TreeMultimap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AbstractExpression;
import org.sosy_lab.cpachecker.cfa.ast.AbstractInitializer;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.parser.llvm.LlvmTypeConverter;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.llvm_j.BasicBlock;
import org.sosy_lab.llvm_j.Function;
import org.sosy_lab.llvm_j.LLVMException;
import org.sosy_lab.llvm_j.Module;
import org.sosy_lab.llvm_j.TypeRef;
import org.sosy_lab.llvm_j.Value;

public class CFABuilder {
    private static final String RETURN_VAR_NAME = "__retval__";
    private static final String TMP_VAR_PREFIX_LOCAL = "__t_";
    private static final String TMP_VAR_PREFIX_GLOBAL = "__tg_";
    private static final CFunctionDeclaration ABORT_FUNC_DECL = new CFunctionDeclaration(FileLocation.DUMMY, new CFunctionType(CVoidType.VOID, (List<CType>)ImmutableList.of(), false), "abort", (List<CParameterDeclaration>)ImmutableList.of(), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
    private static final CExpression ABORT_FUNC_NAME = new CIdExpression(FileLocation.DUMMY, CVoidType.VOID, "abort", ABORT_FUNC_DECL);
    private static long tmpLocalVarCount = 0L;
    private static long tmpGlobalVarCount = 0L;
    private final LogManager logger;
    private final MachineModel machineModel;
    private final LlvmTypeConverter typeConverter;
    private CBinaryExpressionBuilder binaryExpressionBuilder;
    private final Map<Long, CSimpleDeclaration> variableDeclarations;
    private Map<String, CFunctionDeclaration> functionDeclarations;
    private int basicBlockId;
    protected NavigableMap<String, FunctionEntryNode> functions;
    protected TreeMultimap<String, CFANode> cfaNodes;
    protected List<Pair<ADeclaration, String>> globalDeclarations;

    public CFABuilder(LogManager pLogger, MachineModel pMachineModel) {
        this.logger = pLogger;
        this.machineModel = pMachineModel;
        this.typeConverter = new LlvmTypeConverter(pMachineModel, pLogger);
        this.variableDeclarations = new HashMap<Long, CSimpleDeclaration>();
        this.functionDeclarations = new HashMap<String, CFunctionDeclaration>();
        this.binaryExpressionBuilder = new CBinaryExpressionBuilder(this.machineModel, this.logger);
        this.basicBlockId = 0;
        this.functions = new TreeMap<String, FunctionEntryNode>();
        this.cfaNodes = TreeMultimap.create();
        this.globalDeclarations = new ArrayList<Pair<ADeclaration, String>>();
    }

    public ParseResult build(Module pModule, Path pFilename) throws LLVMException {
        this.visit(pModule, pFilename);
        ImmutableList input_file = ImmutableList.of((Object)pFilename);
        return new ParseResult(this.functions, this.cfaNodes, this.globalDeclarations, (List<Path>)input_file);
    }

    public void visit(Module pItem, Path pFileName) throws LLVMException {
        if (pItem.getFirstFunction() == null) {
            return;
        }
        this.addFunctionDeclarations(pItem, pFileName);
        this.iterateOverGlobals(pItem, pFileName);
        this.iterateOverFunctions(pItem, pFileName);
    }

    private void addFunctionDeclarations(Module pItem, Path pFileName) {
        for (Value func : pItem) {
            String funcName = func.getValueName();
            assert (!funcName.isEmpty());
            if (funcName.startsWith("llvm.")) continue;
            this.declareFunction(func, pFileName);
        }
    }

    private void iterateOverGlobals(Module pItem, Path pFileName) throws LLVMException {
        Value globalItem = pItem.getFirstGlobal();
        if (globalItem == null) {
            return;
        }
        Value globalItemLast = pItem.getLastGlobal();
        assert (globalItemLast != null);
        while (true) {
            CDeclaration decl = this.visitGlobalItem(globalItem, pFileName);
            this.globalDeclarations.add(Pair.of(decl, globalItem.toString()));
            if (globalItem.equals((Object)globalItemLast)) break;
            globalItem = globalItem.getNextGlobal();
        }
    }

    protected void addNode(String funcName, CFANode nd) {
        this.cfaNodes.put((Object)funcName, (Object)nd);
    }

    private void addEdge(CFAEdge edge) {
        edge.getPredecessor().addLeavingEdge(edge);
        edge.getSuccessor().addEnteringEdge(edge);
    }

    private void iterateOverFunctions(Module pItem, Path pFileName) throws LLVMException {
        Function lastFunc = pItem.getLastFunction().asFunction();
        Function currFunc = null;
        do {
            if ((currFunc = currFunc == null ? pItem.getFirstFunction().asFunction() : currFunc.getNextFunction().asFunction()).isDeclaration()) continue;
            String funcName = currFunc.getValueName();
            assert (!funcName.isEmpty());
            if (funcName.startsWith("llvm.")) continue;
            FunctionEntryNode en = this.visitFunction((Value)currFunc, pFileName);
            assert (en != null);
            this.addNode(funcName, en);
            TreeMap<Integer, BasicBlockInfo> basicBlocks = new TreeMap<Integer, BasicBlockInfo>();
            CFALabelNode entryBB = this.iterateOverBasicBlocks(currFunc, en, basicBlocks, pFileName);
            this.addEdge(new BlankEdge("entry", en.getFileLocation(), en, entryBB, "Function start edge"));
            this.addJumpsBetweenBasicBlocks(currFunc, basicBlocks, pFileName);
            this.purgeUnreachableBlocks(funcName, basicBlocks.values());
            if (en.getExitNode().getNumEnteringEdges() == 0) {
                this.cfaNodes.remove((Object)funcName, (Object)en.getExitNode());
            }
            this.functions.put(funcName, en);
        } while (!currFunc.equals((Object)lastFunc));
    }

    private void purgeUnreachableBlocks(String pFunctionName, Collection<BasicBlockInfo> pBasicBlocks) {
        for (BasicBlockInfo block : pBasicBlocks) {
            if (block.entryNode.getNumEnteringEdges() != 0) continue;
            this.purgeBlock(pFunctionName, block);
        }
    }

    private void purgeBlock(String pFunctionName, BasicBlockInfo pBlock) {
        Set<CFANode> blockNodes = CFATraversal.dfs().collectNodesReachableFromTo(pBlock.getEntryNode(), pBlock.getExitNode());
        for (CFANode toRemove : blockNodes) {
            for (CFAEdge enteringEdge : CFAUtils.allEnteringEdges(toRemove)) {
                enteringEdge.getPredecessor().removeLeavingEdge(enteringEdge);
            }
            for (CFAEdge leavingEdge : CFAUtils.allLeavingEdges(toRemove)) {
                leavingEdge.getSuccessor().removeEnteringEdge(leavingEdge);
            }
        }
        this.cfaNodes.get((Object)pFunctionName).removeAll(blockNodes);
    }

    private @Nullable CFALabelNode iterateOverBasicBlocks(Function pFunction, FunctionEntryNode pEntryNode, NavigableMap<Integer, BasicBlockInfo> pBasicBlocks, Path pFileName) throws LLVMException {
        if (pFunction.countBasicBlocks() == 0) {
            return null;
        }
        CFALabelNode entryBB = null;
        for (BasicBlock block : pFunction) {
            CFALabelNode label = new CFALabelNode(pEntryNode.getFunction(), this.getBBName(block));
            this.addNode(pEntryNode.getFunctionName(), label);
            if (entryBB == null) {
                entryBB = label;
            }
            BasicBlockInfo bbi = this.handleInstructions(pEntryNode.getExitNode(), pEntryNode.getFunction(), block, pFileName);
            pBasicBlocks.put(block.hashCode(), new BasicBlockInfo(label, bbi.getExitNode()));
            this.addEdge(new BlankEdge("label_to_first", pEntryNode.getFileLocation(), label, bbi.getEntryNode(), "edge to first instr"));
        }
        assert (entryBB != null || pBasicBlocks.isEmpty());
        return entryBB;
    }

    private void addJumpsBetweenBasicBlocks(Function pFunction, NavigableMap<Integer, BasicBlockInfo> pBasicBlocks, Path pFileName) throws LLVMException {
        for (BasicBlock bb : pFunction) {
            Value terminatorInst = bb.getLastInstruction();
            if (terminatorInst == null) continue;
            assert (terminatorInst.isTerminatorInst());
            assert (pBasicBlocks.containsKey(bb.hashCode()));
            CFANode brNode = ((BasicBlockInfo)pBasicBlocks.get(bb.hashCode())).getExitNode();
            int succNum = terminatorInst.getNumSuccessors();
            if (succNum == 0) continue;
            if (succNum == 1) {
                BasicBlock succ = terminatorInst.getSuccessor(0);
                CFALabelNode label = (CFALabelNode)((BasicBlockInfo)pBasicBlocks.get(succ.hashCode())).getEntryNode();
                this.addEdge(new BlankEdge("(goto)", FileLocation.DUMMY, brNode, label, "(goto)"));
                continue;
            }
            if (terminatorInst.isBranchInst()) {
                CExpression conditionForElse = this.getBranchConditionForElse(terminatorInst, pFileName);
                BasicBlock succ = terminatorInst.getSuccessor(0);
                CFALabelNode label = (CFALabelNode)((BasicBlockInfo)pBasicBlocks.get(succ.hashCode())).getEntryNode();
                this.addEdge(new CAssumeEdge(conditionForElse.toASTString(), conditionForElse.getFileLocation(), brNode, label, conditionForElse, false));
                succ = terminatorInst.getSuccessor(1);
                label = (CFALabelNode)((BasicBlockInfo)pBasicBlocks.get(succ.hashCode())).getEntryNode();
                this.addEdge(new CAssumeEdge(conditionForElse.toASTString(), conditionForElse.getFileLocation(), brNode, label, conditionForElse, true));
                continue;
            }
            assert (terminatorInst.isSwitchInst()) : "Unhandled instruction type: " + terminatorInst.getOpCode();
            Value compValue = terminatorInst.getOperand(0);
            CType compType = this.typeConverter.getCType(compValue.typeOf());
            CExpression comparisonLhs = this.getAssignedIdExpression(compValue, compType, pFileName);
            BasicBlock defaultBlock = terminatorInst.getSuccessor(0);
            CFALabelNode defaultLabel = (CFALabelNode)((BasicBlockInfo)pBasicBlocks.get(defaultBlock.hashCode())).getEntryNode();
            CFANode currNode = brNode;
            for (int i = 1; i < succNum; ++i) {
                CFALabelNode label = (CFALabelNode)((BasicBlockInfo)pBasicBlocks.get(terminatorInst.getSuccessor(i).hashCode())).getEntryNode();
                Value caseValue = terminatorInst.getOperand(2 * i);
                CExpression comparisonRhs = (CExpression)this.getConstant(caseValue, pFileName);
                CBinaryExpression comparisonExp = new CBinaryExpression(comparisonLhs.getFileLocation(), CNumericTypes.BOOL, compType, comparisonLhs, comparisonRhs, CBinaryExpression.BinaryOperator.EQUALS);
                CAssumeEdge jumpEdge = new CAssumeEdge(comparisonExp.toASTString(), comparisonExp.getFileLocation(), currNode, label, comparisonExp, true);
                this.addEdge(jumpEdge);
                CFANode nextNode = this.newNode(brNode.getFunction());
                CAssumeEdge toNextCaseEdge = new CAssumeEdge(comparisonExp.toASTString(), comparisonExp.getFileLocation(), currNode, nextNode, comparisonExp, false);
                this.addEdge(toNextCaseEdge);
                currNode = nextNode;
            }
            this.addEdge(new BlankEdge("(goto)", FileLocation.DUMMY, currNode, defaultLabel, "(goto)"));
        }
    }

    private String getBBName(BasicBlock BB) {
        Value bbValue = BB.basicBlockAsValue();
        String labelStr = bbValue.getValueName();
        if (labelStr.isEmpty()) {
            return Integer.toString(++this.basicBlockId);
        }
        return labelStr;
    }

    private CFANode newNode(AFunctionDeclaration func) {
        CFANode nd = new CFANode(func);
        this.addNode(func.getName(), nd);
        return nd;
    }

    private BasicBlockInfo handleInstructions(FunctionExitNode exitNode, AFunctionDeclaration pFunction, BasicBlock pItem, Path pFileName) throws LLVMException {
        CFANode prevNode;
        assert (pItem.getFirstInstruction() != null);
        String funcName = pFunction.getName();
        Value lastI = pItem.getLastInstruction();
        assert (lastI != null);
        CFANode firstNode = prevNode = this.newNode(pFunction);
        CFANode curNode = null;
        block0: for (Value i : pItem) {
            if (i.isDbgInfoIntrinsic() || i.isDbgDeclareInst()) continue;
            if (i.isSelectInst()) {
                CDeclaration decl = (CDeclaration)this.getAssignedVarDeclaration(i, funcName, null, pFileName);
                curNode = this.newNode(pFunction);
                this.addEdge(new CDeclarationEdge(decl.toASTString(), decl.getFileLocation(), prevNode, curNode, decl));
                prevNode = curNode;
                assert (i.getNumOperands() == 3) : "Select statement doesn't have 3 operands, but " + i.getNumOperands();
                Value condition = i.getOperand(0);
                Value valueIf = i.getOperand(1);
                Value valueElse = i.getOperand(2);
                CType ifType = this.typeConverter.getCType(valueIf.typeOf());
                assert (ifType.equals(this.typeConverter.getCType(valueElse.typeOf())));
                CExpression conditionForElse = this.getBranchConditionForElse(condition, pFileName);
                CExpression trueValue = this.getExpression(valueIf, ifType, pFileName);
                CStatement trueAssignment = (CStatement)this.getAssignStatement(i, trueValue, funcName, pFileName).get(0);
                CExpression falseValue = this.getExpression(valueElse, ifType, pFileName);
                CStatement falseAssignment = (CStatement)this.getAssignStatement(i, falseValue, funcName, pFileName).get(0);
                CFANode trueNode = this.newNode(pFunction);
                CFANode falseNode = this.newNode(pFunction);
                CAssumeEdge trueBranch = new CAssumeEdge(conditionForElse.toASTString(), conditionForElse.getFileLocation(), prevNode, trueNode, conditionForElse, false);
                this.addEdge(trueBranch);
                CAssumeEdge falseBranch = new CAssumeEdge(conditionForElse.toASTString(), conditionForElse.getFileLocation(), prevNode, falseNode, conditionForElse, true);
                this.addEdge(falseBranch);
                prevNode = trueNode;
                trueNode = this.newNode(pFunction);
                CStatementEdge trueAssign = new CStatementEdge(trueAssignment.toASTString(), trueAssignment, trueAssignment.getFileLocation(), prevNode, trueNode);
                this.addEdge(trueAssign);
                prevNode = falseNode;
                falseNode = this.newNode(pFunction);
                CStatementEdge falseAssign = new CStatementEdge(falseAssignment.toASTString(), falseAssignment, falseAssignment.getFileLocation(), prevNode, falseNode);
                this.addEdge(falseAssign);
                curNode = this.newNode(pFunction);
                BlankEdge trueMeet = new BlankEdge("", falseAssignment.getFileLocation(), trueNode, curNode, "");
                this.addEdge(trueMeet);
                BlankEdge falseMeet = new BlankEdge("", falseAssignment.getFileLocation(), falseNode, curNode, "");
                this.addEdge(falseMeet);
                prevNode = curNode;
                continue;
            }
            @Nullable List<CAstNode> expressions = this.visitInstruction(i, funcName, pFileName);
            if (expressions == null) {
                curNode = this.newNode(pFunction);
                this.addEdge(new BlankEdge(i.toString(), FileLocation.DUMMY, prevNode, curNode, "noop"));
                prevNode = curNode;
                continue;
            }
            for (CAstNode expr : expressions) {
                FileLocation exprLocation = expr.getFileLocation();
                if (expr instanceof CDeclaration) {
                    curNode = this.newNode(pFunction);
                    this.addEdge(new CDeclarationEdge(expr.toASTString(), exprLocation, prevNode, curNode, (CDeclaration)expr));
                } else if (expr instanceof CReturnStatement) {
                    curNode = exitNode;
                    this.addEdge(new CReturnStatementEdge(i.toString(), (CReturnStatement)expr, exprLocation, prevNode, exitNode));
                } else {
                    if (i.isUnreachableInst()) {
                        curNode = new CFATerminationNode(pFunction);
                        this.addNode(funcName, curNode);
                        this.addEdge(new BlankEdge(i.toString(), exprLocation, prevNode, curNode, "unreachable"));
                        continue block0;
                    }
                    curNode = this.newNode(pFunction);
                    this.addEdge(new CStatementEdge(expr.toASTString() + i, (CStatement)expr, exprLocation, prevNode, curNode));
                }
                prevNode = curNode;
            }
        }
        assert (curNode != null);
        return new BasicBlockInfo(firstNode, curNode);
    }

    protected FunctionEntryNode visitFunction(Value pItem, Path pFileName) {
        assert (pItem.isFunction());
        this.logger.log(Level.FINE, new Object[]{"Creating function:", pItem.getValueName()});
        return this.handleFunctionDefinition(pItem, pFileName);
    }

    private CExpression getBranchConditionForElse(Value pItem, Path pFileName) throws LLVMException {
        CExpression condition;
        if (pItem.isConditional()) {
            Value cond = pItem.getCondition();
            CType expectedType = this.typeConverter.getCType(cond.typeOf());
            condition = this.getExpression(cond, expectedType, pFileName);
        } else {
            condition = this.getAssignedIdExpression(pItem, CNumericTypes.BOOL, pFileName);
        }
        try {
            return this.binaryExpressionBuilder.buildBinaryExpression(condition, new CIntegerLiteralExpression(this.getLocation(pItem, pFileName), CNumericTypes.BOOL, BigInteger.ZERO), CBinaryExpression.BinaryOperator.EQUALS);
        }
        catch (UnrecognizedCodeException e) {
            throw new AssertionError((Object)e.toString());
        }
    }

    private @Nullable List<CAstNode> visitInstruction(Value pItem, String pFunctionName, Path pFileName) throws LLVMException {
        assert (pItem.isInstruction());
        if (pItem.isAllocaInst()) {
            return this.handleAlloca(pItem, pFunctionName, pFileName);
        }
        if (pItem.isReturnInst()) {
            return this.handleReturn(pItem, pFunctionName, pFileName);
        }
        if (pItem.isUnreachableInst()) {
            return this.handleUnreachable(pItem, pFileName);
        }
        if (pItem.isBinaryOperator() || pItem.isGetElementPtrInst() || pItem.isIntToPtrInst() || pItem.isPtrToIntInst()) {
            return this.handleOpCode(pItem, pFunctionName, pFileName, pItem.getOpCode());
        }
        if (pItem.isUnaryInstruction()) {
            return this.handleUnaryOp(pItem, pFunctionName, pFileName);
        }
        if (pItem.isStoreInst()) {
            return this.handleStore(pItem, pFunctionName, pFileName);
        }
        if (pItem.isCallInst()) {
            return this.handleCall(pItem, pFunctionName, pFileName);
        }
        if (pItem.isCmpInst()) {
            return this.handleCmpInst(pItem, pFunctionName, pFileName);
        }
        if (pItem.isSwitchInst()) {
            return null;
        }
        if (pItem.isIndirectBranchInst()) {
            throw new UnsupportedOperationException();
        }
        if (pItem.isBranchInst()) {
            return null;
        }
        if (pItem.isPHINode()) {
            throw new LLVMException("Program contains PHI nodes, but they are not supported by CPAchecker, yet.Please remove them with `opt -reg2mem $PROG`");
        }
        if (pItem.isInvokeInst()) {
            throw new UnsupportedOperationException();
        }
        throw new UnsupportedOperationException();
    }

    private List<CAstNode> handleCall(Value pItem, String pCallingFunctionName, Path pFileName) throws LLVMException {
        List<CParameterDeclaration> parameterDeclarations;
        CFunctionType functionType;
        assert (pItem.isCallInst());
        if (pItem.isIntrinsicInst()) {
            if (pItem.isMemIntrinsic()) {
                this.logger.logf(Level.WARNING, "Unhandled memory intrinsic!", new Object[0]);
            }
            this.logger.logf(Level.FINE, "Taking intrinsic function call as undefined", new Object[0]);
        }
        FileLocation loc = this.getLocation(pItem, pFileName);
        CType returnType = this.typeConverter.getCType(pItem.typeOf());
        int argumentCount = pItem.getNumArgOperands();
        Value calledFunction = pItem.getCalledFunction();
        CFunctionDeclaration functionDeclaration = null;
        String functionName = null;
        if (calledFunction.isConstantExpr() && calledFunction.getConstOpCode() == Value.OpCode.BitCast) {
            calledFunction = calledFunction.getOperand(0);
        }
        if (calledFunction.isFunction()) {
            functionName = calledFunction.getValueName();
            functionDeclaration = this.functionDeclarations.get(functionName);
        }
        ArrayList<CExpression> parameters = new ArrayList<CExpression>(argumentCount);
        if (functionDeclaration == null) {
            ArrayList<CType> parameterTypes = new ArrayList<CType>(argumentCount);
            for (int i = 0; i < argumentCount; ++i) {
                Value functionArg = pItem.getArgOperand(i);
                assert (functionArg.isConstant() || this.variableDeclarations.containsKey(functionArg.getAddress()));
                CType expectedType = this.typeConverter.getCType(functionArg.typeOf());
                parameterTypes.add(expectedType);
            }
            functionType = new CFunctionType(returnType, parameterTypes, false);
            parameterDeclarations = new ArrayList<CParameterDeclaration>();
            for (CType paramType : parameterTypes) {
                parameterDeclarations.add(new CParameterDeclaration(FileLocation.DUMMY, paramType, this.getTempVar(false)));
            }
            if (functionName != null) {
                CFunctionDeclaration derivedDeclaration = new CFunctionDeclaration(FileLocation.DUMMY, functionType, functionName, parameterDeclarations, (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
                this.functionDeclarations.put(functionName, derivedDeclaration);
            }
        } else {
            functionType = functionDeclaration.getType();
            parameterDeclarations = functionDeclaration.getParameters();
        }
        for (int i = 0; i < argumentCount; ++i) {
            CType expectedType;
            Value functionArg = pItem.getArgOperand(i);
            if (i < parameterDeclarations.size()) {
                expectedType = parameterDeclarations.get(i).getType();
            } else {
                assert (functionType.takesVarArgs()) : "Too many arguments for function " + functionDeclaration + ": " + functionArg;
                expectedType = this.typeConverter.getCType(functionArg.typeOf());
            }
            assert (functionArg.isConstant() || this.variableDeclarations.containsKey(functionArg.getAddress()));
            parameters.add(this.getExpression(functionArg, expectedType, pFileName));
        }
        CExpression functionNameExp = this.getExpression(calledFunction, functionType, pFileName);
        CFunctionCallExpression callExpression = new CFunctionCallExpression(loc, returnType, functionNameExp, parameters, functionDeclaration);
        if (returnType.equals(CVoidType.VOID)) {
            return ImmutableList.of((Object)new CFunctionCallStatement(loc, callExpression));
        }
        return this.getAssignStatement(pItem, callExpression, pCallingFunctionName, pFileName);
    }

    private List<CAstNode> handleUnreachable(Value pItem, Path pFileName) {
        CFunctionCallExpression callExpression = new CFunctionCallExpression(this.getLocation(pItem, pFileName), CVoidType.VOID, ABORT_FUNC_NAME, (List<CExpression>)ImmutableList.of(), ABORT_FUNC_DECL);
        return ImmutableList.of((Object)new CFunctionCallStatement(this.getLocation(pItem, pFileName), callExpression));
    }

    private List<CAstNode> handleUnaryOp(Value pItem, String pFunctionName, Path pFileName) throws LLVMException {
        if (pItem.isLoadInst()) {
            return this.handleLoad(pItem, pFunctionName, pFileName);
        }
        if (pItem.isCastInst()) {
            return this.handleCastInst(pItem, pFunctionName, pFileName);
        }
        if (pItem.isExtractValueInst()) {
            return this.handleExtractValue(pItem, pFunctionName, pFileName);
        }
        throw new UnsupportedOperationException("LLVM does not yet support operator with opcode " + pItem.getOpCode());
    }

    private List<CAstNode> handleExtractValue(Value pItem, String pFunctionName, Path pFileName) throws LLVMException {
        Value accessed = pItem.getOperand(0);
        CType baseType = this.typeConverter.getCType(accessed.typeOf());
        FileLocation fileLocation = this.getLocation(pItem, pFileName);
        CType currentType = baseType;
        CExpression currentExpression = this.getExpression(accessed, currentType, pFileName);
        for (Integer indexValue : pItem.getIndices()) {
            CIntegerLiteralExpression index = new CIntegerLiteralExpression(fileLocation, CNumericTypes.INT, BigInteger.valueOf(indexValue.intValue()));
            if (currentType instanceof CArrayType) {
                currentExpression = new CArraySubscriptExpression(fileLocation, currentType, currentExpression, index);
                currentType = ((CArrayType)currentType).getType();
                continue;
            }
            if (!(currentType instanceof CCompositeType)) continue;
            CCompositeType.CCompositeTypeMemberDeclaration field = ((CCompositeType)currentType).getMembers().get(indexValue);
            String fieldName = field.getName();
            currentExpression = new CFieldReference(fileLocation, currentType, fieldName, currentExpression, false);
            currentType = field.getType();
        }
        return this.getAssignStatement(pItem, currentExpression, pFunctionName, pFileName);
    }

    private List<CAstNode> handleLoad(Value pItem, String pFunctionName, Path pFileName) throws LLVMException {
        CType expectedType = this.typeConverter.getCType(pItem.typeOf());
        CExpression expression = this.getExpression(pItem.getOperand(0), expectedType, pFileName);
        return this.getAssignStatement(pItem, expression, pFunctionName, pFileName);
    }

    private List<CAstNode> handleStore(Value pItem, String pFunctionName, Path pFileName) throws LLVMException {
        Value valueToStoreTo = pItem.getOperand(1);
        Value valueToLoad = pItem.getOperand(0);
        CType expectedType = this.typeConverter.getCType(valueToLoad.typeOf());
        CExpression expression = this.getExpression(valueToLoad, expectedType, pFileName);
        return this.getAssignStatement(valueToStoreTo, expression, pFunctionName, pFileName);
    }

    private List<CAstNode> handleAlloca(Value pItem, String pFunctionName, Path pFileName) {
        CSimpleDeclaration assignedVar = this.getAssignedVarDeclaration(pItem, pFunctionName, null, pFileName);
        return ImmutableList.of((Object)assignedVar);
    }

    private List<CAstNode> handleReturn(Value pItem, String pFuncName, Path pFileName) throws LLVMException {
        Optional<CAssignment> maybeAssignment;
        Optional<CExpression> maybeExpression;
        Value returnVal = pItem.getReturnValue();
        if (returnVal == null) {
            maybeExpression = Optional.empty();
            maybeAssignment = Optional.empty();
        } else {
            CType expectedType = this.typeConverter.getCType(returnVal.typeOf());
            CExpression returnExp = this.getExpression(returnVal, expectedType, pFileName);
            maybeExpression = Optional.of(returnExp);
            CVariableDeclaration returnVarDecl = this.getReturnVar(pFuncName, returnExp.getExpressionType(), returnExp.getFileLocation());
            CIdExpression returnVar = new CIdExpression(this.getLocation(returnVal, pFileName), returnVarDecl);
            CExpressionAssignmentStatement returnVarAssignment = new CExpressionAssignmentStatement(this.getLocation(returnVal, pFileName), returnVar, returnExp);
            maybeAssignment = Optional.of(returnVarAssignment);
        }
        return ImmutableList.of((Object)new CReturnStatement(this.getLocation(pItem, pFileName), maybeExpression, maybeAssignment));
    }

    private String getQualifiedName(String pVarName, String pFuncName) {
        return pFuncName + "::" + pVarName;
    }

    private List<CAstNode> handleOpCode(Value pItem, String pFunctionName, Path pFileName, Value.OpCode pOpCode) throws LLVMException {
        CExpression expression = this.createFromOpCode(pItem, pFileName, pOpCode);
        return this.getAssignStatement(pItem, expression, pFunctionName, pFileName);
    }

    private CExpression createFromOpCode(Value pItem, Path pFileName, Value.OpCode pOpCode) throws LLVMException {
        switch (pOpCode) {
            case Add: 
            case FAdd: 
            case Sub: 
            case FSub: 
            case Mul: 
            case FMul: 
            case UDiv: 
            case SDiv: 
            case FDiv: 
            case URem: 
            case SRem: 
            case FRem: 
            case Shl: 
            case LShr: 
            case AShr: 
            case And: 
            case Or: 
            case Xor: {
                return this.createFromArithmeticOp(pItem, pOpCode, pFileName);
            }
            case GetElementPtr: {
                return this.createGetElementPtrExp(pItem, pFileName);
            }
            case BitCast: {
                return this.createBitcast(pItem, pFileName);
            }
            case PtrToInt: 
            case IntToPtr: {
                return new CCastExpression(this.getLocation(pItem, pFileName), this.typeConverter.getCType(pItem.typeOf()), this.getExpression(pItem.getOperand(0), this.typeConverter.getCType(pItem.getOperand(0).typeOf()), pFileName));
            }
        }
        throw new UnsupportedOperationException(pOpCode.toString());
    }

    private CExpression createBitcast(Value pItem, Path pFileName) throws LLVMException {
        Value op = pItem.getOperand(0);
        CType expectedType = this.typeConverter.getCType(pItem.typeOf());
        CType opType = this.typeConverter.getCType(op.typeOf());
        if (op.isFunction()) {
            assert (opType instanceof CPointerType);
            opType = ((CPointerType)opType).getType();
            return this.getExpression(op, opType, pFileName);
        }
        CExpression opToCast = this.getExpression(op, opType, pFileName);
        return new CCastExpression(this.getLocation(pItem, pFileName), expectedType, opToCast);
    }

    private CExpression createFromArithmeticOp(Value pItem, Value.OpCode pOpCode, Path pFileName) throws LLVMException {
        CBinaryExpression.BinaryOperator operation;
        CType expressionType;
        CType internalExpressionType = expressionType = this.typeConverter.getCType(pItem.typeOf());
        Value operand1 = pItem.getOperand(0);
        this.logger.log(Level.FINE, new Object[]{"Getting id expression for operand 1"});
        CType op1type = this.typeConverter.getCType(operand1.typeOf());
        CExpression operand1Exp = this.getExpression(operand1, op1type, pFileName);
        Value operand2 = pItem.getOperand(1);
        CType op2type = this.typeConverter.getCType(operand2.typeOf());
        this.logger.log(Level.FINE, new Object[]{"Getting id expression for operand 2"});
        CExpression operand2Exp = this.getExpression(operand2, op2type, pFileName);
        switch (pOpCode) {
            case Add: 
            case FAdd: {
                operation = CBinaryExpression.BinaryOperator.PLUS;
                break;
            }
            case Sub: 
            case FSub: {
                operation = CBinaryExpression.BinaryOperator.MINUS;
                break;
            }
            case Mul: 
            case FMul: {
                operation = CBinaryExpression.BinaryOperator.MULTIPLY;
                break;
            }
            case UDiv: 
            case SDiv: 
            case FDiv: {
                operation = CBinaryExpression.BinaryOperator.DIVIDE;
                break;
            }
            case URem: 
            case SRem: 
            case FRem: {
                operation = CBinaryExpression.BinaryOperator.MODULO;
                break;
            }
            case Shl: {
                operation = CBinaryExpression.BinaryOperator.SHIFT_LEFT;
                break;
            }
            case LShr: {
                op1type = this.typeConverter.getCType(operand1.typeOf(), true);
                operand1Exp = this.castToExpectedType(operand1Exp, op1type, this.getLocation(pItem, pFileName));
            }
            case AShr: {
                if (!CTypes.isIntegerType(op1type) || !CTypes.isIntegerType(op2type)) {
                    throw new UnsupportedOperationException("Right shifts are only supported for integer types, but operands were " + op1type + " and " + op2type);
                }
                if (operand2.isConstantInt()) {
                    long op2value = operand2.constIntGetSExtValue();
                    int bitwidthOp1 = operand1.typeOf().getIntTypeWidth();
                    if (op2value < 0L || op2value >= (long)bitwidthOp1) {
                        throw new LLVMException("Shift count is negative or >= width of type");
                    }
                }
                op2type = this.typeConverter.getCType(operand2.typeOf(), true);
                operand2Exp = this.castToExpectedType(operand2Exp, op2type, this.getLocation(pItem, pFileName));
                assert (pOpCode != Value.OpCode.AShr || CTypes.isSignedIntegerType(op1type)) : "First operand of right shift wasn't signed in the case of an arithmetic right shift";
                internalExpressionType = this.machineModel.applyIntegerPromotion(op1type);
                operation = CBinaryExpression.BinaryOperator.SHIFT_RIGHT;
                break;
            }
            case And: {
                operation = CBinaryExpression.BinaryOperator.BINARY_AND;
                break;
            }
            case Or: {
                operation = CBinaryExpression.BinaryOperator.BINARY_OR;
                break;
            }
            case Xor: {
                operation = CBinaryExpression.BinaryOperator.BINARY_XOR;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled operation " + pOpCode));
            }
        }
        CBinaryExpression expression = new CBinaryExpression(this.getLocation(pItem, pFileName), internalExpressionType, internalExpressionType, operand1Exp, operand2Exp, operation);
        return this.castToExpectedType(expression, expressionType, this.getLocation(pItem, pFileName));
    }

    private CExpression getExpression(Value pItem, CType pExpectedType, Path pFileName) throws LLVMException {
        if (pItem.isConstantExpr()) {
            CExpression expr = this.createFromOpCode(pItem, pFileName, pItem.getConstOpCode());
            return this.castToExpectedType(expr, pExpectedType, this.getLocation(pItem, pFileName));
        }
        if (pItem.isConstant() && !pItem.isGlobalVariable()) {
            return (CExpression)this.getConstant(pItem, pExpectedType, pFileName);
        }
        return this.getAssignedIdExpression(pItem, pExpectedType, pFileName);
    }

    private CRightHandSide getConstant(Value pItem, Path pFileName) throws LLVMException {
        CType expectedType = this.typeConverter.getCType(pItem.typeOf());
        return this.getConstant(pItem, expectedType, pFileName);
    }

    private CRightHandSide getConstant(Value pItem, CType pExpectedType, Path pFileName) throws LLVMException {
        assert (pItem.isConstant()) : "getConstant called on non-constant value";
        FileLocation location = this.getLocation(pItem, pFileName);
        if (pItem.isConstantInt()) {
            CSimpleType castType;
            BigInteger constantValue = BigInteger.valueOf(pItem.constIntGetSExtValue());
            if (pExpectedType instanceof CSimpleType && (castType = (CSimpleType)pExpectedType).getType().equals((Object)CBasicType.INT)) {
                assert (this.machineModel.getMinimalIntegerValue(castType).compareTo(constantValue) <= 0);
                assert (this.machineModel.getMaximalIntegerValue(castType).compareTo(constantValue) >= 0);
                return new CIntegerLiteralExpression(this.getLocation(pItem, pFileName), pExpectedType, constantValue);
            }
            CIntegerLiteralExpression literalExpression = new CIntegerLiteralExpression(this.getLocation(pItem, pFileName), CNumericTypes.SIGNED_LONG_LONG_INT, constantValue);
            return this.castToExpectedType(literalExpression, pExpectedType, location);
        }
        if (pItem.isConstantPointerNull()) {
            return new CCastExpression(location, pExpectedType, this.getNull(location));
        }
        if (pItem.isConstantExpr()) {
            return this.getExpression(pItem, pExpectedType, pFileName);
        }
        if (pItem.isUndef()) {
            CType constantType = this.typeConverter.getCType(pItem.typeOf());
            String typeName = constantType.toString();
            typeName = CharMatcher.anyOf((CharSequence)" ():").replaceFrom((CharSequence)typeName, (CharSequence)"_");
            typeName = typeName.replace("*", "_ptr_");
            String undefName = "__VERIFIER_undef_" + typeName;
            CVariableDeclaration undefDecl = new CVariableDeclaration(location, true, CStorageClass.AUTO, pExpectedType, undefName, undefName, undefName, null);
            CIdExpression undefExpression = new CIdExpression(location, undefDecl);
            return undefExpression;
        }
        if (pItem.isFunction()) {
            Function func = pItem.asFunction();
            CFunctionDeclaration funcDecl = this.functionDeclarations.get(func.getValueName());
            CFunctionType functionType = funcDecl.getType();
            CIdExpression funcId = new CIdExpression(location, funcDecl);
            if (this.pointerOf(pExpectedType, functionType)) {
                return new CUnaryExpression(location, pExpectedType, funcId, CUnaryExpression.UnaryOperator.AMPER);
            }
            return funcId;
        }
        if (pItem.isGlobalVariable()) {
            if (!pItem.isExternallyInitialized() || pItem.isGlobalConstant()) {
                return this.getAssignedIdExpression(pItem, pExpectedType, pFileName);
            }
            throw new UnsupportedOperationException("LLVM parsing does not support this global variable: " + pItem);
        }
        throw new UnsupportedOperationException("LLVM parsing does not support constant " + pItem);
    }

    private CExpression getNull(FileLocation pLocation) {
        return new CIntegerLiteralExpression(pLocation, CNumericTypes.INT, BigInteger.ZERO);
    }

    private CInitializer getConstantAggregateInitializer(Value pAggregate, Path pFileName) throws LLVMException {
        int length = this.getLength(pAggregate);
        ArrayList<CInitializer> elementInitializers = new ArrayList<CInitializer>(length);
        for (int i = 0; i < length; ++i) {
            Value element = pAggregate.isConstantArray() || pAggregate.isConstantStruct() ? pAggregate.getOperand(i) : pAggregate.getElementAsConstant(i);
            assert (element.isConstant()) : "Value element is not a constant!";
            CInitializer elementInitializer = this.isConstantArrayOrVector(element) || element.isConstantStruct() ? this.getConstantAggregateInitializer(element, pFileName) : (element.isConstantAggregateZero() ? this.getZeroInitializer(element, this.typeConverter.getCType(pAggregate.typeOf()), pFileName) : new CInitializerExpression(this.getLocation(element, pFileName), (CExpression)this.getConstant(element, pFileName)));
            elementInitializers.add(elementInitializer);
        }
        CInitializerList aggregateInitializer = new CInitializerList(this.getLocation(pAggregate, pFileName), elementInitializers);
        return aggregateInitializer;
    }

    private CInitializer getZeroInitializer(Value pForElement, CType pExpectedType, Path pFileName) {
        AbstractInitializer init;
        FileLocation loc = this.getLocation(pForElement, pFileName);
        CType canonicalType = pExpectedType.getCanonicalType();
        if (canonicalType instanceof CArrayType) {
            int length = ((CArrayType)canonicalType).getLengthAsInt().orElseThrow();
            CType elementType = ((CArrayType)canonicalType).getType().getCanonicalType();
            CInitializer zeroInitializer = this.getZeroInitializer(pForElement, elementType, pFileName);
            List<CInitializer> initializers = Collections.nCopies(length, zeroInitializer);
            init = new CInitializerList(loc, initializers);
        } else if (canonicalType instanceof CCompositeType) {
            List<CCompositeType.CCompositeTypeMemberDeclaration> members = ((CCompositeType)canonicalType).getMembers();
            ArrayList<CInitializer> initializers = new ArrayList<CInitializer>(members.size());
            for (CCompositeType.CCompositeTypeMemberDeclaration m : members) {
                CType memberType = m.getType();
                CInitializer memberInit = this.getZeroInitializer(pForElement, memberType, pFileName);
                initializers.add(memberInit);
            }
            init = new CInitializerList(loc, initializers);
        } else {
            CBasicType basicType;
            AbstractExpression zeroExpression = canonicalType instanceof CSimpleType ? ((basicType = ((CSimpleType)canonicalType).getType()) == CBasicType.FLOAT || basicType == CBasicType.DOUBLE ? new CFloatLiteralExpression(loc, pExpectedType, BigDecimal.ZERO) : CIntegerLiteralExpression.ZERO) : new CCastExpression(loc, pExpectedType, CIntegerLiteralExpression.ZERO);
            init = new CInitializerExpression(loc, (CExpression)((Object)zeroExpression));
        }
        return init;
    }

    private int getLength(Value pAggregateValue) {
        CType aggregateType = this.typeConverter.getCType(pAggregateValue.typeOf()).getCanonicalType();
        if (aggregateType instanceof CArrayType) {
            CArrayType arrayType = (CArrayType)this.typeConverter.getCType(pAggregateValue.typeOf());
            OptionalInt maybeArrayLength = arrayType.getLengthAsInt();
            assert (maybeArrayLength.isPresent()) : "Constant array has non-constant length";
            return maybeArrayLength.orElseThrow();
        }
        if (aggregateType instanceof CCompositeType) {
            return ((CCompositeType)aggregateType).getMembers().size();
        }
        throw new AssertionError();
    }

    private List<CAstNode> getAssignStatement(Value pAssignee, CRightHandSide pAssignment, String pFunctionName, Path pFileName) throws LLVMException {
        long assigneeId = pAssignee.getAddress();
        CType expectedType = pAssignment.getExpressionType();
        if (pAssignee.isConstantExpr()) {
            CExpression assigneeExpr = this.getExpression(pAssignee, expectedType, pFileName);
            return ImmutableList.of((Object)new CExpressionAssignmentStatement(this.getLocation(pAssignee, pFileName), (CLeftHandSide)assigneeExpr, (CExpression)pAssignment));
        }
        if (this.variableDeclarations.containsKey(assigneeId)) {
            CLeftHandSide assigneeIdExp = (CLeftHandSide)this.getAssignedIdExpression(pAssignee, expectedType, pFileName);
            CType varType = assigneeIdExp.getExpressionType();
            if (!varType.canBeAssignedFrom(expectedType)) {
                assert (expectedType instanceof CPointerType) : "Variable type different from expected type, but expected type no pointer. Var type: " + varType + ". Expected type: " + expectedType;
                assigneeIdExp = new CPointerExpression(this.getLocation(pAssignee, pFileName), varType, assigneeIdExp);
            }
            if (pAssignment instanceof CFunctionCallExpression) {
                return ImmutableList.of((Object)new CFunctionCallAssignmentStatement(this.getLocation(pAssignee, pFileName), assigneeIdExp, (CFunctionCallExpression)pAssignment));
            }
            return ImmutableList.of((Object)new CExpressionAssignmentStatement(this.getLocation(pAssignee, pFileName), assigneeIdExp, (CExpression)pAssignment));
        }
        if (pAssignment instanceof CFunctionCallExpression) {
            CSimpleDeclaration assigneeDecl = this.getAssignedVarDeclaration(pAssignee, pFunctionName, null, pFileName);
            CLeftHandSide assigneeIdExp = (CLeftHandSide)this.getAssignedIdExpression(pAssignee, expectedType, pFileName);
            return ImmutableList.of((Object)assigneeDecl, (Object)new CFunctionCallAssignmentStatement(this.getLocation(pAssignee, pFileName), assigneeIdExp, (CFunctionCallExpression)pAssignment));
        }
        CInitializerExpression initializer = new CInitializerExpression(this.getLocation(pAssignee, pFileName), (CExpression)pAssignment);
        CSimpleDeclaration assigneeDecl = this.getAssignedVarDeclaration(pAssignee, pFunctionName, initializer, pFileName);
        return ImmutableList.of((Object)assigneeDecl);
    }

    private CSimpleDeclaration getAssignedVarDeclaration(Value pItem, String pFunctionName, CInitializer pInitializer, Path pFileName) {
        long itemId = pItem.getAddress();
        if (!this.variableDeclarations.containsKey(itemId)) {
            String assignedVar = this.getName(pItem);
            boolean isGlobal = pItem.isGlobalValue();
            CStorageClass storageClass = CStorageClass.AUTO;
            CType varType = pItem.isAllocaInst() ? this.typeConverter.getCType(pItem.getAllocatedType()) : this.typeConverter.getCType(pItem.typeOf());
            if (isGlobal && varType instanceof CPointerType) {
                varType = ((CPointerType)varType).getType();
            }
            CVariableDeclaration newDecl = new CVariableDeclaration(this.getLocation(pItem, pFileName), isGlobal, storageClass, varType, assignedVar, assignedVar, this.getQualifiedName(assignedVar, pFunctionName), pInitializer);
            assert (!this.variableDeclarations.containsKey(itemId));
            this.variableDeclarations.put(itemId, newDecl);
        }
        return this.variableDeclarations.get(itemId);
    }

    private CType getReferencedType(CType type) {
        assert (type instanceof CPointerType);
        return ((CPointerType)type).getType().getCanonicalType();
    }

    private CExpression castToExpectedType(CExpression expression, CType pExpectedType, FileLocation location) {
        CType expressionType = expression.getExpressionType();
        if (expressionType.canBeAssignedFrom(pExpectedType)) {
            return expression;
        }
        if (this.pointerOf(pExpectedType, expressionType)) {
            CType typePointingTo = ((CPointerType)pExpectedType).getType().getCanonicalType();
            if (expressionType.canBeAssignedFrom(typePointingTo) || expressionType.equals(typePointingTo)) {
                return this.getReference(location, expression);
            }
            throw new AssertionError((Object)("Unhandled type structure: " + expressionType));
        }
        if (expressionType instanceof CPointerType) {
            return this.getDereference(location, expression);
        }
        if (expressionType instanceof CArrayType) {
            if (pExpectedType instanceof CPointerType && this.getReferencedType(pExpectedType).equals(((CArrayType)expressionType).getType().getCanonicalType())) {
                return expression;
            }
            throw new AssertionError((Object)("Unhandled cast of array type " + expressionType + " to " + pExpectedType));
        }
        if (expressionType instanceof CFunctionType) {
            this.logger.logf(Level.WARNING, "Using incompatible function pointer", new Object[0]);
            return expression;
        }
        throw new AssertionError((Object)("Unhandled type structure: " + expressionType));
    }

    private CExpression getAssignedIdExpression(Value pItem, CType pExpectedType, Path pFileName) throws LLVMException {
        this.logger.log(Level.FINE, new Object[]{"Getting var declaration for item"});
        if (!this.variableDeclarations.containsKey(pItem.getAddress())) {
            throw new LLVMException("ID expression has no declaration: " + pItem);
        }
        CSimpleDeclaration assignedVarDeclaration = this.variableDeclarations.get(pItem.getAddress());
        String assignedVarName = assignedVarDeclaration.getName();
        CType expressionType = assignedVarDeclaration.getType().getCanonicalType();
        CIdExpression idExpression = new CIdExpression(this.getLocation(pItem, pFileName), expressionType, assignedVarName, assignedVarDeclaration);
        return this.castToExpectedType(idExpression, pExpectedType, this.getLocation(pItem, pFileName));
    }

    private boolean pointerOf(CType pPotentialPointer, CType pPotentialPointee) {
        if (pPotentialPointer instanceof CPointerType) {
            return ((CPointerType)pPotentialPointer).getType().getCanonicalType().equals(pPotentialPointee.getCanonicalType());
        }
        return false;
    }

    private String getName(Value pValue) {
        String name = pValue.getValueName();
        if (name.isEmpty()) {
            name = this.getTempVar(pValue.isGlobalValue());
        }
        return this.prepareName(name);
    }

    private String getTempVar(boolean pIsGlobal) {
        String var_suffix;
        String var_prefix;
        if (pIsGlobal) {
            var_prefix = TMP_VAR_PREFIX_GLOBAL;
            var_suffix = Long.toString(tmpGlobalVarCount++);
        } else {
            var_prefix = TMP_VAR_PREFIX_LOCAL;
            var_suffix = Long.toString(tmpLocalVarCount++);
        }
        return var_prefix + var_suffix;
    }

    private String prepareName(String pRawName) {
        char[] asArray = pRawName.toCharArray();
        StringBuilder newName = new StringBuilder();
        for (int i = 0; i < asArray.length; ++i) {
            char curr = asArray[i];
            if (curr == '_' || Character.isAlphabetic(curr) || i > 0 && Character.isDigit(curr)) {
                newName.append(curr);
                continue;
            }
            if (i == 0) {
                newName.append('_');
            }
            newName.append((int)curr);
        }
        return newName.toString();
    }

    private void declareFunction(Value pFuncDef, Path pFileName) {
        String functionName = pFuncDef.getValueName();
        TypeRef functionType = pFuncDef.typeOf();
        TypeRef elemType = functionType.getElementType();
        CFunctionType cFuncType = (CFunctionType)this.typeConverter.getCType(elemType);
        List paramVs = pFuncDef.getParams();
        ArrayList<CParameterDeclaration> parameters = new ArrayList<CParameterDeclaration>(paramVs.size());
        for (Value v : paramVs) {
            String paramName = this.getName(v);
            CType paramType = this.typeConverter.getCType(v.typeOf());
            CParameterDeclaration parameter = new CParameterDeclaration(this.getLocation(v, pFileName), paramType, paramName);
            parameter.setQualifiedName(this.getQualifiedName(paramName, functionName));
            this.variableDeclarations.put(v.getAddress(), parameter);
            parameters.add(parameter);
        }
        CFunctionDeclaration functionDeclaration = new CFunctionDeclaration(this.getLocation(pFuncDef, pFileName), cFuncType, functionName, parameters, (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
        this.functionDeclarations.put(functionName, functionDeclaration);
    }

    private FunctionEntryNode handleFunctionDefinition(Value pFuncDef, Path pFileName) {
        Optional<CVariableDeclaration> returnVar;
        assert (!pFuncDef.isDeclaration());
        String functionName = pFuncDef.getValueName();
        CFunctionDeclaration functionDeclaration = this.functionDeclarations.get(functionName);
        FunctionExitNode functionExit = new FunctionExitNode(functionDeclaration);
        this.addNode(functionName, functionExit);
        TypeRef functionType = pFuncDef.typeOf();
        TypeRef elemType = functionType.getElementType();
        CFunctionType cFuncType = (CFunctionType)this.typeConverter.getCType(elemType);
        CType returnType = cFuncType.getReturnType();
        if (returnType.equals(CVoidType.VOID)) {
            returnVar = Optional.empty();
        } else {
            FileLocation returnVarLocation = this.getLocation(pFuncDef, pFileName);
            CVariableDeclaration returnVarDecl = this.getReturnVar(functionName, returnType, returnVarLocation);
            returnVar = Optional.of(returnVarDecl);
        }
        CFunctionEntryNode entry = new CFunctionEntryNode(this.getLocation(pFuncDef, pFileName), functionDeclaration, functionExit, returnVar);
        functionExit.setEntryNode(entry);
        return entry;
    }

    private CVariableDeclaration getReturnVar(String pFunctionName, CType pType, FileLocation pLocation) {
        return new CVariableDeclaration(pLocation, false, CStorageClass.AUTO, pType, RETURN_VAR_NAME, RETURN_VAR_NAME, this.getQualifiedName(RETURN_VAR_NAME, pFunctionName), null);
    }

    private CType getPointerOfType(CType type) {
        return new CPointerType(false, false, type);
    }

    private CExpression getReference(FileLocation fileLocation, CExpression expr) {
        CType exprType = expr.getExpressionType();
        if (expr instanceof CPointerExpression) {
            return ((CPointerExpression)expr).getOperand();
        }
        if (expr instanceof CArraySubscriptExpression) {
            CType type = this.getPointerOfType(exprType);
            return new CBinaryExpression(fileLocation, type, type, ((CArraySubscriptExpression)expr).getArrayExpression(), ((CArraySubscriptExpression)expr).getSubscriptExpression(), CBinaryExpression.BinaryOperator.PLUS);
        }
        return new CUnaryExpression(fileLocation, this.getPointerOfType(exprType), expr, CUnaryExpression.UnaryOperator.AMPER);
    }

    private CExpression getDereference(FileLocation fileLocation, CExpression expr) {
        CType exprType = expr.getExpressionType();
        CType derefType = this.getReferencedType(exprType);
        if (expr instanceof CUnaryExpression && ((CUnaryExpression)expr).getOperator() == CUnaryExpression.UnaryOperator.AMPER) {
            return ((CUnaryExpression)expr).getOperand();
        }
        return new CPointerExpression(fileLocation, derefType, expr);
    }

    private boolean valueIsZero(Value pItem) {
        return pItem.isConstantInt() && pItem.constIntGetZExtValue() == 0L;
    }

    private CExpression createGetElementPtrExp(Value pItem, Path pFileName) throws LLVMException {
        Value startPointer = pItem.getOperand(0);
        assert (this.typeConverter.getCType(startPointer.typeOf()) instanceof CPointerType) : "Start of getelementptr is not a pointer";
        FileLocation fileLocation = this.getLocation(pItem, pFileName);
        if (pItem.canBeTransformedFromGetElementPtrToString()) {
            String constant = pItem.getGetElementPtrAsString();
            CSimpleType constCharType = new CSimpleType(true, false, CBasicType.CHAR, false, false, false, false, false, false, false);
            CPointerType stringType = new CPointerType(false, false, constCharType);
            return new CStringLiteralExpression(fileLocation, stringType, "\"" + constant + "\"");
        }
        CType currentType = this.typeConverter.getCType(startPointer.typeOf());
        CExpression currentExpression = this.getExpression(startPointer, currentType, pFileName);
        currentType = currentExpression.getExpressionType();
        assert (pItem.getNumOperands() >= 2) : "Too few operands in GEP operation : " + pItem.getNumOperands();
        for (int i = 1; i < pItem.getNumOperands(); ++i) {
            Value indexValue = pItem.getOperand(i);
            CExpression index = this.getExpression(indexValue, CNumericTypes.INT, pFileName);
            if (currentType instanceof CPointerType) {
                currentExpression = this.valueIsZero(indexValue) ? this.getDereference(fileLocation, currentExpression) : this.getDereference(fileLocation, new CBinaryExpression(fileLocation, currentType, currentType, currentExpression, index, CBinaryExpression.BinaryOperator.PLUS));
            } else if (currentType instanceof CArrayType) {
                currentExpression = new CArraySubscriptExpression(fileLocation, ((CArrayType)currentType).getType().getCanonicalType(), currentExpression, index);
            } else if (currentType instanceof CCompositeType) {
                if (!(index instanceof CIntegerLiteralExpression)) {
                    throw new UnsupportedOperationException("GEP index to struct only allows integer constant, but is " + index);
                }
                int memberIndex = ((CIntegerLiteralExpression)index).getValue().intValue();
                CCompositeType.CCompositeTypeMemberDeclaration field = ((CCompositeType)currentType).getMembers().get(memberIndex);
                String fieldName = field.getName();
                currentExpression = currentExpression instanceof CPointerExpression ? new CFieldReference(fileLocation, field.getType(), fieldName, ((CPointerExpression)currentExpression).getOperand(), true) : new CFieldReference(fileLocation, field.getType(), fieldName, currentExpression, false);
            }
            currentType = currentExpression.getExpressionType();
        }
        return this.getReference(fileLocation, currentExpression);
    }

    private List<CAstNode> handleCmpInst(Value pItem, String pFunctionName, Path pFileName) throws LLVMException {
        CBinaryExpression.BinaryOperator operator;
        assert (pItem.isICmpInst()) : "Unsupported cmp instruction: " + pItem;
        boolean isUnsignedCmp = false;
        switch (pItem.getICmpPredicate()) {
            case IntEQ: {
                operator = CBinaryExpression.BinaryOperator.EQUALS;
                break;
            }
            case IntNE: {
                operator = CBinaryExpression.BinaryOperator.NOT_EQUALS;
                break;
            }
            case IntUGT: {
                isUnsignedCmp = true;
            }
            case IntSGT: {
                operator = CBinaryExpression.BinaryOperator.GREATER_THAN;
                break;
            }
            case IntULT: {
                isUnsignedCmp = true;
            }
            case IntSLT: {
                operator = CBinaryExpression.BinaryOperator.LESS_THAN;
                break;
            }
            case IntULE: {
                isUnsignedCmp = true;
            }
            case IntSLE: {
                operator = CBinaryExpression.BinaryOperator.LESS_EQUAL;
                break;
            }
            case IntUGE: {
                isUnsignedCmp = true;
            }
            case IntSGE: {
                operator = CBinaryExpression.BinaryOperator.GREATER_EQUAL;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported predicate");
            }
        }
        assert (operator != null);
        Value operand1 = pItem.getOperand(0);
        Value operand2 = pItem.getOperand(1);
        CType op1type = this.typeConverter.getCType(operand1.typeOf());
        CType op2type = this.typeConverter.getCType(operand2.typeOf());
        try {
            CCastExpression op1Cast = new CCastExpression(this.getLocation(pItem, pFileName), this.typeConverter.getCType(operand1.typeOf(), isUnsignedCmp), this.getExpression(operand1, op1type, pFileName));
            CCastExpression op2Cast = new CCastExpression(this.getLocation(pItem, pFileName), this.typeConverter.getCType(operand2.typeOf(), isUnsignedCmp), this.getExpression(operand2, op2type, pFileName));
            CBinaryExpression cmp = this.binaryExpressionBuilder.buildBinaryExpression(op1Cast, op2Cast, operator);
            return this.getAssignStatement(pItem, cmp, pFunctionName, pFileName);
        }
        catch (UnrecognizedCodeException e) {
            throw new UnsupportedOperationException(e.toString());
        }
    }

    private List<CAstNode> handleCastInst(Value pItem, String pFunctionName, Path pFileName) throws LLVMException {
        Value castOperand = pItem.getOperand(0);
        CType operandType = this.typeConverter.getCType(castOperand.typeOf());
        CCastExpression cast = new CCastExpression(this.getLocation(pItem, pFileName), this.typeConverter.getCType(pItem.typeOf()), this.getExpression(castOperand, operandType, pFileName));
        return this.getAssignStatement(pItem, cast, pFunctionName, pFileName);
    }

    private CDeclaration visitGlobalItem(Value pItem, Path pFileName) throws LLVMException {
        CInitializer initializer;
        assert (pItem.isGlobalValue());
        if (!pItem.isExternallyInitialized()) {
            Value initializerRaw = pItem.getInitializer();
            if (initializerRaw == null) {
                assert (pItem.getLinkage() == Value.Linkage.ExternalLinkage) : "Non-external global variable with no initializer: " + pItem;
                initializer = null;
            } else if (this.isConstantArrayOrVector(initializerRaw)) {
                initializer = this.getConstantAggregateInitializer(initializerRaw, pFileName);
            } else if (initializerRaw.isConstantStruct()) {
                initializer = this.getConstantAggregateInitializer(initializerRaw, pFileName);
            } else if (initializerRaw.isConstantAggregateZero()) {
                CType expressionType = this.typeConverter.getCType(initializerRaw.typeOf());
                initializer = this.getZeroInitializer(initializerRaw, expressionType, pFileName);
            } else {
                initializer = new CInitializerExpression(this.getLocation(pItem, pFileName), (CExpression)this.getConstant(initializerRaw, pFileName));
            }
        } else {
            initializer = null;
        }
        return (CDeclaration)this.getAssignedVarDeclaration(pItem, "", initializer, pFileName);
    }

    private boolean isConstantArrayOrVector(Value pItem) {
        return pItem.isConstantArray() || pItem.isConstantDataArray() || pItem.isConstantVector();
    }

    private FileLocation getLocation(Value pItem, Path pFileName) {
        assert (pItem != null);
        return new FileLocation(pFileName, 0, 1, 0, 0);
    }

    private static class BasicBlockInfo {
        private CFANode entryNode;
        private CFANode exitNode;

        public BasicBlockInfo(CFANode entry, CFANode exit) {
            this.entryNode = entry;
            this.exitNode = exit;
        }

        public CFANode getEntryNode() {
            return this.entryNode;
        }

        public CFANode getExitNode() {
            return this.exitNode;
        }

        public String toString() {
            return "BasicBlock " + this.entryNode + " -> " + this.exitNode;
        }
    }
}

