/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.llvm;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.Timer;
import org.sosy_lab.cpachecker.cfa.ParseResult;
import org.sosy_lab.cpachecker.cfa.Parser;
import org.sosy_lab.cpachecker.cfa.parser.llvm.CFABuilder;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.exceptions.LLVMParserException;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.llvm_j.Context;
import org.sosy_lab.llvm_j.LLVMException;
import org.sosy_lab.llvm_j.Module;

public class LlvmParser
implements Parser {
    private final LogManager logger;
    private final CFABuilder cfaBuilder;
    private final Timer parseTimer = new Timer();
    private final Timer cfaCreationTimer = new Timer();

    public LlvmParser(LogManager pLogger, MachineModel pMachineModel) {
        this.logger = pLogger;
        this.cfaBuilder = new CFABuilder(this.logger, pMachineModel);
    }

    @Override
    public ParseResult parseFiles(List<String> pFilenames) throws ParserException, InterruptedException, InvalidConfigurationException {
        if (pFilenames.size() > 1) {
            throw new InvalidConfigurationException("Multiple program files not supported when using LLVM frontend.");
        }
        return this.parseFile(Path.of(pFilenames.get(0), new String[0]));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected ParseResult parseFile(Path pFilename) throws LLVMParserException {
        this.addLlvmLookupDirs();
        try (Context llvmContext = Context.create();){
            ParseResult parseResult;
            block14: {
                Module llvmModule = Module.parseIR((String)pFilename.toString(), (Context)llvmContext);
                try {
                    this.parseTimer.start();
                    parseResult = this.buildCfa(llvmModule, pFilename);
                    if (llvmModule == null) break block14;
                }
                catch (Throwable throwable) {
                    if (llvmModule != null) {
                        try {
                            llvmModule.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                llvmModule.close();
            }
            return parseResult;
        }
        catch (LLVMException pE) {
            throw new LLVMParserException(pE);
        }
    }

    private void addLlvmLookupDirs() {
        ArrayList<Path> libDirs = new ArrayList<Path>(3);
        Path nativeDir = NativeLibraries.getNativeLibraryPath();
        libDirs.add(nativeDir);
        String encodedBasePath = LlvmParser.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        String decodedBasePath = URLDecoder.decode(encodedBasePath, StandardCharsets.UTF_8);
        Path cpacheckerDir = Path.of(decodedBasePath, new String[0]).getParent();
        if (cpacheckerDir != null) {
            Path runtimeLibDir = Path.of(cpacheckerDir.toString(), "lib", "java", "runtime");
            libDirs.add(runtimeLibDir);
        } else {
            this.logger.logf(Level.INFO, "Base path %s of CPAchecker seems to have no parent directory", new Object[]{decodedBasePath});
        }
        for (Path p : libDirs) {
            this.logger.logf(Level.FINE, "Adding llvm shared library lookup dir: %s", new Object[]{p});
        }
        Module.addLibraryLookupPaths(libDirs);
    }

    private ParseResult buildCfa(Module pModule, Path pFilename) throws LLVMException {
        return this.cfaBuilder.build(pModule, pFilename);
    }

    @Override
    public ParseResult parseString(Path pFilename, String pCode) throws ParserException, InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timer getParseTime() {
        return this.parseTimer;
    }

    @Override
    public Timer getCFAConstructionTime() {
        return this.cfaCreationTimer;
    }
}

