/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.parser.llvm;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.llvm_j.TypeRef;

public class LlvmTypeConverter {
    private static final String PREFIX_LITERAL_STRUCT = "lit_struc_";
    private static final String PREFIX_STRUCT_MEMBER = "elem_";
    private static final CSimpleType ARRAY_LENGTH_TYPE = CNumericTypes.LONG_LONG_INT;
    private static int structCount = 0;
    private final MachineModel machineModel;
    private final LogManager logger;
    private final Map<Integer, CType> typeCache = new HashMap<Integer, CType>();

    public LlvmTypeConverter(MachineModel pMachineModel, LogManager pLogger) {
        this.machineModel = pMachineModel;
        this.logger = pLogger;
    }

    public @Nullable CType getCType(TypeRef pLlvmType) {
        return this.getCType(pLlvmType, false);
    }

    public @Nullable CType getCType(TypeRef pLlvmType, boolean isUnsigned) {
        boolean isConst = false;
        boolean isVolatile = false;
        TypeRef.TypeKind typeKind = pLlvmType.getTypeKind();
        switch (typeKind) {
            case Void: {
                return CVoidType.VOID;
            }
            case Half: 
            case Float: 
            case Double: 
            case X86_FP80: 
            case FP128: 
            case PPC_FP128: {
                return this.getFloatType(typeKind, isUnsigned);
            }
            case Integer: {
                int integerWidth = pLlvmType.getIntTypeWidth();
                return this.getIntegerType(integerWidth, isUnsigned);
            }
            case Function: {
                return this.getFunctionType(pLlvmType);
            }
            case Struct: {
                return this.createStructType(pLlvmType);
            }
            case Array: {
                CIntegerLiteralExpression arrayLength = new CIntegerLiteralExpression(FileLocation.DUMMY, ARRAY_LENGTH_TYPE, BigInteger.valueOf(pLlvmType.getArrayLength()));
                return new CArrayType(false, false, this.getCType(pLlvmType.getElementType(), isUnsigned), arrayLength);
            }
            case Pointer: {
                if (pLlvmType.getPointerAddressSpace() != 0) {
                    this.logger.log(Level.WARNING, new Object[]{"Pointer address space not considered."});
                }
                return new CPointerType(false, false, this.getCType(pLlvmType.getElementType(), isUnsigned));
            }
            case Vector: {
                CIntegerLiteralExpression vectorLength = new CIntegerLiteralExpression(FileLocation.DUMMY, ARRAY_LENGTH_TYPE, BigInteger.valueOf(pLlvmType.getVectorSize()));
                return new CArrayType(false, false, this.getCType(pLlvmType.getElementType(), isUnsigned), vectorLength);
            }
            case Label: 
            case Metadata: 
            case X86_MMX: 
            case Token: {
                this.logger.log(Level.FINE, new Object[]{"Ignoring type kind", typeKind});
                return null;
            }
        }
        throw new AssertionError((Object)("Unhandled type kind " + typeKind));
    }

    private CType createStructType(TypeRef pStructType) {
        String structName;
        boolean isConst = false;
        boolean isVolatile = false;
        if (pStructType.isOpaqueStruct()) {
            this.logger.log(Level.INFO, new Object[]{"Ignoring opaque struct"});
        }
        String origName = structName = this.getStructName(pStructType);
        if (this.typeCache.containsKey(pStructType.hashCode())) {
            return new CElaboratedType(false, false, CComplexType.ComplexTypeKind.STRUCT, structName, origName, (CComplexType)this.typeCache.get(pStructType.hashCode()));
        }
        CCompositeType cStructType = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, structName, origName);
        this.typeCache.put(pStructType.hashCode(), cStructType);
        List memberTypes = pStructType.getStructElementTypes();
        ArrayList<CCompositeType.CCompositeTypeMemberDeclaration> members = new ArrayList<CCompositeType.CCompositeTypeMemberDeclaration>(memberTypes.size());
        for (int i = 0; i < memberTypes.size(); ++i) {
            String memberName = this.getMemberName(i);
            TypeRef memType = (TypeRef)memberTypes.get(i);
            CType cMemType = this.getCType(memType);
            CCompositeType.CCompositeTypeMemberDeclaration memDecl = new CCompositeType.CCompositeTypeMemberDeclaration(cMemType, memberName);
            members.add(memDecl);
        }
        cStructType.setMembers(members);
        return cStructType;
    }

    private String getStructName(TypeRef pStructType) {
        if (pStructType.isStructNamed()) {
            return pStructType.getStructName().replace(".", "_");
        }
        return this.getLiteralStructName();
    }

    private String getLiteralStructName() {
        return PREFIX_LITERAL_STRUCT + ++structCount;
    }

    private String getMemberName(int pI) {
        return PREFIX_STRUCT_MEMBER + pI;
    }

    private CType getFunctionType(TypeRef pFuncType) {
        CType returnType = this.getCType(pFuncType.getReturnType());
        int paramNumber = pFuncType.countParamTypes();
        ArrayList<CType> parameterTypes = new ArrayList<CType>(paramNumber);
        List paramTypes = pFuncType.getParamTypes();
        for (TypeRef type : paramTypes) {
            CType cParamType = this.getCType(type);
            parameterTypes.add(cParamType);
        }
        boolean takesVarArgs = pFuncType.isFunctionVarArg();
        return new CFunctionType(returnType, parameterTypes, takesVarArgs);
    }

    private CType getIntegerType(int pIntegerWidth, boolean isUnsigned) {
        int sizeOfChar = this.machineModel.getSizeofCharInBits();
        if (this.machineModel.getSizeofInt() * sizeOfChar == pIntegerWidth) {
            if (isUnsigned) {
                return CNumericTypes.UNSIGNED_INT;
            }
            return CNumericTypes.SIGNED_INT;
        }
        if (this.machineModel.getSizeofLongInt() * sizeOfChar == pIntegerWidth) {
            if (isUnsigned) {
                return CNumericTypes.UNSIGNED_LONG_INT;
            }
            return CNumericTypes.SIGNED_LONG_INT;
        }
        if (this.machineModel.getSizeofLongLongInt() * sizeOfChar == pIntegerWidth) {
            if (isUnsigned) {
                return CNumericTypes.UNSIGNED_LONG_LONG_INT;
            }
            return CNumericTypes.SIGNED_LONG_LONG_INT;
        }
        return new CBitFieldType(isUnsigned ? CNumericTypes.UNSIGNED_INT : CNumericTypes.SIGNED_INT, pIntegerWidth);
    }

    private CType getFloatType(TypeRef.TypeKind pType, boolean isUnsigned) {
        switch (pType) {
            case Half: {
                return this.getSimplestCType(CBasicType.FLOAT, isUnsigned);
            }
            case Float: {
                return this.getSimplestCType(CBasicType.FLOAT, isUnsigned);
            }
            case Double: {
                if (this.machineModel.getSizeofDouble() * 8 == 64) {
                    return this.getSimplestCType(CBasicType.DOUBLE, isUnsigned);
                }
                if (this.machineModel.getSizeofLongDouble() * 8 == 64) {
                    return this.getSimplestCType(CBasicType.DOUBLE, isUnsigned, true);
                }
                throw new AssertionError((Object)("Machine model " + this.machineModel.name() + " can't handle 64bit float"));
            }
            case FP128: 
            case PPC_FP128: {
                Preconditions.checkState((this.machineModel.getSizeofFloat128() * 8 == 128 ? 1 : 0) != 0);
                return this.getSimplestCType(CBasicType.FLOAT128, isUnsigned);
            }
            case X86_FP80: {
                throw new AssertionError((Object)("Machine model " + this.machineModel.name() + " can't handle 80bit float"));
            }
        }
        throw new AssertionError((Object)("Unhandled float type " + pType));
    }

    private CType getSimplestCType(CBasicType pBasicType, boolean isUnsigned) {
        return this.getSimplestCType(pBasicType, isUnsigned, false);
    }

    private CType getSimplestCType(CBasicType pBasicType, boolean isUnsigned, boolean pIsLong) {
        boolean isConst = false;
        boolean isVolatile = false;
        boolean isShort = false;
        boolean isSigned = false;
        boolean isComplex = false;
        boolean isImaginary = false;
        boolean isLongLong = false;
        return new CSimpleType(false, false, pBasicType, pIsLong, false, false, isUnsigned, false, false, false);
    }
}

