/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.ADeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CFADeclarationMover {
    LogManager logger;

    public CFADeclarationMover(LogManager log) {
        this.logger = log;
    }

    public void moveDeclarationsToFunctionStart(MutableCFA cfa) {
        Collection<FunctionEntryNode> startNodes = cfa.getAllFunctionHeads();
        for (FunctionEntryNode node : startNodes) {
            this.handleDeclarationsInFunction(node, cfa);
        }
    }

    private void handleDeclarationsInFunction(FunctionEntryNode startNode, MutableCFA cfa) {
        CFAEdge firstRealFunctionEdge = startNode.getLeavingEdge(0);
        ArrayList<BlankEdge> secondRealFunctionEdge = new ArrayList<BlankEdge>();
        AFunctionDeclaration function = startNode.getFunction();
        while (!firstRealFunctionEdge.getDescription().equals("Function start dummy edge")) {
            firstRealFunctionEdge = firstRealFunctionEdge.getSuccessor().getLeavingEdge(0);
        }
        CFANode actNode = firstRealFunctionEdge.getSuccessor();
        CFAUtils.leavingEdges(actNode).copyInto(secondRealFunctionEdge);
        List<CFAEdge> declarations = this.collectDeclarations(actNode);
        if (!declarations.isEmpty()) {
            CFANode tmpNode = new CFANode(function);
            cfa.addNode(tmpNode);
            BlankEdge blankEdge = new BlankEdge("End of Declarations", FileLocation.DUMMY, actNode, tmpNode, "End of Declarations");
            tmpNode.addEnteringEdge(blankEdge);
            for (CFAEdge cFAEdge : secondRealFunctionEdge) {
                CFAEdge tmpEdge = this.moveEdgeToOtherPredecessor(cFAEdge, tmpNode);
                actNode.removeLeavingEdge(cFAEdge);
                if (!declarations.contains(cFAEdge)) continue;
                declarations.add(declarations.indexOf(cFAEdge), tmpEdge);
                declarations.remove(cFAEdge);
            }
            secondRealFunctionEdge.clear();
            secondRealFunctionEdge.add(blankEdge);
        }
        for (CFAEdge cFAEdge : declarations) {
            CFANode middleNode = new CFANode(function);
            cfa.addNode(middleNode);
            this.moveDeclEdgeToNewLocation((CDeclarationEdge)cFAEdge, actNode, middleNode);
            actNode = middleNode;
        }
        if (!declarations.isEmpty()) {
            for (CFAEdge cFAEdge : secondRealFunctionEdge) {
                this.moveEdgeToOtherPredecessor(cFAEdge, actNode);
            }
        }
    }

    private CFAEdge moveEdgeToOtherPredecessor(CFAEdge edge, CFANode pred) {
        CFANode succ = edge.getSuccessor();
        succ.removeEnteringEdge(edge);
        switch (edge.getEdgeType()) {
            case AssumeEdge: {
                edge = new CAssumeEdge(edge.getRawStatement(), edge.getFileLocation(), pred, edge.getSuccessor(), ((CAssumeEdge)edge).getExpression(), ((CAssumeEdge)edge).getTruthAssumption(), ((CAssumeEdge)edge).isSwapped(), ((CAssumeEdge)edge).isArtificialIntermediate());
                pred.addLeavingEdge(edge);
                succ.addEnteringEdge(edge);
                return edge;
            }
            case BlankEdge: {
                edge = new BlankEdge(edge.getRawStatement(), edge.getFileLocation(), pred, edge.getSuccessor(), edge.getDescription());
                pred.addLeavingEdge(edge);
                succ.addEnteringEdge(edge);
                return edge;
            }
            case DeclarationEdge: {
                edge = new CDeclarationEdge(edge.getRawStatement(), edge.getFileLocation(), pred, edge.getSuccessor(), ((CDeclarationEdge)edge).getDeclaration());
                pred.addLeavingEdge(edge);
                succ.addEnteringEdge(edge);
                return edge;
            }
            case ReturnStatementEdge: {
                edge = new CReturnStatementEdge(edge.getRawStatement(), ((CReturnStatementEdge)edge).getReturnStatement(), edge.getFileLocation(), pred, (FunctionExitNode)edge.getSuccessor());
                pred.addLeavingEdge(edge);
                succ.addEnteringEdge(edge);
                return edge;
            }
            case StatementEdge: {
                edge = new CStatementEdge(edge.getRawStatement(), ((CStatementEdge)edge).getStatement(), edge.getFileLocation(), pred, edge.getSuccessor());
                pred.addLeavingEdge(edge);
                succ.addEnteringEdge(edge);
                return edge;
            }
        }
        throw new AssertionError((Object)"should never happen");
    }

    private void moveDeclEdgeToNewLocation(CDeclarationEdge edge, CFANode pred, CFANode succ) {
        BlankEdge midEdge;
        CDeclaration decl = edge.getDeclaration();
        if (!(decl instanceof CVariableDeclaration)) {
            throw new AssertionError((Object)"Only variable declaration edges should be moved!");
        }
        CFANode actPred = edge.getPredecessor();
        CFANode actSucc = edge.getSuccessor();
        CVariableDeclaration varDecl = (CVariableDeclaration)decl;
        CInitializer init = varDecl.getInitializer();
        if (init instanceof CInitializerExpression) {
            actPred.removeLeavingEdge(edge);
            actSucc.removeEnteringEdge(edge);
            CExpressionAssignmentStatement stmt = new CExpressionAssignmentStatement(varDecl.getFileLocation(), new CIdExpression(varDecl.getFileLocation(), varDecl), ((CInitializerExpression)init).getExpression());
            CStatementEdge midEdge2 = new CStatementEdge(edge.getRawStatement(), stmt, edge.getFileLocation(), actPred, actSucc);
            actPred.addLeavingEdge(midEdge2);
            actSucc.addEnteringEdge(midEdge2);
        } else if (init != null) {
            this.logger.log(Level.WARNING, new Object[]{"Moving declaration to function start does not work correctly for initializer lists and designated initializers for arrays or structs, do not use the CFADeclarationMover if you are able to handle such expressions."});
            actPred.removeLeavingEdge(edge);
            actSucc.removeEnteringEdge(edge);
            midEdge = new BlankEdge(edge.getRawStatement(), edge.getFileLocation(), actPred, actSucc, "Declaration was moved to function start");
            actPred.addLeavingEdge(midEdge);
            actSucc.addEnteringEdge(midEdge);
        } else {
            actPred.removeLeavingEdge(edge);
            actSucc.removeEnteringEdge(edge);
            midEdge = new BlankEdge(edge.getRawStatement(), edge.getFileLocation(), actPred, actSucc, "Declaration was moved to function start");
            actPred.addLeavingEdge(midEdge);
            actSucc.addEnteringEdge(midEdge);
        }
        CVariableDeclaration declWithoutInitializer = new CVariableDeclaration(varDecl.getFileLocation(), varDecl.isGlobal(), varDecl.getCStorageClass(), varDecl.getType(), varDecl.getName(), varDecl.getOrigName(), varDecl.getQualifiedName(), null);
        CDeclarationEdge newEdge = new CDeclarationEdge(edge.getRawStatement(), edge.getFileLocation(), pred, succ, declWithoutInitializer);
        pred.addLeavingEdge(newEdge);
        succ.addEnteringEdge(newEdge);
    }

    private List<CFAEdge> collectDeclarations(CFANode startNode) {
        DeclarationCollector dc = new DeclarationCollector();
        CFATraversal.dfs().ignoreSummaryEdges().ignoreFunctionCalls().traverseOnce(startNode, dc);
        return dc.getCollectedDeclarations();
    }

    private static class DeclarationCollector
    extends CFATraversal.DefaultCFAVisitor {
        private final List<CFAEdge> edges = new ArrayList<CFAEdge>();

        public List<CFAEdge> getCollectedDeclarations() {
            return this.edges;
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge edge) {
            if (edge instanceof ADeclarationEdge && ((ADeclarationEdge)edge).getDeclaration() instanceof AVariableDeclaration) {
                this.edges.add(edge);
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }
    }
}

