/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.function;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.CFAUtils;

public class CFASimplifier {
    public static void simplifyCFA(MutableCFA cfa) {
        for (CFANode cFANode : cfa.getAllFunctionHeads()) {
            CFASimplifier.simplifyFunction(cFANode, cfa);
        }
    }

    private static void simplifyFunction(CFANode root, MutableCFA cfa) {
        Deque<CFANode> branchingPoints = CFASimplifier.findBranchingPoints(root, cfa);
        assert (branchingPoints.size() == new HashSet<CFANode>(branchingPoints).size()) : "branchingPoints contains duplicate CFANode " + branchingPoints;
        while (!branchingPoints.isEmpty()) {
            CFANode branchingPoint = branchingPoints.pollLast();
            CFASimplifier.simplifyBranching(branchingPoint, cfa);
        }
    }

    private static Deque<CFANode> findBranchingPoints(CFANode root, MutableCFA cfa) {
        boolean foundAtLeastOneBlankEdgeAssume = false;
        for (CFANode node : cfa.getFunctionNodes(root.getFunctionName())) {
            if (node.getNumLeavingEdges() == 2) {
                CFAEdge edge1 = node.getLeavingEdge(0);
                CFAEdge edge2 = node.getLeavingEdge(1);
                if (edge1 instanceof AssumeEdge && edge2 instanceof AssumeEdge) {
                    CFANode succ1 = edge1.getSuccessor();
                    CFANode succ2 = edge2.getSuccessor();
                    boolean bl = foundAtLeastOneBlankEdgeAssume = succ1.getNumLeavingEdges() == 1 && succ1.getLeavingEdge(0) instanceof BlankEdge && succ2.getNumLeavingEdges() == 1 && succ2.getLeavingEdge(0) instanceof BlankEdge;
                }
            }
            if (!foundAtLeastOneBlankEdgeAssume) continue;
            break;
        }
        if (!foundAtLeastOneBlankEdgeAssume) {
            return new ArrayDeque<CFANode>();
        }
        ArrayDeque<CFANode> branchingPoints = new ArrayDeque<CFANode>();
        HashSet<CFANode> visitedNodes = new HashSet<CFANode>();
        ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
        waitlist.push(root);
        while (!waitlist.isEmpty()) {
            CFANode current = (CFANode)waitlist.pollLast();
            if (visitedNodes.contains(current) || !visitedNodes.containsAll((Collection<?>)CFAUtils.predecessorsOf(current).toList())) continue;
            visitedNodes.add(current);
            if (current.getNumLeavingEdges() > 1) {
                if (current.getNumLeavingEdges() > 2) {
                    throw new AssertionError((Object)("More than 2 leaving edges on node " + current + " in function " + current.getFunctionName()));
                }
                assert (CFAUtils.allLeavingEdges(current).allMatch(Predicates.instanceOf(AssumeEdge.class)));
                boolean firstNodeQualifies = CFASimplifier.nodeQualifiesForPossibleRemoval(current.getLeavingEdge(0).getSuccessor());
                boolean secondNodeQualifies = CFASimplifier.nodeQualifiesForPossibleRemoval(current.getLeavingEdge(1).getSuccessor());
                if (firstNodeQualifies && secondNodeQualifies) {
                    branchingPoints.addLast(current);
                }
            }
            Iterables.addAll(waitlist, CFAUtils.successorsOf(current));
        }
        return branchingPoints;
    }

    private static boolean nodeQualifiesForPossibleRemoval(CFANode node) {
        int numLeavingEdges = node.getNumLeavingEdges();
        if (numLeavingEdges == 1) {
            return node.getLeavingEdge(0).getEdgeType() == CFAEdgeType.BlankEdge;
        }
        if (numLeavingEdges == 2) {
            return node.getLeavingEdge(0).getEdgeType() == CFAEdgeType.AssumeEdge && node.getLeavingEdge(1).getEdgeType() == CFAEdgeType.AssumeEdge;
        }
        return false;
    }

    private static void simplifyBranching(CFANode branchingPoint, MutableCFA cfa) {
        CFANode rightEndpoint;
        CFANode leftEndpoint = CFASimplifier.findEndOfBlankEdgeChain(branchingPoint.getLeavingEdge(0).getSuccessor());
        if (leftEndpoint.equals(rightEndpoint = CFASimplifier.findEndOfBlankEdgeChain(branchingPoint.getLeavingEdge(1).getSuccessor()))) {
            CFANode endpoint2;
            CFANode endpoint = leftEndpoint;
            ArrayList<FileLocation> removedFileLocations = new ArrayList<FileLocation>();
            CFAEdge leftEdge = branchingPoint.getLeavingEdge(0);
            CFAEdge rightEdge = branchingPoint.getLeavingEdge(1);
            branchingPoint.removeLeavingEdge(leftEdge);
            assert (leftEdge instanceof AssumeEdge);
            removedFileLocations.add(leftEdge.getFileLocation());
            CFANode toRemove = leftEdge.getSuccessor();
            toRemove.removeEnteringEdge(leftEdge);
            CFASimplifier.removeChainOfNodes(toRemove, endpoint, cfa, removedFileLocations);
            branchingPoint.removeLeavingEdge(rightEdge);
            assert (rightEdge instanceof AssumeEdge);
            removedFileLocations.add(rightEdge.getFileLocation());
            toRemove = rightEdge.getSuccessor();
            toRemove.removeEnteringEdge(rightEdge);
            CFASimplifier.removeChainOfNodes(toRemove, endpoint, cfa, removedFileLocations);
            if (endpoint.getNumEnteringEdges() == 0) {
                endpoint2 = CFASimplifier.findEndOfBlankEdgeChain(endpoint);
                CFASimplifier.removeChainOfNodes(endpoint, endpoint2, cfa, removedFileLocations);
            } else {
                endpoint2 = endpoint;
            }
            BlankEdge blankEdge = new BlankEdge("skipped unnecessary edges", FileLocation.merge(removedFileLocations), branchingPoint, endpoint2, "skipped unnecessary edges");
            CFACreationUtils.addEdgeUnconditionallyToCFA(blankEdge);
        }
    }

    private static CFANode findEndOfBlankEdgeChain(CFANode current) {
        HashSet<CFANode> visitedNodes = new HashSet<CFANode>();
        while (current.getNumLeavingEdges() == 1 && current.getLeavingEdge(0) instanceof BlankEdge && current.getNumEnteringEdges() <= 1) {
            if (!visitedNodes.add(current)) {
                return current;
            }
            current = current.getLeavingEdge(0).getSuccessor();
        }
        return current;
    }

    private static void removeChainOfNodes(CFANode start, CFANode endpoint, MutableCFA cfa, List<FileLocation> removedFileLocations) {
        CFANode toRemove = start;
        while (!toRemove.equals(endpoint)) {
            assert (toRemove.getNumEnteringEdges() == 0);
            assert (toRemove.getNumLeavingEdges() == 1);
            CFAEdge leavingEdge = toRemove.getLeavingEdge(0);
            toRemove.removeLeavingEdge(leavingEdge);
            cfa.removeNode(toRemove);
            CFANode nextNode = leavingEdge.getSuccessor();
            nextNode.removeEnteringEdge(leavingEdge);
            assert (leavingEdge instanceof BlankEdge);
            removedFileLocations.add(leavingEdge.getFileLocation());
            toRemove = nextNode;
        }
    }
}

