/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.function;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.ADeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.CReferencedFunctionsCollector;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.CReferencedFunctionsCollectorWithFieldsMatching;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.EdgeReplacerFunctionPointer;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.EdgeReplacerParameterFunctionPointer;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.TargetFunctionsProvider;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionTypeWithNames;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.StatInt;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;

@Options
public class CFunctionPointerResolver
implements StatisticsProvider {
    @Option(secure=true, name="analysis.matchAssignedFunctionPointers", description="Use as targets for call edges only those shich are assigned to the particular expression (structure field).")
    private boolean matchAssignedFunctionPointers = false;
    @Option(secure=true, name="analysis.matchAssignedFunctionPointers.ignoreUnknownAssignments", description="If a no target function was assigned to a function pointer, use the origin heuristic instead of replacing with empty calls")
    private boolean ignoreUnknownAssignments = false;
    @Option(secure=true, name="analysis.replaceFunctionWithParameterPointer", description="Use if you are going to change function with function pionter parameter")
    private boolean replaceFunctionWithParameterPointer = false;
    @Option(secure=true, name="analysis.functionPointerTargets", description="potential targets for call edges created for function pointer calls")
    private Set<FunctionSet> functionSets = ImmutableSet.of((Object)((Object)FunctionSet.USED_IN_CODE), (Object)((Object)FunctionSet.RETURN_VALUE), (Object)((Object)FunctionSet.EQ_PARAM_TYPES), (Object)((Object)FunctionSet.EQ_PARAM_SIZES), (Object)((Object)FunctionSet.EQ_PARAM_COUNT));
    @Option(secure=true, name="analysis.functionPointerParameterTargets", description="potential targets for call edges created for function pointer parameter calls")
    private Set<FunctionSet> functionParameterSets = ImmutableSet.of((Object)((Object)FunctionSet.USED_IN_CODE), (Object)((Object)FunctionSet.RETURN_VALUE), (Object)((Object)FunctionSet.EQ_PARAM_TYPES));
    private final CFunctionPointerResolverStatistics stats = new CFunctionPointerResolverStatistics();
    private final TargetFunctionsProvider targetFunctionsProvider;
    private final TargetFunctionsProvider targetParameterFunctionsProvider;
    private final MutableCFA cfa;
    private final LogManager logger;
    private final Configuration pConfig;

    public CFunctionPointerResolver(MutableCFA pCfa, List<Pair<ADeclaration, String>> pGlobalVars, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        this.cfa = pCfa;
        this.logger = pLogger;
        this.pConfig = config;
        config.inject((Object)this);
        this.targetFunctionsProvider = this.createMatchingFunctions(pGlobalVars, this.functionSets);
        this.targetParameterFunctionsProvider = this.createMatchingFunctions(pGlobalVars, this.functionParameterSets);
    }

    private TargetFunctionsProvider createMatchingFunctions(List<Pair<ADeclaration, String>> pGlobalVars, Collection<FunctionSet> pFunctionSets) {
        if (pFunctionSets.contains((Object)FunctionSet.USED_IN_CODE)) {
            CReferencedFunctionsCollector varCollector = this.matchAssignedFunctionPointers ? new CReferencedFunctionsCollectorWithFieldsMatching() : new CReferencedFunctionsCollector();
            for (CFANode node : this.cfa.getAllNodes()) {
                for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                    varCollector.visitEdge(edge);
                }
            }
            for (Pair decl : pGlobalVars) {
                if (!(decl.getFirst() instanceof CVariableDeclaration)) continue;
                CVariableDeclaration varDecl = (CVariableDeclaration)decl.getFirst();
                varCollector.visitDeclaration(varDecl);
            }
            Set<String> addressedFunctions = varCollector.getCollectedFunctions();
            ImmutableList candidateFunctions = Collections3.transformedImmutableListCopy((Collection)Sets.intersection(addressedFunctions, this.cfa.getAllFunctionNames()), (Function)Functions.forMap(this.cfa.getAllFunctions()));
            if (this.logger.wouldBeLogged(Level.ALL)) {
                this.logger.log(Level.ALL, new Object[]{"Possible target functions of function pointers:\n", Joiner.on((char)'\n').join((Iterable)candidateFunctions)});
            }
            if (this.matchAssignedFunctionPointers) {
                return new TargetFunctionsProvider(this.cfa.getMachineModel(), this.logger, pFunctionSets, (Collection<FunctionEntryNode>)candidateFunctions, ((CReferencedFunctionsCollectorWithFieldsMatching)varCollector).getFieldMatching(), ((CReferencedFunctionsCollectorWithFieldsMatching)varCollector).getGlobalsMatching());
            }
            return new TargetFunctionsProvider(this.cfa.getMachineModel(), this.logger, pFunctionSets, (Collection<FunctionEntryNode>)candidateFunctions);
        }
        return new TargetFunctionsProvider(this.cfa.getMachineModel(), this.logger, pFunctionSets, this.cfa.getAllFunctionHeads());
    }

    public void resolveFunctionPointers() throws InvalidConfigurationException {
        this.stats.totalTimer.start();
        FunctionPointerCallCollector visitor = new FunctionPointerCallCollector();
        for (FunctionEntryNode functionEntryNode : this.cfa.getAllFunctionHeads()) {
            CFATraversal.dfs().traverseOnce(functionEntryNode, visitor);
        }
        EdgeReplacerFunctionPointer edgeReplacerFunctionPointer = new EdgeReplacerFunctionPointer(this.cfa, this.pConfig, this.logger);
        for (CStatementEdge edge : visitor.functionPointerCalls) {
            CExpression operand;
            CFunctionCall functionCall = (CFunctionCall)edge.getStatement();
            CFunctionCallExpression fExp = functionCall.getFunctionCallExpression();
            CExpression nameExp = fExp.getFunctionNameExpression();
            CFunctionType func = (CFunctionType)nameExp.getExpressionType().getCanonicalType();
            this.logger.log(Level.FINEST, new Object[]{"Function pointer call", fExp});
            Collection<CFunctionEntryNode> funcs = this.getTargets(nameExp, func, this.targetFunctionsProvider);
            if (nameExp instanceof CPointerExpression && CTypes.isFunctionPointer((operand = ((CPointerExpression)nameExp).getOperand()).getExpressionType())) {
                nameExp = operand;
            }
            edgeReplacerFunctionPointer.instrument(edge, funcs, nameExp);
        }
        EdgeReplacerParameterFunctionPointer edgeReplacerParameterFunctionPointer = new EdgeReplacerParameterFunctionPointer(this.cfa, this.pConfig, this.logger);
        for (CStatementEdge edge : visitor.functionParameterPointerCalls) {
            CExpression param = this.getParameter((CFunctionCall)edge.getStatement());
            CFunctionType func = (CFunctionType)((CPointerType)param.getExpressionType()).getType().getCanonicalType();
            this.logger.log(Level.FINEST, new Object[]{"Function pointer param", param});
            Collection<CFunctionEntryNode> funcs = this.getTargets(param, func, this.targetParameterFunctionsProvider);
            edgeReplacerParameterFunctionPointer.instrument(edge, funcs, param);
        }
        this.stats.totalFPs.setNextValue(visitor.functionPointerCalls.size());
        this.stats.instrumentedFPs.setNextValue(edgeReplacerFunctionPointer.getNumberOfInstrumenetedFunctions());
        this.stats.totalFPsWithParameter.setNextValue(visitor.functionParameterPointerCalls.size());
        this.stats.instrumentedFPsWithParameter.setNextValue(edgeReplacerParameterFunctionPointer.getNumberOfInstrumenetedFunctions());
        this.stats.totalTimer.stop();
    }

    private @Nullable CExpression getParameter(CFunctionCall call) {
        for (CExpression param : call.getFunctionCallExpression().getParameterExpressions()) {
            if (!(param.getExpressionType() instanceof CPointerType) || !(((CPointerType)param.getExpressionType()).getType() instanceof CFunctionTypeWithNames) || (!(param instanceof CIdExpression) || !(((CIdExpression)param).getDeclaration().getType() instanceof CPointerType)) && !(param instanceof CFieldReference)) continue;
            return param;
        }
        return null;
    }

    private boolean isFunctionPointerCall(CFunctionCall call) {
        CFunctionCallExpression callExpr = call.getFunctionCallExpression();
        if (callExpr.getDeclaration() != null) {
            return false;
        }
        CExpression nameExpr = callExpr.getFunctionNameExpression();
        return !(nameExpr instanceof CIdExpression) || ((CIdExpression)nameExpr).getDeclaration() != null;
    }

    private Collection<CFunctionEntryNode> getTargets(CExpression nameExp, CFunctionType func, TargetFunctionsProvider targetFunctions) {
        ImmutableSet funcs = targetFunctions.getFunctionSet(func);
        if (this.matchAssignedFunctionPointers) {
            Set<String> matchedFuncs;
            CExpression expression = nameExp;
            if (expression instanceof CPointerExpression) {
                expression = ((CPointerExpression)expression).getOperand();
            }
            if ((matchedFuncs = targetFunctions.getMatchedFunc(expression)).isEmpty() && !this.ignoreUnknownAssignments) {
                CSimpleDeclaration decl = null;
                if (expression instanceof CIdExpression) {
                    decl = ((CIdExpression)expression).getDeclaration();
                }
                if (decl == null) {
                    funcs = ImmutableSet.of();
                } else if (decl instanceof CDeclaration && ((CDeclaration)decl).isGlobal()) {
                    funcs = ImmutableSet.of();
                }
            } else {
                funcs = FluentIterable.from(funcs).filter(f -> matchedFuncs.contains(f.getFunctionName())).toSet();
            }
        }
        if (funcs.isEmpty()) {
            this.logger.logf(Level.WARNING, "%s: Function pointer %s with type %s is called, but no possible target functions were found.", new Object[]{nameExp.getFileLocation(), nameExp.toASTString(), nameExp.getExpressionType().toASTString("*")});
        } else {
            this.logger.log(Level.FINEST, new Object[]{"Inserting edges for the function pointer", nameExp.toASTString(), "with type", nameExp.getExpressionType().toASTString("*"), "to the functions", FluentIterable.from((Iterable)funcs).transform(CFANode::getFunctionName)});
        }
        return funcs;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    private class FunctionPointerCallCollector
    extends CFATraversal.DefaultCFAVisitor {
        final List<CStatementEdge> functionPointerCalls = new ArrayList<CStatementEdge>();
        final List<CStatementEdge> functionParameterPointerCalls = new ArrayList<CStatementEdge>();

        private FunctionPointerCallCollector() {
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
            if (pEdge instanceof CStatementEdge) {
                CStatementEdge edge = (CStatementEdge)pEdge;
                CStatement stmt = edge.getStatement();
                if (this.checkEdge(stmt)) {
                    this.functionPointerCalls.add(edge);
                }
                if (CFunctionPointerResolver.this.replaceFunctionWithParameterPointer && this.checkParameterEdge(stmt)) {
                    this.functionParameterPointerCalls.add(edge);
                }
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        private boolean checkEdge(AStatement stmt) {
            return stmt instanceof CFunctionCall && CFunctionPointerResolver.this.isFunctionPointerCall((CFunctionCall)stmt);
        }

        private boolean checkParameterEdge(AStatement stmt) {
            return stmt instanceof CFunctionCall && !CFunctionPointerResolver.this.isFunctionPointerCall((CFunctionCall)stmt) && CFunctionPointerResolver.this.getParameter((CFunctionCall)stmt) != null;
        }
    }

    private static class CFunctionPointerResolverStatistics
    implements Statistics {
        private StatInt totalFPs = new StatInt(StatKind.SUM, "Function calls via function pointers");
        private StatInt instrumentedFPs = new StatInt(StatKind.SUM, "Instrumented function pointer calls");
        private StatInt totalFPsWithParameter = new StatInt(StatKind.SUM, "Function calls with function pointer arguments");
        private StatInt instrumentedFPsWithParameter = new StatInt(StatKind.SUM, "Instrumented function pointer arguments");
        private StatTimer totalTimer = new StatTimer("Time for function pointers resolving");

        private CFunctionPointerResolverStatistics() {
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
            if (this.totalTimer.getUpdateCount() > 0) {
                this.put(out, 3, this.totalTimer);
                this.put(out, 4, this.totalFPs);
                this.put(out, 4, this.instrumentedFPs);
                this.put(out, 4, this.totalFPsWithParameter);
                this.put(out, 4, this.instrumentedFPsWithParameter);
            }
        }
    }

    static enum FunctionSet {
        ALL,
        USED_IN_CODE,
        EQ_PARAM_COUNT,
        EQ_PARAM_SIZES,
        EQ_PARAM_TYPES,
        RETURN_VALUE;

    }
}

