/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.function;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.CReferencedFunctionsCollector;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;

class CReferencedFunctionsCollectorWithFieldsMatching
extends CReferencedFunctionsCollector {
    public CReferencedFunctionsCollectorWithFieldsMatching() {
        this.collector = new CollectFunctionsVisitorWithFieldMatching(this.collectedFunctions);
    }

    Multimap<String, String> getFieldMatching() {
        return ((CollectFunctionsVisitorWithFieldMatching)this.collector).functionToFieldMatching;
    }

    Multimap<String, String> getGlobalsMatching() {
        return ((CollectFunctionsVisitorWithFieldMatching)this.collector).functionToGlobalMatching;
    }

    @Override
    public void visitDeclaration(CVariableDeclaration decl) {
        if (decl.getInitializer() != null) {
            decl.getInitializer().accept(this.collector);
            CInitializer init = decl.getInitializer();
            if (init instanceof CInitializerList) {
                this.saveStructureDeclaration(decl.getType(), (CInitializerList)init);
            } else if (decl.isGlobal() && init instanceof CInitializerExpression) {
                this.saveInitializerExpression(this.getGlobalsMatching(), (CInitializerExpression)init, decl.getName());
            }
        }
    }

    private void saveStructureDeclaration(CType type, CInitializerList init) {
        block6: {
            block8: {
                block7: {
                    block5: {
                        if (!(type instanceof CArrayType)) break block5;
                        for (CInitializer cInit : init.getInitializers()) {
                            if (!(cInit instanceof CInitializerList)) continue;
                            this.saveStructureDeclaration(((CArrayType)type).getType(), (CInitializerList)cInit);
                        }
                        break block6;
                    }
                    if (!(type instanceof CElaboratedType)) break block7;
                    this.saveStructureDeclaration(type.getCanonicalType(), init);
                    break block6;
                }
                if (!(type instanceof CTypedefType)) break block8;
                this.saveStructureDeclaration(((CTypedefType)type).getRealType(), init);
                break block6;
            }
            if (!(type instanceof CCompositeType)) break block6;
            List<CCompositeType.CCompositeTypeMemberDeclaration> list = ((CCompositeType)type).getMembers();
            List<CInitializer> initList = init.getInitializers();
            for (int i = 0; i < initList.size(); ++i) {
                CCompositeType.CCompositeTypeMemberDeclaration decl = list.get(i);
                CInitializer cInit = initList.get(i);
                if (cInit instanceof CDesignatedInitializer) {
                    List<CDesignator> des = ((CDesignatedInitializer)cInit).getDesignators();
                    assert (des.size() == 1);
                    CDesignator field = des.get(0);
                    CInitializer fieldInit = ((CDesignatedInitializer)cInit).getRightHandSide();
                    if (fieldInit instanceof CInitializerExpression && field instanceof CFieldDesignator) {
                        this.saveInitializerExpression(this.getFieldMatching(), (CInitializerExpression)fieldInit, ((CFieldDesignator)field).getFieldName());
                    }
                }
                if (!(cInit instanceof CInitializerExpression)) continue;
                this.saveInitializerExpression(this.getFieldMatching(), (CInitializerExpression)cInit, decl.getName());
            }
        }
    }

    private void saveInitializerExpression(Multimap<String, String> map, CInitializerExpression cInit, String fieldName) {
        CType type;
        CExpression initExpression = cInit.getExpression();
        if (initExpression instanceof CCastExpression) {
            initExpression = ((CCastExpression)initExpression).getOperand();
        }
        if ((type = initExpression.getExpressionType().getCanonicalType()) instanceof CPointerType && (type = ((CPointerType)type).getType()) instanceof CFunctionType) {
            if (initExpression instanceof CUnaryExpression) {
                initExpression = ((CUnaryExpression)initExpression).getOperand();
            }
            if (initExpression instanceof CIdExpression) {
                map.put((Object)fieldName, (Object)((CIdExpression)initExpression).getName());
            }
        }
    }

    private static class CollectFunctionsVisitorWithFieldMatching
    extends CReferencedFunctionsCollector.CollectFunctionsVisitor {
        private final Multimap<String, String> functionToFieldMatching = HashMultimap.create();
        private final Multimap<String, String> functionToGlobalMatching = HashMultimap.create();
        private @Nullable String lastFunction;

        public CollectFunctionsVisitorWithFieldMatching(Set<String> collectedFuncs) {
            super(collectedFuncs);
        }

        @Override
        public Void visit(CIdExpression pE) {
            super.visit(pE);
            if (pE.getExpressionType() instanceof CFunctionType) {
                this.lastFunction = pE.getName();
            }
            return null;
        }

        @Override
        public @Nullable Void visit(CExpressionAssignmentStatement pIastExpressionAssignmentStatement) {
            int num = this.collectedFunctions.size();
            pIastExpressionAssignmentStatement.getLeftHandSide().accept(this);
            pIastExpressionAssignmentStatement.getRightHandSide().accept(this);
            if (num < this.collectedFunctions.size()) {
                CSimpleDeclaration decl;
                CLeftHandSide left = pIastExpressionAssignmentStatement.getLeftHandSide();
                if (left instanceof CFieldReference) {
                    this.functionToFieldMatching.put((Object)((CFieldReference)left).getFieldName(), (Object)this.lastFunction);
                } else if (left instanceof CIdExpression && (decl = ((CIdExpression)left).getDeclaration()) instanceof CVariableDeclaration && ((CVariableDeclaration)decl).isGlobal()) {
                    this.functionToGlobalMatching.put((Object)((CIdExpression)left).getName(), (Object)this.lastFunction);
                }
            }
            return null;
        }
    }
}

