/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.function;

import java.util.Collection;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.model.AbstractCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.CFATerminationNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

@Options
public abstract class EdgeReplacer {
    @Option(secure=true, name="analysis.functionPointerEdgesForUnknownPointer", description="Create edge for skipping a function pointer call if its value is unknown.")
    protected boolean createUndefinedFunctionCall = true;
    private final MutableCFA cfa;
    private final LogManager logger;
    private int instrumentedFunctions;

    protected EdgeReplacer(MutableCFA pCfa, Configuration config, LogManager pLogger) throws InvalidConfigurationException {
        this.cfa = pCfa;
        this.logger = pLogger;
        config.inject((Object)this, EdgeReplacer.class);
        this.instrumentedFunctions = 0;
    }

    private CFANode newCFANode(AFunctionDeclaration pFunction) {
        assert (this.cfa != null);
        CFANode nextNode = new CFANode(pFunction);
        this.cfa.addNode(nextNode);
        return nextNode;
    }

    int getNumberOfInstrumenetedFunctions() {
        return this.instrumentedFunctions;
    }

    private void addConditionEdges(CExpression nameExp, CUnaryExpression amper, CFANode rootNode, CFANode thenNode, CFANode elseNode, FileLocation fileLocation) {
        CBinaryExpressionBuilder binExprBuilder = new CBinaryExpressionBuilder(this.cfa.getMachineModel(), this.logger);
        CBinaryExpression condition = binExprBuilder.buildBinaryExpressionUnchecked(nameExp, amper, CBinaryExpression.BinaryOperator.EQUALS);
        CAssumeEdge trueEdge = new CAssumeEdge(condition.toASTString(), fileLocation, rootNode, thenNode, condition, true);
        CFACreationUtils.addEdgeToCFA(trueEdge, this.logger);
        CAssumeEdge falseEdge = new CAssumeEdge("!(" + condition.toASTString() + ")", fileLocation, rootNode, elseNode, condition, false);
        CFACreationUtils.addEdgeToCFA(falseEdge, this.logger);
    }

    private CFunctionCall createRegularCall(CFunctionCall functionCall, CFunctionCallExpression newCallExpr) {
        if (functionCall instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement asgn = (CFunctionCallAssignmentStatement)functionCall;
            return new CFunctionCallAssignmentStatement(functionCall.getFileLocation(), asgn.getLeftHandSide(), newCallExpr);
        }
        if (functionCall instanceof CFunctionCallStatement) {
            return new CFunctionCallStatement(functionCall.getFileLocation(), newCallExpr);
        }
        throw new AssertionError((Object)"Unknown CFunctionCall subclass.");
    }

    protected boolean shouldBeInstrumented(CFunctionCall functionCall) {
        return true;
    }

    protected abstract CFunctionCallExpression createNewCallExpression(CFunctionCallExpression var1, CExpression var2, FunctionEntryNode var3, CIdExpression var4);

    protected abstract AbstractCFAEdge createSummaryEdge(CStatementEdge var1, CFANode var2, CFANode var3);

    public void instrument(CStatementEdge statement, Collection<CFunctionEntryNode> funcs, CExpression nameExp) {
        AbstractCFAEdge ae;
        CFunctionCall functionCall = (CFunctionCall)statement.getStatement();
        if (funcs.isEmpty() || !this.shouldBeInstrumented(functionCall)) {
            return;
        }
        ++this.instrumentedFunctions;
        CFunctionCallExpression oldCallExpr = functionCall.getFunctionCallExpression();
        FileLocation fileLocation = statement.getFileLocation();
        CFANode start = statement.getPredecessor();
        CFANode end = statement.getSuccessor();
        CFACreationUtils.removeEdgeFromNodes(statement);
        CFANode rootNode = start;
        for (FunctionEntryNode functionEntryNode : funcs) {
            CFANode thenNode = this.newCFANode(start.getFunction());
            CFANode elseNode = this.newCFANode(start.getFunction());
            CIdExpression func = new CIdExpression(nameExp.getFileLocation(), (CType)((Object)functionEntryNode.getFunctionDefinition().getType()), functionEntryNode.getFunctionName(), (CSimpleDeclaration)((Object)functionEntryNode.getFunctionDefinition()));
            CUnaryExpression amper = new CUnaryExpression(nameExp.getFileLocation(), new CPointerType(false, false, func.getExpressionType()), func, CUnaryExpression.UnaryOperator.AMPER);
            CFANode retNode = this.newCFANode(start.getFunction());
            this.addConditionEdges(nameExp, amper, rootNode, thenNode, elseNode, fileLocation);
            String pRawStatement = "pointer call(" + functionEntryNode.getFunctionName() + ") " + statement.getRawStatement();
            CFunctionCallExpression newCallExpr = this.createNewCallExpression(oldCallExpr, nameExp, functionEntryNode, func);
            CFunctionCall regularCall = this.createRegularCall(functionCall, newCallExpr);
            CStatementEdge callEdge = new CStatementEdge(pRawStatement, regularCall, fileLocation, thenNode, retNode);
            CFACreationUtils.addEdgeUnconditionallyToCFA(callEdge);
            BlankEdge be = new BlankEdge("skip " + statement, fileLocation, retNode, end, "skip");
            CFACreationUtils.addEdgeUnconditionallyToCFA(be);
            rootNode = elseNode;
        }
        if (this.createUndefinedFunctionCall) {
            ae = this.createSummaryEdge(statement, rootNode, end);
        } else {
            CFATerminationNode cFATerminationNode = new CFATerminationNode(rootNode.getFunction());
            this.cfa.addNode(cFATerminationNode);
            ae = new BlankEdge("blank pointer call", fileLocation, rootNode, cFATerminationNode, "blank pointer call");
        }
        CFACreationUtils.addEdgeUnconditionallyToCFA(ae);
    }
}

