/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.function;

import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;

public class ExpandFunctionPointerArrayAssignments {
    private final LogManager logger;

    public ExpandFunctionPointerArrayAssignments(LogManager pLogger) {
        this.logger = pLogger;
    }

    public void replaceFunctionPointerArrayAssignments(MutableCFA cfa) {
        CBinaryExpressionBuilder binBuilder = new CBinaryExpressionBuilder(cfa.getMachineModel(), this.logger);
        for (String function : cfa.getAllFunctionNames()) {
            block6: for (CFANode node : ImmutableList.copyOf(cfa.getFunctionNodes(function))) {
                switch (node.getNumLeavingEdges()) {
                    case 0: {
                        continue block6;
                    }
                    case 1: {
                        ExpandFunctionPointerArrayAssignments.handleEdge(node.getLeavingEdge(0), cfa, binBuilder);
                        continue block6;
                    }
                    case 2: {
                        continue block6;
                    }
                }
                throw new AssertionError((Object)"Too many leaving edges on CFANode");
            }
        }
    }

    private static void handleEdge(CFAEdge edge, MutableCFA cfa, CBinaryExpressionBuilder builder) {
        if (!(edge instanceof CStatementEdge)) {
            return;
        }
        CStatement stmt = ((CStatementEdge)edge).getStatement();
        if (!(stmt instanceof CExpressionAssignmentStatement)) {
            return;
        }
        CLeftHandSide lhs = ((CExpressionAssignmentStatement)stmt).getLeftHandSide();
        CExpression rhs = ((CExpressionAssignmentStatement)stmt).getRightHandSide();
        if (!ExpandFunctionPointerArrayAssignments.isFunctionPointerType(lhs.getExpressionType())) {
            return;
        }
        if (!(lhs instanceof CArraySubscriptExpression)) {
            return;
        }
        CArraySubscriptExpression array = (CArraySubscriptExpression)lhs;
        if (!(array.getSubscriptExpression() instanceof CIdExpression)) {
            return;
        }
        CExpression subscript = array.getSubscriptExpression();
        CType arrayType = array.getArrayExpression().getExpressionType().getCanonicalType();
        if (!(arrayType instanceof CArrayType) || !(((CArrayType)arrayType).getLength() instanceof CIntegerLiteralExpression)) {
            return;
        }
        long length = ((CIntegerLiteralExpression)((CArrayType)arrayType).getLength()).asLong();
        CFANode startNode = edge.getPredecessor();
        CFANode endNode = edge.getSuccessor();
        CFACreationUtils.removeEdgeFromNodes(edge);
        CFANode predecessor = startNode;
        for (long i = 0L; i < length; ++i) {
            CFANode trueNode = new CFANode(startNode.getFunction());
            CFANode falseNode = new CFANode(startNode.getFunction());
            cfa.addNode(trueNode);
            cfa.addNode(falseNode);
            CIntegerLiteralExpression index = new CIntegerLiteralExpression(subscript.getFileLocation(), CNumericTypes.INT, BigInteger.valueOf(i));
            CBinaryExpression assumeExp = builder.buildBinaryExpressionUnchecked(subscript, index, CBinaryExpression.BinaryOperator.EQUALS);
            CAssumeEdge trueEdge = new CAssumeEdge(edge.getRawStatement(), edge.getFileLocation(), predecessor, trueNode, assumeExp, true);
            CAssumeEdge falseEdge = new CAssumeEdge(edge.getRawStatement(), edge.getFileLocation(), predecessor, falseNode, assumeExp, false);
            CFACreationUtils.addEdgeUnconditionallyToCFA(trueEdge);
            CFACreationUtils.addEdgeUnconditionallyToCFA(falseEdge);
            CArraySubscriptExpression arrayAccess = new CArraySubscriptExpression(array.getFileLocation(), array.getExpressionType(), array.getArrayExpression(), index);
            CExpressionAssignmentStatement assignment = new CExpressionAssignmentStatement(stmt.getFileLocation(), arrayAccess, rhs);
            CStatementEdge assignmentEdge = new CStatementEdge(edge.getRawStatement(), assignment, edge.getFileLocation(), trueNode, endNode);
            CFACreationUtils.addEdgeUnconditionallyToCFA(assignmentEdge);
            predecessor = falseNode;
        }
    }

    private static boolean isFunctionPointerType(CType type) {
        if ((type = type.getCanonicalType()) instanceof CPointerType) {
            type = ((CPointerType)type).getType();
        }
        return type instanceof CFunctionType;
    }
}

