/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.function;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializers;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.exceptions.CParserException;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;

@Options(prefix="cfa.checkNullPointers")
public class NullPointerChecks {
    @Option(secure=true, description="Whether to have a single target node per function for all invalid null pointer dereferences or to have separate nodes for each dereference")
    private boolean singleTargetPerFunction = true;
    private final LogManager logger;

    public NullPointerChecks(LogManager pLogger, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = pLogger;
    }

    public void addNullPointerChecks(final MutableCFA cfa) throws CParserException {
        CBinaryExpressionBuilder binBuilder = new CBinaryExpressionBuilder(cfa.getMachineModel(), this.logger);
        for (final String functionName : cfa.getAllFunctionNames()) {
            Supplier<CFANode> targetNodeSupplier = new Supplier<CFANode>(){

                public CFANode get() {
                    AFunctionDeclaration function = cfa.getFunctionHead(functionName).getFunctionDefinition();
                    CFANode startNode = new CFANode(function);
                    CFANode endNode = new CFANode(function);
                    BlankEdge endEdge = new BlankEdge("null-deref", FileLocation.DUMMY, startNode, endNode, "null-deref");
                    CFACreationUtils.addEdgeUnconditionallyToCFA(endEdge);
                    BlankEdge loopEdge = new BlankEdge("", FileLocation.DUMMY, endNode, endNode, "");
                    CFACreationUtils.addEdgeUnconditionallyToCFA(loopEdge);
                    cfa.addNode(startNode);
                    cfa.addNode(endNode);
                    return startNode;
                }
            };
            if (this.singleTargetPerFunction) {
                targetNodeSupplier = Suppliers.memoize((Supplier)targetNodeSupplier);
            }
            block6: for (CFANode node : ImmutableList.copyOf(cfa.getFunctionNodes(functionName))) {
                switch (node.getNumLeavingEdges()) {
                    case 0: {
                        continue block6;
                    }
                    case 1: {
                        NullPointerChecks.handleEdge(node.getLeavingEdge(0), cfa, targetNodeSupplier, binBuilder);
                        continue block6;
                    }
                    case 2: {
                        if (node.getLeavingEdge(0) instanceof AssumeEdge && node.getLeavingEdge(1) instanceof AssumeEdge) {
                            NullPointerChecks.handleEdge(node.getLeavingEdge(0), cfa, targetNodeSupplier, binBuilder);
                            continue block6;
                        }
                        NullPointerChecks.handleEdge(node.getLeavingEdge(0), cfa, targetNodeSupplier, binBuilder);
                        NullPointerChecks.handleEdge(node.getLeavingEdge(1), cfa, targetNodeSupplier, binBuilder);
                        continue block6;
                    }
                }
                throw new AssertionError((Object)"Too many leaving edges on CFANode");
            }
        }
    }

    private static void handleEdge(CFAEdge edge, MutableCFA cfa, Supplier<CFANode> targetNode, CBinaryExpressionBuilder builder) throws CParserException {
        ContainsPointerVisitor visitor = new ContainsPointerVisitor();
        if (edge instanceof CReturnStatementEdge) {
            Optional<CExpression> returnExp = ((CReturnStatementEdge)edge).getExpression();
            if (returnExp.isPresent()) {
                returnExp.orElseThrow().accept(visitor);
            }
        } else if (edge instanceof CStatementEdge) {
            CStatement stmt = ((CStatementEdge)edge).getStatement();
            if (stmt instanceof CFunctionCallStatement) {
                ((CFunctionCallStatement)stmt).getFunctionCallExpression().accept(visitor);
            } else if (stmt instanceof CExpressionStatement) {
                ((CExpressionStatement)stmt).getExpression().accept(visitor);
            } else if (stmt instanceof CAssignment) {
                ((CAssignment)stmt).getRightHandSide().accept(visitor);
                ((CAssignment)stmt).getLeftHandSide().accept(visitor);
            }
        } else if (edge instanceof CDeclarationEdge) {
            CDeclaration decl = ((CDeclarationEdge)edge).getDeclaration();
            if (!decl.isGlobal() && decl instanceof CVariableDeclaration) {
                try {
                    for (CAssignment cAssignment : CInitializers.convertToAssignments((CVariableDeclaration)decl, edge)) {
                        cAssignment.getRightHandSide().accept(visitor);
                    }
                }
                catch (UnrecognizedCodeException e) {
                    throw new CParserException(e);
                }
            }
        } else if (edge instanceof CAssumeEdge) {
            ((CAssumeEdge)edge).getExpression().accept(visitor);
        }
        for (CExpression exp : Lists.reverse(visitor.dereferencedExpressions)) {
            edge = NullPointerChecks.insertNullPointerCheck(edge, exp, cfa, targetNode, builder);
        }
    }

    private static CFAEdge insertNullPointerCheck(CFAEdge edge, CExpression exp, MutableCFA cfa, Supplier<CFANode> targetNode, CBinaryExpressionBuilder binBuilder) {
        CFANode predecessor = edge.getPredecessor();
        CFANode successor = edge.getSuccessor();
        CFACreationUtils.removeEdgeFromNodes(edge);
        CFANode falseNode = new CFANode(predecessor.getFunction());
        for (CFAEdge otherEdge : CFAUtils.leavingEdges(predecessor).toList()) {
            CFAEdge newEdge = NullPointerChecks.createOldEdgeWithNewNodes(falseNode, otherEdge.getSuccessor(), otherEdge);
            CFACreationUtils.removeEdgeFromNodes(otherEdge);
            CFACreationUtils.addEdgeUnconditionallyToCFA(newEdge);
        }
        CBinaryExpression assumeExpression = binBuilder.buildBinaryExpressionUnchecked(exp, new CIntegerLiteralExpression(exp.getFileLocation(), CNumericTypes.INT, BigInteger.valueOf(0L)), CBinaryExpression.BinaryOperator.EQUALS);
        CAssumeEdge trueEdge = new CAssumeEdge(edge.getRawStatement(), edge.getFileLocation(), predecessor, (CFANode)targetNode.get(), assumeExpression, true);
        CAssumeEdge falseEdge = new CAssumeEdge(edge.getRawStatement(), edge.getFileLocation(), predecessor, falseNode, assumeExpression, false);
        CFACreationUtils.addEdgeUnconditionallyToCFA(trueEdge);
        CFACreationUtils.addEdgeUnconditionallyToCFA(falseEdge);
        CFAEdge newEdge = NullPointerChecks.createOldEdgeWithNewNodes(falseNode, successor, edge);
        CFACreationUtils.addEdgeUnconditionallyToCFA(newEdge);
        cfa.addNode(falseNode);
        return newEdge;
    }

    private static CFAEdge createOldEdgeWithNewNodes(CFANode predecessor, CFANode successor, CFAEdge edge) {
        switch (edge.getEdgeType()) {
            case AssumeEdge: {
                return new CAssumeEdge(edge.getRawStatement(), edge.getFileLocation(), predecessor, successor, ((CAssumeEdge)edge).getExpression(), ((CAssumeEdge)edge).getTruthAssumption(), ((CAssumeEdge)edge).isSwapped(), ((CAssumeEdge)edge).isArtificialIntermediate());
            }
            case ReturnStatementEdge: {
                return new CReturnStatementEdge(edge.getRawStatement(), ((CReturnStatementEdge)edge).getReturnStatement(), edge.getFileLocation(), predecessor, ((CReturnStatementEdge)edge).getSuccessor());
            }
            case StatementEdge: {
                return new CStatementEdge(edge.getRawStatement(), ((CStatementEdge)edge).getStatement(), edge.getFileLocation(), predecessor, successor);
            }
            case DeclarationEdge: {
                return new CDeclarationEdge(edge.getRawStatement(), edge.getFileLocation(), predecessor, successor, ((CDeclarationEdge)edge).getDeclaration());
            }
            case CallToReturnEdge: {
                throw new AssertionError();
            }
        }
        throw new AssertionError((Object)"more edge types valid than expected, more work to do here");
    }

    static class ContainsPointerVisitor
    extends DefaultCExpressionVisitor<Void, NoException>
    implements CRightHandSideVisitor<Void, NoException> {
        private final List<CExpression> dereferencedExpressions = new ArrayList<CExpression>();

        ContainsPointerVisitor() {
        }

        @Override
        public Void visit(CFunctionCallExpression pIastFunctionCallExpression) {
            pIastFunctionCallExpression.getFunctionNameExpression().accept(this);
            for (CExpression param : pIastFunctionCallExpression.getParameterExpressions()) {
                param.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CArraySubscriptExpression e) {
            e.getArrayExpression().accept(this);
            e.getSubscriptExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CCastExpression e) {
            return e.getOperand().accept(this);
        }

        @Override
        public Void visit(CComplexCastExpression e) {
            return e.getOperand().accept(this);
        }

        @Override
        public Void visit(CFieldReference e) {
            if (e.isPointerDereference()) {
                this.dereferencedExpressions.add(e.getFieldOwner());
            }
            return null;
        }

        @Override
        public Void visit(CUnaryExpression e) {
            if (e.getOperator() == CUnaryExpression.UnaryOperator.SIZEOF) {
                return null;
            }
            if (e.getOperator() == CUnaryExpression.UnaryOperator.AMPER && e.getOperand() instanceof CFieldReference && ((CFieldReference)e.getOperand()).isPointerDereference()) {
                return ((CFieldReference)e.getOperand()).getFieldOwner().accept(this);
            }
            return e.getOperand().accept(this);
        }

        @Override
        public Void visit(CPointerExpression e) {
            this.dereferencedExpressions.add(e.getOperand());
            e.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CBinaryExpression pIastbBinaryExpression) {
            pIastbBinaryExpression.getOperand1().accept(this);
            pIastbBinaryExpression.getOperand2().accept(this);
            return null;
        }

        @Override
        protected Void visitDefault(CExpression pExp) {
            return null;
        }
    }
}

