/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.function;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.postprocessing.function.CFunctionPointerResolver;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

public class TargetFunctionsProvider {
    private final MachineModel machine;
    private final LogManager logger;
    private final Collection<FunctionEntryNode> candidateFunctions;
    private final ImmutableSetMultimap<String, String> candidateFunctionsForField;
    private final ImmutableSetMultimap<String, String> globalsMatching;
    private final BiPredicate<CFunctionType, CFunctionType> matchingFunctionCall;

    public TargetFunctionsProvider(MachineModel pMachine, LogManager pLogger, Collection<CFunctionPointerResolver.FunctionSet> functionSets, Collection<FunctionEntryNode> candidateFunctions) {
        this(pMachine, pLogger, functionSets, candidateFunctions, (Multimap<String, String>)ImmutableSetMultimap.of(), (Multimap<String, String>)ImmutableSetMultimap.of());
    }

    public TargetFunctionsProvider(MachineModel pMachine, LogManager pLogger, Collection<CFunctionPointerResolver.FunctionSet> functionSets, Collection<FunctionEntryNode> candidateFunctions, Multimap<String, String> candidateFunctionsForField, Multimap<String, String> globalsMatching) {
        this.machine = pMachine;
        this.logger = pLogger;
        this.matchingFunctionCall = this.getFunctionSetPredicate(functionSets);
        this.candidateFunctions = candidateFunctions;
        this.candidateFunctionsForField = ImmutableSetMultimap.copyOf(candidateFunctionsForField);
        this.globalsMatching = ImmutableSetMultimap.copyOf(globalsMatching);
    }

    public Set<String> getMatchedFunc(CExpression expression) {
        if (expression instanceof CFieldReference) {
            String fieldName = ((CFieldReference)expression).getFieldName();
            return this.candidateFunctionsForField.get((Object)fieldName);
        }
        if (expression instanceof CIdExpression) {
            String variableName = ((CIdExpression)expression).getName();
            return this.globalsMatching.get((Object)variableName);
        }
        return ImmutableSet.of();
    }

    public List<CFunctionEntryNode> getFunctionSet(CFunctionType func) {
        return FluentIterable.from(this.candidateFunctions).filter(CFunctionEntryNode.class).filter(f -> this.matchingFunctionCall.test(func, f.getFunctionDefinition().getType())).toList();
    }

    private BiPredicate<CFunctionType, CFunctionType> getFunctionSetPredicate(Collection<CFunctionPointerResolver.FunctionSet> pFunctionSets) {
        ArrayList<BiPredicate<CFunctionType, CFunctionType>> predicates = new ArrayList<BiPredicate<CFunctionType, CFunctionType>>();
        EnumSet<CFunctionPointerResolver.FunctionSet> functionSets = EnumSet.copyOf(pFunctionSets);
        if (functionSets.contains((Object)CFunctionPointerResolver.FunctionSet.EQ_PARAM_TYPES) || functionSets.contains((Object)CFunctionPointerResolver.FunctionSet.EQ_PARAM_SIZES)) {
            functionSets.add(CFunctionPointerResolver.FunctionSet.EQ_PARAM_COUNT);
        }
        block8: for (CFunctionPointerResolver.FunctionSet functionSet : functionSets) {
            switch (functionSet) {
                case ALL: {
                    continue block8;
                }
                case EQ_PARAM_COUNT: {
                    predicates.add(this::checkParamCount);
                    continue block8;
                }
                case EQ_PARAM_SIZES: {
                    predicates.add(this::checkReturnAndParamSizes);
                    continue block8;
                }
                case EQ_PARAM_TYPES: {
                    predicates.add(this::checkReturnAndParamTypes);
                    continue block8;
                }
                case RETURN_VALUE: {
                    predicates.add(this::checkReturnValue);
                    continue block8;
                }
                case USED_IN_CODE: {
                    continue block8;
                }
            }
            throw new AssertionError();
        }
        return predicates.stream().reduce((a, b) -> true, BiPredicate::and);
    }

    private boolean checkParamCount(CFunctionType func, CFunctionType functionType) {
        int declaredParameters = functionType.getParameters().size();
        int actualParameters = func.getParameters().size();
        if (actualParameters < declaredParameters) {
            this.logger.log(Level.FINEST, new Object[]{"Function call", func.getName(), "does not match function", functionType, "because there are not enough actual parameters."});
            return false;
        }
        if (!functionType.takesVarArgs() && actualParameters > declaredParameters) {
            this.logger.log(Level.FINEST, new Object[]{"Function call", func.getName(), "does not match function", functionType, "because there are too many actual parameters."});
            return false;
        }
        return true;
    }

    private boolean checkReturnAndParamSizes(CFunctionType func, CFunctionType functionType) {
        CType declRet = functionType.getReturnType();
        if (!this.machine.getSizeof(declRet).equals(this.machine.getSizeof(func.getReturnType()))) {
            this.logger.log(Level.FINEST, new Object[]{"Function call", func.getName(), "with type", func.getReturnType(), "does not match function", functionType, "with return type", declRet, "because of return types with different sizes."});
            return false;
        }
        List<CType> declParams = functionType.getParameters();
        for (int i = 0; i < declParams.size(); ++i) {
            CType dt = declParams.get(i);
            CType et = func.getParameters().get(i);
            if (this.machine.getSizeof(dt).equals(this.machine.getSizeof(et))) continue;
            this.logger.log(Level.FINEST, new Object[]{"Function call", func.getName(), "does not match function", functionType, "because actual parameter", i, "has type", et, "instead of", dt, "(differing sizes)."});
            return false;
        }
        return true;
    }

    private boolean checkReturnAndParamTypes(CFunctionType func, CFunctionType functionType) {
        CType declRet = functionType.getReturnType();
        if (!this.isCompatibleType(declRet, func.getReturnType())) {
            this.logger.log(Level.FINEST, new Object[]{"Function call", func.getName(), "with type", func.getReturnType(), "does not match function", functionType, "with return type", declRet});
            return false;
        }
        List<CType> declParams = functionType.getParameters();
        for (int i = 0; i < declParams.size(); ++i) {
            CType et;
            CType dt = declParams.get(i);
            if (this.isCompatibleType(dt, et = func.getParameters().get(i))) continue;
            this.logger.log(Level.FINEST, new Object[]{"Function call", func.getName(), "does not match function", functionType, "because actual parameter", i, "has type", et, "instead of", dt});
            return false;
        }
        return true;
    }

    private boolean checkReturnValue(CFunctionType func, CFunctionType functionType) {
        CType declRet = functionType.getReturnType();
        if (!this.isCompatibleType(declRet, func.getReturnType())) {
            this.logger.log(Level.FINEST, new Object[]{"Function call", func.getName(), "with type", func.getReturnType(), "does not match function", functionType, "with return type", declRet});
            return false;
        }
        return true;
    }

    private boolean isCompatibleType(CType pDeclaredType, CType pActualType) {
        CSimpleType declaredSimpleType;
        CBasicType declaredBasicType;
        CPointerType actualPointerType;
        CSimpleType actualSimpleType;
        CBasicType actualBasicType;
        CPointerType declaredPointerType;
        CType actualType;
        CType declaredType = pDeclaredType.getCanonicalType();
        if (declaredType.equals(actualType = pActualType.getCanonicalType())) {
            return true;
        }
        if (declaredType instanceof CSimpleType && actualType instanceof CSimpleType) {
            return true;
        }
        if (declaredType instanceof CPointerType && (declaredPointerType = (CPointerType)declaredType).getType() == CVoidType.VOID && (actualType instanceof CSimpleType ? (actualBasicType = (actualSimpleType = (CSimpleType)actualType).getType()).isIntegerType() : actualType instanceof CPointerType)) {
            return true;
        }
        if (actualType instanceof CPointerType && (actualPointerType = (CPointerType)actualType).getType() == CVoidType.VOID && (declaredType instanceof CSimpleType ? (declaredBasicType = (declaredSimpleType = (CSimpleType)declaredType).getType()).isIntegerType() : declaredType instanceof CPointerType)) {
            return true;
        }
        if (declaredType instanceof CPointerType && actualType instanceof CPointerType) {
            declaredPointerType = (CPointerType)declaredType;
            CPointerType actualPointerType2 = (CPointerType)actualType;
            if (this.isCompatibleType(declaredPointerType.getType(), actualPointerType2.getType())) {
                return true;
            }
        }
        return false;
    }
}

