/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.function;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CThreadOperationStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFATraversal;

@Options
public class ThreadCreateTransformer {
    @Option(secure=true, name="cfa.threads.threadCreate", description="A name of thread_create function")
    private String threadCreate = "pthread_create";
    @Option(secure=true, name="cfa.threads.threadSelfCreate", description="A name of thread_create_N function")
    private String threadCreateN = "pthread_create_N";
    @Option(secure=true, name="cfa.threads.threadJoin", description="A name of thread_join function")
    private String threadJoin = "pthread_join";
    @Option(secure=true, name="cfa.threads.threadSelfJoin", description="A name of thread_join_N function")
    private String threadJoinN = "pthread_join_N";
    private final LogManager logger;
    private int tmpVarCounter = 0;

    public ThreadCreateTransformer(LogManager log, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.logger = log;
    }

    public void transform(CFA cfa) {
        CFunctionCallExpression fCall;
        CFAEdge edge;
        ThreadFinder threadVisitor = new ThreadFinder();
        for (FunctionEntryNode functionEntryNode : cfa.getAllFunctionHeads()) {
            CFATraversal.dfs().traverseOnce(functionEntryNode, threadVisitor);
        }
        for (Map.Entry entry : threadVisitor.threadCreates.entrySet()) {
            edge = (CFAEdge)entry.getKey();
            fCall = (CFunctionCallExpression)entry.getValue();
            String fName = fCall.getFunctionNameExpression().toString();
            List<CExpression> args = fCall.getParameterExpressions();
            if (args.size() != 4) {
                throw new UnsupportedOperationException("More arguments expected: " + fCall);
            }
            CIdExpression varName = this.getThreadVariableName(fCall);
            CExpression calledFunction = args.get(2);
            CIdExpression functionNameExpression = this.getFunctionName(calledFunction);
            ArrayList functionParameters = Lists.newArrayList((Object[])new CExpression[]{args.get(3)});
            String newThreadName = functionNameExpression.getName();
            CFunctionEntryNode entryNode = (CFunctionEntryNode)cfa.getFunctionHead(newThreadName);
            if (entryNode == null) {
                throw new UnsupportedOperationException("Can not find the body of function " + newThreadName + "(), full line: " + edge);
            }
            CFunctionDeclaration functionDeclaration = entryNode.getFunctionDefinition();
            FileLocation pFileLocation = edge.getFileLocation();
            CFunctionCallExpression pFunctionCallExpression = new CFunctionCallExpression(pFileLocation, functionDeclaration.getType().getReturnType(), functionNameExpression, functionParameters, functionDeclaration);
            boolean isSelfParallel = !fName.equals(this.threadCreate);
            CThreadOperationStatement.CThreadCreateStatement pFunctionCall = new CThreadOperationStatement.CThreadCreateStatement(pFileLocation, pFunctionCallExpression, isSelfParallel, varName.getName());
            if (edge instanceof CStatementEdge) {
                CStatement stmnt = ((CStatementEdge)edge).getStatement();
                if (stmnt instanceof CFunctionCallAssignmentStatement) {
                    String pRawStatement = edge.getRawStatement();
                    CFANode pPredecessor = edge.getPredecessor();
                    CFANode pSuccessor = edge.getSuccessor();
                    CFANode firstNode = new CFANode(pPredecessor.getFunction());
                    CFANode secondNode = new CFANode(pPredecessor.getFunction());
                    ((MutableCFA)cfa).addNode(firstNode);
                    ((MutableCFA)cfa).addNode(secondNode);
                    CFACreationUtils.removeEdgeFromNodes(edge);
                    CStatement assign = this.prepareRandomAssignment((CFunctionCallAssignmentStatement)stmnt);
                    CStatementEdge randAssign = new CStatementEdge(pRawStatement, assign, pFileLocation, pPredecessor, firstNode);
                    CExpression assumption = this.prepareAssumption((CFunctionCallAssignmentStatement)stmnt, cfa);
                    CAssumeEdge trueEdge = new CAssumeEdge(pRawStatement, pFileLocation, firstNode, secondNode, assumption, true);
                    CAssumeEdge falseEdge = new CAssumeEdge(pRawStatement, pFileLocation, firstNode, pSuccessor, assumption, false);
                    CStatementEdge callEdge = new CStatementEdge(pRawStatement, pFunctionCall, pFileLocation, secondNode, pSuccessor);
                    CFACreationUtils.addEdgeUnconditionallyToCFA(callEdge);
                    CFACreationUtils.addEdgeUnconditionallyToCFA(randAssign);
                    CFACreationUtils.addEdgeUnconditionallyToCFA(trueEdge);
                    CFACreationUtils.addEdgeUnconditionallyToCFA(falseEdge);
                    this.logger.log(Level.FINE, new Object[]{"Replace " + edge + " with " + callEdge});
                    continue;
                }
                this.replaceEdgeWith(edge, pFunctionCall);
                continue;
            }
            this.replaceEdgeWith(edge, pFunctionCall);
        }
        for (Map.Entry entry : threadVisitor.threadJoins.entrySet()) {
            edge = (CFAEdge)entry.getKey();
            fCall = (CFunctionCallExpression)entry.getValue();
            CIdExpression varName = this.getThreadVariableName(fCall);
            FileLocation pFileLocation = edge.getFileLocation();
            String fName = fCall.getFunctionNameExpression().toString();
            boolean isSelfParallel = !fName.equals(this.threadJoin);
            CThreadOperationStatement.CThreadJoinStatement pFunctionCall = new CThreadOperationStatement.CThreadJoinStatement(pFileLocation, fCall, isSelfParallel, varName.getName());
            this.replaceEdgeWith(edge, pFunctionCall);
        }
    }

    private void replaceEdgeWith(CFAEdge edge, CFunctionCallStatement fCall) {
        CFANode pPredecessor = edge.getPredecessor();
        CFANode pSuccessor = edge.getSuccessor();
        FileLocation pFileLocation = edge.getFileLocation();
        String pRawStatement = edge.getRawStatement();
        CFACreationUtils.removeEdgeFromNodes(edge);
        CStatementEdge callEdge = new CStatementEdge(pRawStatement, fCall, pFileLocation, pPredecessor, pSuccessor);
        this.logger.log(Level.FINE, new Object[]{"Replace " + edge + " with " + callEdge});
        CFACreationUtils.addEdgeUnconditionallyToCFA(callEdge);
    }

    private CStatement prepareRandomAssignment(CFunctionCallAssignmentStatement stmnt) {
        FileLocation pFileLocation = stmnt.getFileLocation();
        CFunctionCallExpression fCall = stmnt.getFunctionCallExpression();
        CLeftHandSide left = stmnt.getLeftHandSide();
        String tmpName = "CPA_TMP_" + this.tmpVarCounter++;
        CType retType = fCall.getDeclaration().getType().getReturnType();
        CVariableDeclaration decl = new CVariableDeclaration(pFileLocation, false, CStorageClass.AUTO, retType, tmpName, tmpName, tmpName, null);
        CIdExpression tmp = new CIdExpression(pFileLocation, decl);
        return new CExpressionAssignmentStatement(pFileLocation, left, tmp);
    }

    private CExpression prepareAssumption(CFunctionCallAssignmentStatement stmnt, CFA cfa) {
        CLeftHandSide left = stmnt.getLeftHandSide();
        CBinaryExpressionBuilder bBuilder = new CBinaryExpressionBuilder(cfa.getMachineModel(), this.logger);
        try {
            return bBuilder.buildBinaryExpression(left, CIntegerLiteralExpression.ZERO, CBinaryExpression.BinaryOperator.EQUALS);
        }
        catch (UnrecognizedCodeException e) {
            throw new UnsupportedOperationException("Cannot proceed: ", e);
        }
    }

    private CIdExpression getFunctionName(CExpression fName) {
        if (fName instanceof CIdExpression) {
            return (CIdExpression)fName;
        }
        if (fName instanceof CUnaryExpression) {
            return this.getFunctionName(((CUnaryExpression)fName).getOperand());
        }
        if (fName instanceof CCastExpression) {
            return this.getFunctionName(((CCastExpression)fName).getOperand());
        }
        throw new UnsupportedOperationException("Unsupported expression in pthread_create: " + fName);
    }

    private CIdExpression getThreadVariableName(CFunctionCallExpression fCall) {
        CExpression var = fCall.getParameterExpressions().get(0);
        while (!(var instanceof CIdExpression)) {
            if (var instanceof CUnaryExpression) {
                var = ((CUnaryExpression)var).getOperand();
                continue;
            }
            if (var instanceof CCastExpression) {
                var = ((CCastExpression)var).getOperand();
                continue;
            }
            throw new UnsupportedOperationException("Unsupported parameter expression " + var);
        }
        return (CIdExpression)var;
    }

    private class ThreadFinder
    implements CFATraversal.CFAVisitor {
        Map<CFAEdge, CFunctionCallExpression> threadCreates = new HashMap<CFAEdge, CFunctionCallExpression>();
        Map<CFAEdge, CFunctionCallExpression> threadJoins = new HashMap<CFAEdge, CFunctionCallExpression>();

        private ThreadFinder() {
        }

        @Override
        public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
            if (pEdge instanceof CStatementEdge) {
                CStatement statement = ((CStatementEdge)pEdge).getStatement();
                if (statement instanceof CAssignment) {
                    CRightHandSide rhs = ((CAssignment)statement).getRightHandSide();
                    if (rhs instanceof CFunctionCallExpression) {
                        CFunctionCallExpression exp = (CFunctionCallExpression)rhs;
                        this.checkFunctionExpression(pEdge, exp);
                    }
                } else if (statement instanceof CFunctionCallStatement) {
                    CFunctionCallExpression exp = ((CFunctionCallStatement)statement).getFunctionCallExpression();
                    this.checkFunctionExpression(pEdge, exp);
                }
            }
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        @Override
        public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
            return CFATraversal.TraversalProcess.CONTINUE;
        }

        private void checkFunctionExpression(CFAEdge edge, CFunctionCallExpression exp) {
            String fName = exp.getFunctionNameExpression().toString();
            if (fName.equals(ThreadCreateTransformer.this.threadCreate) || fName.equals(ThreadCreateTransformer.this.threadCreateN)) {
                this.threadCreates.put(edge, exp);
            } else if (fName.equals(ThreadCreateTransformer.this.threadJoin) || fName.equals(ThreadCreateTransformer.this.threadJoinN)) {
                this.threadJoins.put(edge, exp);
            }
        }
    }
}

