/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.global;

import com.google.common.base.Preconditions;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.SortedMap;
import java.util.TreeMap;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.FunctionCallCollector;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.FunctionCallUnwinder;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.FunctionCloner;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.Pair;

@Options(prefix="cfa.cfaCloner")
public class CFACloner {
    public static final String SEPARATOR = "__cloned_function__";
    private final CFA cfa;
    @Option(secure=true, description="how often do we clone a function?")
    private int numberOfCopies = 5;

    public CFACloner(CFA pCfa, Configuration pConfig) throws InvalidConfigurationException {
        this.cfa = pCfa;
        pConfig.inject((Object)this);
    }

    public MutableCFA execute() {
        assert (this.cfa.getLanguage() == Language.C);
        TreeMap<String, FunctionEntryNode> functions = new TreeMap<String, FunctionEntryNode>((SortedMap<String, FunctionEntryNode>)this.cfa.getAllFunctions());
        TreeMultimap nodes = TreeMultimap.create();
        for (String function : this.cfa.getAllFunctionNames()) {
            if (this.cfa instanceof MutableCFA) {
                nodes.putAll((Object)function, ((MutableCFA)this.cfa).getFunctionNodes(function));
                continue;
            }
            nodes.putAll((Object)function, CFATraversal.dfs().collectNodesReachableFrom(this.cfa.getFunctionHead(function)));
        }
        for (String functionName : this.cfa.getAllFunctionNames()) {
            if (this.cfa.getMainFunction().getFunctionName().equals(functionName)) continue;
            FunctionEntryNode entryNode = this.cfa.getFunctionHead(functionName);
            for (int i = 1; i <= this.numberOfCopies; ++i) {
                String newFunctionName = CFACloner.getFunctionName(functionName, i);
                Preconditions.checkArgument((!this.cfa.getAllFunctionNames().contains(newFunctionName) ? 1 : 0) != 0);
                Pair<FunctionEntryNode, Collection<CFANode>> newFunction = FunctionCloner.cloneCFA(entryNode, newFunctionName);
                functions.put(newFunctionName, newFunction.getFirst());
                nodes.putAll((Object)newFunctionName, (Iterable)newFunction.getSecond());
                Preconditions.checkArgument((boolean)functions.containsKey(newFunctionName), (String)"function %s not available", (Object)newFunctionName);
                FunctionCallCollector visitor = new FunctionCallCollector();
                CFATraversal.dfs().traverseOnce((CFANode)functions.get(newFunctionName), visitor);
                Collection<AStatementEdge> functionCalls = visitor.getFunctionCalls();
                for (AStatementEdge statementEdge : functionCalls) {
                    if (!FunctionCallUnwinder.isFunctionCall(statementEdge, functions.keySet())) continue;
                    String calledFunctionName = FunctionCallUnwinder.getNameOfFunction(statementEdge);
                    String newCalledFunctionName = CFACloner.getFunctionName(calledFunctionName, i);
                    FunctionCallUnwinder.replaceFunctionCall(statementEdge, newCalledFunctionName);
                }
            }
        }
        return new MutableCFA(this.cfa.getMachineModel(), functions, (TreeMultimap<String, CFANode>)nodes, this.cfa.getMainFunction(), this.cfa.getFileNames(), this.cfa.getLanguage());
    }

    public static String getFunctionName(String function, int index) {
        return function + SEPARATOR + index;
    }

    public static String extractFunctionName(String function) {
        int index = function.indexOf(SEPARATOR);
        return index == -1 ? function : function.substring(0, index);
    }
}

