/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.postprocessing.global;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.cfa.CFACreationUtils;
import org.sosy_lab.cpachecker.cfa.FunctionCallCollector;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.MutableCFA;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CStatementEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.FunctionCloner;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.Pair;

@Options(prefix="cfa.functionCalls")
public class FunctionCallUnwinder {
    @Option(secure=true, description="how often can a function appear in the callstack as a clone of the original function?")
    private int recursionDepth = 5;
    private static final String RECURSION_SEPARATOR = "__recursive_call__";
    private final MutableCFA cfa;

    public FunctionCallUnwinder(MutableCFA pCfa, Configuration config) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.cfa = pCfa;
        if (this.cfa.getLanguage() != Language.C) {
            throw new InvalidConfigurationException("Function-call unwinding is only supported for C code.");
        }
    }

    public MutableCFA unwindRecursion() {
        assert (this.cfa.getLanguage() == Language.C);
        TreeMap<String, FunctionEntryNode> functions = new TreeMap<String, FunctionEntryNode>((SortedMap<String, FunctionEntryNode>)this.cfa.getAllFunctions());
        TreeMultimap nodes = TreeMultimap.create();
        for (String function : this.cfa.getAllFunctionNames()) {
            nodes.putAll((Object)function, this.cfa.getFunctionNodes(function));
        }
        HashMultimap reverseCallGraph = HashMultimap.create();
        HashSet<String> finished = new HashSet<String>();
        ArrayDeque<String> waitlist = new ArrayDeque<String>();
        waitlist.add(this.cfa.getMainFunction().getFunctionName());
        while (!waitlist.isEmpty()) {
            String functionname = (String)waitlist.pop();
            if (!finished.add(functionname)) continue;
            Preconditions.checkArgument((boolean)functions.containsKey(functionname), (String)"function %s not available", (Object)functionname);
            FunctionEntryNode entryNode = (FunctionEntryNode)functions.get(functionname);
            FunctionCallCollector visitor = new FunctionCallCollector();
            CFATraversal.dfs().traverseOnce(entryNode, visitor);
            Collection<AStatementEdge> functionCalls = visitor.getFunctionCalls();
            for (AStatementEdge statementEdge : functionCalls) {
                String calledFunction;
                if (!FunctionCallUnwinder.isFunctionCall(statementEdge, functions.keySet())) continue;
                String newFunctionname = calledFunction = FunctionCallUnwinder.getNameOfFunction(statementEdge);
                if (!this.isCallStackSizeReached(calledFunction, (Multimap<String, String>)reverseCallGraph)) {
                    while (FunctionCallUnwinder.isFatherOf(functionname, newFunctionname, (Multimap<String, String>)reverseCallGraph)) {
                        newFunctionname = this.incrementFunctionname(newFunctionname);
                    }
                    if (!calledFunction.equals(newFunctionname)) {
                        if (!functions.containsKey(newFunctionname)) {
                            FunctionCallUnwinder.cloneFunction(calledFunction, newFunctionname, functions, (SortedSetMultimap<String, CFANode>)nodes);
                        }
                        FunctionCallUnwinder.replaceFunctionCall(statementEdge, newFunctionname);
                    }
                }
                waitlist.add(newFunctionname);
                reverseCallGraph.put((Object)newFunctionname, (Object)functionname);
            }
        }
        return new MutableCFA(this.cfa.getMachineModel(), functions, (TreeMultimap<String, CFANode>)nodes, this.cfa.getMainFunction(), this.cfa.getFileNames(), this.cfa.getLanguage());
    }

    static void replaceFunctionCall(AStatementEdge functionCallEdge, String newFunctionName) {
        CFANode pred = functionCallEdge.getPredecessor();
        CFANode succ = functionCallEdge.getSuccessor();
        AFunctionCall call = (AFunctionCall)functionCallEdge.getStatement();
        if (!(call instanceof CFunctionCall)) {
            throw new AssertionError((Object)("unsupported edge: " + functionCallEdge));
        }
        CFunctionDeclaration declaration = ((CFunctionCall)call).getFunctionCallExpression().getDeclaration();
        Preconditions.checkNotNull((Object)declaration);
        String oldFunctionName = declaration.getQualifiedName();
        FunctionCloner fc = new FunctionCloner(oldFunctionName, newFunctionName, true);
        AStatementEdge newEdge = fc.cloneEdge(functionCallEdge, pred, succ);
        CFACreationUtils.removeEdgeFromNodes(functionCallEdge);
        CFACreationUtils.addEdgeUnconditionallyToCFA(newEdge);
    }

    private static void cloneFunction(String oldFunctionname, String newFunctionname, Map<String, FunctionEntryNode> functions, SortedSetMultimap<String, CFANode> nodes) {
        Preconditions.checkArgument((!functions.containsKey(newFunctionname) ? 1 : 0) != 0, (Object)"function exists, cloning is not allowed.");
        FunctionEntryNode entryNode = functions.get(oldFunctionname);
        Pair<FunctionEntryNode, Collection<CFANode>> newFunction = FunctionCloner.cloneCFA(entryNode, newFunctionname);
        functions.put(newFunctionname, newFunction.getFirst());
        nodes.putAll((Object)newFunctionname, (Iterable)newFunction.getSecond());
    }

    static @Nullable String getNameOfFunction(AStatementEdge edge) {
        if (!(edge instanceof CStatementEdge)) {
            return null;
        }
        CStatement statement = ((CStatementEdge)edge).getStatement();
        if (!(statement instanceof CFunctionCall)) {
            return null;
        }
        CFunctionDeclaration declaration = ((CFunctionCall)statement).getFunctionCallExpression().getDeclaration();
        if (declaration == null) {
            return null;
        }
        return declaration.getQualifiedName();
    }

    static boolean isFunctionCall(AStatementEdge edge, Collection<String> cfaFunctions) {
        String functionname = FunctionCallUnwinder.getNameOfFunction(edge);
        return functionname != null && cfaFunctions.contains(functionname);
    }

    private static boolean isFatherOf(String child, String possibleFather, Multimap<String, String> reverseGraph) {
        HashSet<String> finished = new HashSet<String>();
        ArrayDeque<String> waitlist = new ArrayDeque<String>();
        waitlist.add(child);
        while (!waitlist.isEmpty()) {
            String current = (String)waitlist.pop();
            if (!finished.add(current)) continue;
            if (current.equals(possibleFather)) {
                return true;
            }
            waitlist.addAll(reverseGraph.get((Object)current));
        }
        return false;
    }

    private boolean isCallStackSizeReached(String calledFunction, Multimap<String, String> reverseGraph) {
        Set functions = reverseGraph.keySet();
        int maxDepth = 0;
        for (String function : functions) {
            int index;
            if (!function.startsWith(calledFunction) || (index = function.indexOf(RECURSION_SEPARATOR)) == -1) continue;
            int depth = Integer.parseInt(function.substring(index + RECURSION_SEPARATOR.length()));
            maxDepth = Math.max(maxDepth, depth);
        }
        return maxDepth >= this.recursionDepth;
    }

    private String incrementFunctionname(String function) {
        int i = function.indexOf(RECURSION_SEPARATOR);
        int index = 1;
        if (i != -1) {
            index = Integer.parseInt(function.substring(i + RECURSION_SEPARATOR.length())) + 1;
            function = function.substring(0, i);
        }
        return function + RECURSION_SEPARATOR + index;
    }
}

