/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.simplification;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LogManagerWithoutDuplicates;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.cpa.value.AbstractExpressionValueVisitor;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.cpa.value.type.Value;
import org.sosy_lab.cpachecker.exceptions.NoException;

public class ExpressionSimplificationVisitor
extends DefaultCExpressionVisitor<CExpression, NoException> {
    private final MachineModel machineModel;
    private final LogManagerWithoutDuplicates logger;

    public ExpressionSimplificationVisitor(MachineModel mm, LogManagerWithoutDuplicates pLogger) {
        this.machineModel = mm;
        this.logger = pLogger;
    }

    protected CExpression recursive(CExpression expr) {
        return expr.accept(this);
    }

    private @Nullable NumericValue getValue(CExpression expr) {
        if (expr instanceof CIntegerLiteralExpression) {
            return new NumericValue(((CIntegerLiteralExpression)expr).getValue());
        }
        if (expr instanceof CCharLiteralExpression) {
            return new NumericValue((int)((CCharLiteralExpression)expr).getCharacter());
        }
        if (expr instanceof CFloatLiteralExpression) {
            return new NumericValue(((CFloatLiteralExpression)expr).getValue());
        }
        return null;
    }

    private CExpression convertExplicitValueToExpression(CExpression expr, Value value) {
        NumericValue numericResult = value.asNumericValue();
        CType type = expr.getExpressionType().getCanonicalType();
        if (numericResult != null && type instanceof CSimpleType) {
            CBasicType basicType = ((CSimpleType)type).getType();
            if (basicType.isIntegerType()) {
                return new CIntegerLiteralExpression(expr.getFileLocation(), type, numericResult.bigInteger());
            }
            if (basicType.isFloatingPointType()) {
                try {
                    return new CFloatLiteralExpression(expr.getFileLocation(), type, numericResult.bigDecimalValue());
                }
                catch (NumberFormatException nfe) {
                    this.logger.logf(Level.FINE, "Cannot simplify expression to numeric value %s, keeping original expression %s instead", new Object[]{numericResult, expr.toASTString()});
                    return expr;
                }
            }
        }
        if (numericResult != null) {
            this.logger.logf(Level.FINE, "Can not handle result of expression %s", new Object[]{numericResult.toString()});
        } else {
            this.logger.logf(Level.FINE, "Can not handle result of expression, numericResult is null.", new Object[0]);
        }
        return expr;
    }

    @Override
    protected CExpression visitDefault(CExpression expr) {
        return expr;
    }

    @Override
    public CExpression visit(CBinaryExpression expr) {
        CBinaryExpression.BinaryOperator binaryOperator = expr.getOperator();
        CExpression op1 = this.recursive(expr.getOperand1());
        NumericValue value1 = this.getValue(op1);
        CExpression op2 = this.recursive(expr.getOperand2());
        NumericValue value2 = this.getValue(op2);
        if (op1.equals(op2) && op1 instanceof CIdExpression && CTypes.isIntegerType(op1.getExpressionType())) {
            switch (binaryOperator) {
                case EQUALS: 
                case GREATER_EQUAL: 
                case LESS_EQUAL: {
                    return CIntegerLiteralExpression.ONE;
                }
                case NOT_EQUALS: 
                case GREATER_THAN: 
                case LESS_THAN: {
                    return CIntegerLiteralExpression.ZERO;
                }
            }
        }
        if (value1 == null || value2 == null) {
            CBinaryExpression newExpr;
            if (op1 == expr.getOperand1() && op2 == expr.getOperand2()) {
                newExpr = expr;
            } else {
                CBinaryExpressionBuilder binExprBuilder = new CBinaryExpressionBuilder(this.machineModel, (LogManager)this.logger);
                switch (binaryOperator) {
                    case BINARY_AND: {
                        if (value1 != null && value1.bigInteger().equals(BigInteger.ZERO)) {
                            return op1;
                        }
                        if (value2 == null || !value2.bigInteger().equals(BigInteger.ZERO)) break;
                        return op2;
                    }
                    case BINARY_OR: {
                        if (value1 != null && value1.bigInteger().equals(BigInteger.ZERO)) {
                            return op2;
                        }
                        if (value2 == null || !value2.bigInteger().equals(BigInteger.ZERO)) break;
                        return op1;
                    }
                }
                newExpr = binExprBuilder.buildBinaryExpressionUnchecked(op1, op2, binaryOperator);
            }
            return newExpr;
        }
        Value result = AbstractExpressionValueVisitor.calculateBinaryOperation(value1, value2, expr, this.machineModel, this.logger);
        return this.convertExplicitValueToExpression(expr, result);
    }

    @Override
    public CExpression visit(CCastExpression expr) {
        CExpression op = this.recursive(expr.getOperand());
        NumericValue value = this.getValue(op);
        if (value == null) {
            CCastExpression newExpr = op == expr.getOperand() ? expr : new CCastExpression(expr.getFileLocation(), expr.getExpressionType(), op);
            return newExpr;
        }
        Value castedValue = AbstractExpressionValueVisitor.castCValue(value, expr.getExpressionType(), this.machineModel, this.logger, expr.getFileLocation());
        return this.convertExplicitValueToExpression(expr, castedValue);
    }

    @Override
    public CExpression visit(CTypeIdExpression expr) {
        CTypeIdExpression.TypeIdOperator idOperator = expr.getOperator();
        CType innerType = expr.getType();
        switch (idOperator) {
            case SIZEOF: {
                BigInteger size = this.machineModel.getSizeof(innerType);
                return new CIntegerLiteralExpression(expr.getFileLocation(), expr.getExpressionType(), size);
            }
            case ALIGNOF: {
                int alignment = this.machineModel.getAlignof(innerType);
                return new CIntegerLiteralExpression(expr.getFileLocation(), expr.getExpressionType(), BigInteger.valueOf(alignment));
            }
        }
        return this.visitDefault(expr);
    }

    @Override
    public CExpression visit(CUnaryExpression expr) {
        CUnaryExpression.UnaryOperator unaryOperator = expr.getOperator();
        FileLocation loc = expr.getFileLocation();
        CType exprType = expr.getExpressionType();
        CExpression operand = expr.getOperand();
        CType operandType = operand.getExpressionType();
        if (unaryOperator == CUnaryExpression.UnaryOperator.SIZEOF) {
            return new CIntegerLiteralExpression(loc, exprType, this.machineModel.getSizeof(operandType));
        }
        if (unaryOperator == CUnaryExpression.UnaryOperator.ALIGNOF) {
            return new CIntegerLiteralExpression(loc, exprType, BigInteger.valueOf(this.machineModel.getAlignof(operandType)));
        }
        CExpression op = this.recursive(operand);
        assert (op.getExpressionType().equals(operandType)) : "simplification should not change type";
        NumericValue value = this.getValue(op);
        if (value != null && operandType instanceof CSimpleType) {
            if (unaryOperator == CUnaryExpression.UnaryOperator.MINUS) {
                NumericValue negatedValue = (NumericValue)AbstractExpressionValueVisitor.castCValue(value.negate(), exprType, this.machineModel, this.logger, loc);
                switch (((CSimpleType)operandType).getType()) {
                    case BOOL: 
                    case CHAR: 
                    case INT: {
                        return new CIntegerLiteralExpression(loc, exprType, negatedValue.bigInteger());
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        double v = negatedValue.doubleValue();
                        if (v == 0.0 && 1.0 / v < 0.0) {
                            return new CUnaryExpression(loc, exprType, op, unaryOperator);
                        }
                        return new CFloatLiteralExpression(loc, exprType, BigDecimal.valueOf(v));
                    }
                }
            } else if (unaryOperator == CUnaryExpression.UnaryOperator.TILDE && ((CSimpleType)operandType).getType().isIntegerType()) {
                NumericValue complementValue = (NumericValue)AbstractExpressionValueVisitor.castCValue(new NumericValue(value.longValue() ^ 0xFFFFFFFFFFFFFFFFL), exprType, this.machineModel, this.logger, loc);
                return new CIntegerLiteralExpression(loc, exprType, complementValue.bigInteger());
            }
        }
        CUnaryExpression newExpr = op == operand ? expr : new CUnaryExpression(loc, exprType, op, unaryOperator);
        return newExpr;
    }

    @Override
    public CExpression visit(CIdExpression expr) {
        NumericValue v;
        CInitializer init;
        CSimpleDeclaration decl = expr.getDeclaration();
        CType type = expr.getExpressionType();
        if (decl instanceof CEnumType.CEnumerator && ((CEnumType.CEnumerator)decl).hasValue()) {
            long v2 = ((CEnumType.CEnumerator)decl).getValue();
            return new CIntegerLiteralExpression(expr.getFileLocation(), type, BigInteger.valueOf(v2));
        }
        if (!(type instanceof CProblemType) && type.isConst() && decl instanceof CVariableDeclaration && (init = ((CVariableDeclaration)decl).getInitializer()) instanceof CExpression && (v = this.getValue((CExpression)((Object)init))) != null && decl.getType() instanceof CSimpleType) {
            switch (((CSimpleType)type).getType()) {
                case BOOL: 
                case CHAR: 
                case INT: {
                    return new CIntegerLiteralExpression(expr.getFileLocation(), type, BigInteger.valueOf(v.longValue()));
                }
                case FLOAT: 
                case DOUBLE: {
                    return new CFloatLiteralExpression(expr.getFileLocation(), type, BigDecimal.valueOf(v.doubleValue()));
                }
            }
        }
        return this.visitDefault(expr);
    }
}

