/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

public final class MachineModel
extends Enum<MachineModel> {
    public static final /* enum */ MachineModel LINUX32 = new MachineModel(2, 4, 4, 8, 4, 8, 12, 1, 1, 4, 2, 4, 4, 4, 4, 4, 4, 1, 1, 4, true, ByteOrder.LITTLE_ENDIAN);
    public static final /* enum */ MachineModel LINUX64 = new MachineModel(2, 4, 8, 8, 4, 8, 16, 1, 1, 8, 2, 4, 8, 8, 4, 8, 16, 1, 1, 8, true, ByteOrder.LITTLE_ENDIAN);
    public static final /* enum */ MachineModel ARM = new MachineModel(2, 4, 4, 8, 4, 8, 8, 1, 1, 4, 2, 4, 4, 8, 4, 8, 8, 1, 1, 4, false, ByteOrder.LITTLE_ENDIAN);
    public static final /* enum */ MachineModel ARM64 = new MachineModel(2, 4, 8, 8, 4, 8, 16, 1, 1, 8, 2, 4, 8, 8, 4, 8, 16, 1, 1, 8, false, ByteOrder.LITTLE_ENDIAN);
    private final int sizeofShort;
    private final int sizeofInt;
    private final int sizeofLongInt;
    private final int sizeofLongLongInt;
    private final int sizeofFloat;
    private final int sizeofDouble;
    private final int sizeofLongDouble;
    private final int sizeofVoid;
    private final int sizeofBool;
    private final int sizeofPtr;
    private final transient ByteOrder endianness;
    private final int alignofShort;
    private final int alignofInt;
    private final int alignofLongInt;
    private final int alignofLongLongInt;
    private final int alignofFloat;
    private final int alignofDouble;
    private final int alignofLongDouble;
    private final int alignofVoid;
    private final int alignofBool;
    private final int alignofPtr;
    private final int mSizeofChar = 1;
    private final int mAlignofChar = 1;
    private final boolean defaultCharSigned;
    private final int mSizeofCharInBits = 8;
    private final CSimpleType ptrEquivalent;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final BaseSizeofVisitor sizeofVisitor = new BaseSizeofVisitor(this);
    @SuppressFBWarnings(value={"SE_BAD_FIELD_STORE"})
    private final CTypeVisitor<Integer, IllegalArgumentException> alignofVisitor = new BaseAlignofVisitor(this);
    private static final /* synthetic */ MachineModel[] $VALUES;

    public static MachineModel[] values() {
        return (MachineModel[])$VALUES.clone();
    }

    public static MachineModel valueOf(String name) {
        return Enum.valueOf(MachineModel.class, name);
    }

    private MachineModel(int pSizeofShort, int pSizeofInt, int pSizeofLongInt, int pSizeofLongLongInt, int pSizeofFloat, int pSizeofDouble, int pSizeofLongDouble, int pSizeofVoid, int pSizeofBool, int pSizeOfPtr, int pAlignofShort, int pAlignofInt, int pAlignofLongInt, int pAlignofLongLongInt, int pAlignofFloat, int pAlignofDouble, int pAlignofLongDouble, int pAlignofVoid, int pAlignofBool, int pAlignofPtr, boolean pDefaultCharSigned, ByteOrder pEndianness) {
        this.sizeofShort = pSizeofShort;
        this.sizeofInt = pSizeofInt;
        this.sizeofLongInt = pSizeofLongInt;
        this.sizeofLongLongInt = pSizeofLongLongInt;
        this.sizeofFloat = pSizeofFloat;
        this.sizeofDouble = pSizeofDouble;
        this.sizeofLongDouble = pSizeofLongDouble;
        this.sizeofVoid = pSizeofVoid;
        this.sizeofBool = pSizeofBool;
        this.sizeofPtr = pSizeOfPtr;
        this.alignofShort = pAlignofShort;
        this.alignofInt = pAlignofInt;
        this.alignofLongInt = pAlignofLongInt;
        this.alignofLongLongInt = pAlignofLongLongInt;
        this.alignofFloat = pAlignofFloat;
        this.alignofDouble = pAlignofDouble;
        this.alignofLongDouble = pAlignofLongDouble;
        this.alignofVoid = pAlignofVoid;
        this.alignofBool = pAlignofBool;
        this.alignofPtr = pAlignofPtr;
        this.defaultCharSigned = pDefaultCharSigned;
        this.endianness = pEndianness;
        if (this.sizeofPtr == this.sizeofInt) {
            this.ptrEquivalent = CNumericTypes.INT;
        } else if (this.sizeofPtr == this.sizeofLongInt) {
            this.ptrEquivalent = CNumericTypes.LONG_INT;
        } else if (this.sizeofPtr == this.sizeofLongLongInt) {
            this.ptrEquivalent = CNumericTypes.LONG_LONG_INT;
        } else if (this.sizeofPtr == this.sizeofShort) {
            this.ptrEquivalent = CNumericTypes.SHORT_INT;
        } else {
            throw new AssertionError((Object)"No ptr-Equivalent found");
        }
    }

    public CSimpleType getPointerEquivalentSimpleType() {
        return this.ptrEquivalent;
    }

    public CSimpleType getPointerDiffType() {
        assert (!this.ptrEquivalent.isUnsigned());
        return this.ptrEquivalent.getCanonicalType();
    }

    public boolean isDefaultCharSigned() {
        return this.defaultCharSigned;
    }

    public boolean isSigned(CSimpleType t) {
        if ((t = t.getCanonicalType()).isSigned()) {
            return true;
        }
        if (t.isUnsigned()) {
            return false;
        }
        switch (t.getType()) {
            case CHAR: {
                return this.isDefaultCharSigned();
            }
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
            case INT: {
                throw new AssertionError((Object)"Canonical type of INT should always have sign modifier");
            }
            case UNSPECIFIED: {
                throw new AssertionError((Object)"Canonical type should never be UNSPECIFIED");
            }
        }
        return false;
    }

    public int getSizeofCharInBits() {
        return 8;
    }

    public int getSizeofShort() {
        return this.sizeofShort;
    }

    public int getSizeofInt() {
        return this.sizeofInt;
    }

    public int getSizeofLongInt() {
        return this.sizeofLongInt;
    }

    public int getSizeofLongLongInt() {
        return this.sizeofLongLongInt;
    }

    public int getSizeofInt128() {
        return 128 / this.getSizeofCharInBits();
    }

    public int getSizeofFloat() {
        return this.sizeofFloat;
    }

    public int getSizeofDouble() {
        return this.sizeofDouble;
    }

    public int getSizeofLongDouble() {
        return this.sizeofLongDouble;
    }

    public int getSizeofFloat128() {
        return 128 / this.getSizeofCharInBits();
    }

    public int getSizeofVoid() {
        return this.sizeofVoid;
    }

    public int getSizeofBool() {
        return this.sizeofBool;
    }

    public int getSizeofChar() {
        return 1;
    }

    public int getSizeofPtr() {
        return this.sizeofPtr;
    }

    public int getSizeof(CSimpleType type) {
        switch (type.getType()) {
            case BOOL: {
                return this.getSizeofBool();
            }
            case CHAR: {
                return this.getSizeofChar();
            }
            case FLOAT: {
                return this.getSizeofFloat();
            }
            case INT: 
            case UNSPECIFIED: {
                if (type.isLongLong()) {
                    return this.getSizeofLongLongInt();
                }
                if (type.isLong()) {
                    return this.getSizeofLongInt();
                }
                if (type.isShort()) {
                    return this.getSizeofShort();
                }
                return this.getSizeofInt();
            }
            case INT128: {
                return this.getSizeofInt128();
            }
            case DOUBLE: {
                if (type.isLong()) {
                    return this.getSizeofLongDouble();
                }
                return this.getSizeofDouble();
            }
            case FLOAT128: {
                return this.getSizeofFloat128();
            }
        }
        throw new AssertionError((Object)("Unrecognized CBasicType " + type.getType()));
    }

    public ByteOrder getEndianness() {
        return this.endianness;
    }

    public int getSizeofInBits(CSimpleType type) {
        return this.getSizeof(type) * this.getSizeofCharInBits();
    }

    public int getAlignofShort() {
        return this.alignofShort;
    }

    public int getAlignofInt() {
        return this.alignofInt;
    }

    public int getAlignofLongInt() {
        return this.alignofLongInt;
    }

    public int getAlignofLongLongInt() {
        return this.alignofLongLongInt;
    }

    public int getAlignofInt128() {
        return this.getSizeofInt128();
    }

    public int getAlignofFloat() {
        return this.alignofFloat;
    }

    public int getAlignofDouble() {
        return this.alignofDouble;
    }

    public int getAlignofLongDouble() {
        return this.alignofLongDouble;
    }

    public int getAlignofFloat128() {
        return this.getSizeofFloat128();
    }

    public int getAlignofVoid() {
        return this.alignofVoid;
    }

    public int getAlignofBool() {
        return this.alignofBool;
    }

    public int getAlignofChar() {
        return 1;
    }

    public int getAlignofPtr() {
        return this.alignofPtr;
    }

    public CType applyIntegerPromotion(CType pType) {
        Preconditions.checkArgument((boolean)CTypes.isIntegerType(pType), (String)"Integer promotion cannot be applied to %s", (Object)pType);
        if (this.getSizeof(pType).compareTo(BigInteger.valueOf(this.getSizeofInt())) < 0) {
            return CNumericTypes.SIGNED_INT;
        }
        return pType;
    }

    public BigInteger getMinimalIntegerValue(CSimpleType pType) {
        Preconditions.checkArgument((boolean)pType.getType().isIntegerType());
        if (this.isSigned(pType)) {
            return MachineModel.twoToThePowerOf(this.getSizeofInBits(pType) - 1).negate();
        }
        return BigInteger.ZERO;
    }

    public BigInteger getMaximalIntegerValue(CSimpleType pType) {
        Preconditions.checkArgument((boolean)pType.getType().isIntegerType());
        if (pType.getType() == CBasicType.BOOL) {
            return BigInteger.ONE;
        }
        if (this.isSigned(pType)) {
            return MachineModel.twoToThePowerOf(this.getSizeofInBits(pType) - 1).subtract(BigInteger.ONE);
        }
        return MachineModel.twoToThePowerOf(this.getSizeofInBits(pType)).subtract(BigInteger.ONE);
    }

    private static BigInteger twoToThePowerOf(int exp) {
        assert (exp > 0) : "Exponent " + exp + " is not greater than zero.";
        BigInteger result = BigInteger.ZERO.setBit(exp);
        assert (BigInteger.valueOf(2L).pow(exp).equals(result));
        return result;
    }

    public BigInteger getSizeof(CType pType) {
        Preconditions.checkArgument((pType.getCanonicalType() instanceof CVoidType || !pType.isIncomplete() ? 1 : 0) != 0, (String)"Cannot compute size of incomplete type %s", (Object)pType);
        return this.getSizeof(pType, this.sizeofVisitor);
    }

    public BigInteger getSizeof(CType pType, BaseSizeofVisitor pSizeofVisitor) {
        Preconditions.checkNotNull((Object)pSizeofVisitor);
        return pType.accept(pSizeofVisitor);
    }

    public int getSizeofPtrInBits() {
        return this.getSizeofPtr() * this.getSizeofCharInBits();
    }

    public BigInteger getSizeofInBits(CType pType) {
        return this.getSizeofInBits(pType, this.sizeofVisitor);
    }

    public BigInteger getSizeofInBits(CType pType, BaseSizeofVisitor pSizeofVisitor) {
        Preconditions.checkNotNull((Object)pSizeofVisitor);
        if (pType instanceof CBitFieldType) {
            return BigInteger.valueOf(((CBitFieldType)pType).getBitFieldSize());
        }
        return this.getSizeof(pType, pSizeofVisitor).multiply(BigInteger.valueOf(this.getSizeofCharInBits()));
    }

    public int getAlignof(CType type) {
        return type.accept(this.alignofVisitor);
    }

    public Map<CCompositeType.CCompositeTypeMemberDeclaration, BigInteger> getAllFieldOffsetsInBits(CCompositeType pOwnerType) {
        ImmutableMap.Builder outParameterMap = ImmutableMap.builder();
        this.getFieldOffsetOrSizeOrFieldOffsetsMappedInBits(pOwnerType, null, (ImmutableMap.Builder<CCompositeType.CCompositeTypeMemberDeclaration, BigInteger>)outParameterMap);
        return outParameterMap.buildOrThrow();
    }

    public BigInteger getFieldOffsetInBits(CCompositeType pOwnerType, String pFieldName) {
        Preconditions.checkNotNull((Object)pFieldName);
        return this.getFieldOffsetOrSizeOrFieldOffsetsMappedInBits(pOwnerType, pFieldName, null);
    }

    private BigInteger getFieldOffsetOrSizeOrFieldOffsetsMappedInBits(CCompositeType pOwnerType, @Nullable String pFieldName, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable ImmutableMap.Builder<CCompositeType.CCompositeTypeMemberDeclaration, BigInteger> outParameterMap) {
        Preconditions.checkArgument((pFieldName == null || outParameterMap == null ? 1 : 0) != 0, (Object)"Call of this method does only make sense if either pFieldName or outParameterMap is of value null, otherwise it either stops the calculation with an incomplete map or wastes ressources by filling a map with values that are not required.");
        CComplexType.ComplexTypeKind ownerTypeKind = pOwnerType.getKind();
        List<CCompositeType.CCompositeTypeMemberDeclaration> typeMembers = pOwnerType.getMembers();
        BigInteger bitOffset = BigInteger.ZERO;
        BigInteger sizeOfConsecutiveBitFields = BigInteger.ZERO;
        long sizeOfByte = this.getSizeofCharInBits();
        if (ownerTypeKind == CComplexType.ComplexTypeKind.UNION) {
            if (outParameterMap == null) {
                if (typeMembers.stream().anyMatch(m -> m.getName().equals(pFieldName))) {
                    return bitOffset;
                }
            } else {
                for (CCompositeType.CCompositeTypeMemberDeclaration typeMember : typeMembers) {
                    outParameterMap.put((Object)typeMember, (Object)BigInteger.ZERO);
                }
            }
        } else if (ownerTypeKind == CComplexType.ComplexTypeKind.STRUCT) {
            Iterator<CCompositeType.CCompositeTypeMemberDeclaration> iterator = typeMembers.iterator();
            while (iterator.hasNext()) {
                CCompositeType.CCompositeTypeMemberDeclaration typeMember = iterator.next();
                CType type = typeMember.getType();
                BigInteger fieldSizeInBits = BigInteger.valueOf(-1L);
                if (type.isIncomplete()) {
                    if (iterator.hasNext()) {
                        throw new AssertionError((Object)("unexpected incomplete type " + type + " for field " + pFieldName + " in " + pOwnerType));
                    }
                    fieldSizeInBits = BigInteger.ZERO;
                } else {
                    fieldSizeInBits = this.getSizeofInBits(type);
                }
                if (type instanceof CBitFieldType) {
                    if (typeMember.getName().equals(pFieldName)) {
                        bitOffset = bitOffset.add(sizeOfConsecutiveBitFields);
                        return bitOffset;
                    }
                    CType innerType = ((CBitFieldType)type).getType();
                    if (fieldSizeInBits.compareTo(BigInteger.ZERO) == 0) {
                        bitOffset = this.calculatePaddedBitsize(bitOffset, sizeOfConsecutiveBitFields, innerType, sizeOfByte);
                        sizeOfConsecutiveBitFields = BigInteger.ZERO;
                    } else {
                        sizeOfConsecutiveBitFields = this.calculateNecessaryBitfieldOffset(sizeOfConsecutiveBitFields.add(bitOffset), innerType, sizeOfByte, fieldSizeInBits).subtract(bitOffset);
                        sizeOfConsecutiveBitFields = sizeOfConsecutiveBitFields.add(fieldSizeInBits);
                    }
                    if (outParameterMap == null) continue;
                    outParameterMap.put((Object)typeMember, (Object)bitOffset.add(sizeOfConsecutiveBitFields).subtract(fieldSizeInBits));
                    continue;
                }
                bitOffset = this.calculatePaddedBitsize(bitOffset, sizeOfConsecutiveBitFields, type, sizeOfByte);
                sizeOfConsecutiveBitFields = BigInteger.ZERO;
                if (typeMember.getName().equals(pFieldName)) {
                    return bitOffset;
                }
                if (outParameterMap != null) {
                    outParameterMap.put((Object)typeMember, (Object)bitOffset);
                }
                bitOffset = bitOffset.add(fieldSizeInBits);
            }
        }
        if (pFieldName != null) {
            throw new IllegalArgumentException("could not find field " + pFieldName + " in " + pOwnerType);
        }
        return this.calculatePaddedBitsize(bitOffset, sizeOfConsecutiveBitFields, pOwnerType, 1L);
    }

    @Deprecated
    public BigInteger calculateNecessaryBitfieldOffset(BigInteger pBitFieldOffset, CType pType, long pSizeOfByte, BigInteger pBitFieldLength) {
        BigInteger paddingBitSpace = this.getPaddingInBits(pBitFieldOffset, pType, pSizeOfByte);
        if (paddingBitSpace.compareTo(pBitFieldLength) < 0) {
            pBitFieldOffset = pBitFieldOffset.add(paddingBitSpace);
        }
        return pBitFieldOffset;
    }

    @Deprecated
    public BigInteger calculatePaddedBitsize(BigInteger pBitOffset, BigInteger pSizeOfConsecutiveBitFields, CType pType, long pSizeOfByte) {
        pBitOffset = pBitOffset.add(pSizeOfConsecutiveBitFields);
        pBitOffset = this.sizeofVisitor.calculateByteSize(pBitOffset);
        return pBitOffset.add(this.getPadding(pBitOffset, pType)).multiply(BigInteger.valueOf(pSizeOfByte));
    }

    @Deprecated
    public BigInteger getPadding(BigInteger pOffset, CType pType) {
        return this.getPaddingInBits(pOffset, pType, 1L);
    }

    private BigInteger getPaddingInBits(BigInteger pOffset, CType pType, long pSizeOfByte) {
        BigInteger alignof = BigInteger.valueOf((long)this.getAlignof(pType) * pSizeOfByte);
        BigInteger padding = alignof.subtract(pOffset.mod(alignof));
        if (padding.compareTo(alignof) < 0) {
            return padding;
        }
        return BigInteger.ZERO;
    }

    static {
        $VALUES = new MachineModel[]{LINUX32, LINUX64, ARM, ARM64};
    }

    private static class BaseAlignofVisitor
    implements CTypeVisitor<Integer, IllegalArgumentException> {
        private final MachineModel model;

        private BaseAlignofVisitor(MachineModel model) {
            this.model = model;
        }

        @Override
        public Integer visit(CArrayType pArrayType) throws IllegalArgumentException {
            return pArrayType.getType().accept(this);
        }

        @Override
        public Integer visit(CCompositeType pCompositeType) throws IllegalArgumentException {
            switch (pCompositeType.getKind()) {
                case STRUCT: 
                case UNION: {
                    int alignof = 1;
                    for (CCompositeType.CCompositeTypeMemberDeclaration decl : pCompositeType.getMembers()) {
                        int alignOfType = decl.getType().accept(this);
                        alignof = Math.max(alignof, alignOfType);
                    }
                    return alignof;
                }
            }
            throw new AssertionError();
        }

        @Override
        public Integer visit(CElaboratedType pElaboratedType) throws IllegalArgumentException {
            CComplexType def = pElaboratedType.getRealType();
            if (def != null) {
                return def.accept(this);
            }
            if (pElaboratedType.getKind() == CComplexType.ComplexTypeKind.ENUM) {
                return this.model.getAlignofInt();
            }
            throw new IllegalArgumentException("Cannot compute alignment of incomplete type " + pElaboratedType);
        }

        @Override
        public Integer visit(CEnumType pEnumType) throws IllegalArgumentException {
            return this.model.getAlignofInt();
        }

        @Override
        public Integer visit(CFunctionType pFunctionType) throws IllegalArgumentException {
            return 1;
        }

        @Override
        public Integer visit(CPointerType pPointerType) throws IllegalArgumentException {
            return this.model.getAlignofPtr();
        }

        @Override
        public Integer visit(CProblemType pProblemType) throws IllegalArgumentException {
            throw new IllegalArgumentException("Unknown C-Type: " + pProblemType.getClass());
        }

        @Override
        public Integer visit(CSimpleType pSimpleType) throws IllegalArgumentException {
            switch (pSimpleType.getType()) {
                case BOOL: {
                    return this.model.getAlignofBool();
                }
                case CHAR: {
                    return this.model.getAlignofChar();
                }
                case FLOAT: {
                    return this.model.getAlignofFloat();
                }
                case INT: 
                case UNSPECIFIED: {
                    if (pSimpleType.isLongLong()) {
                        return this.model.getAlignofLongLongInt();
                    }
                    if (pSimpleType.isLong()) {
                        return this.model.getAlignofLongInt();
                    }
                    if (pSimpleType.isShort()) {
                        return this.model.getAlignofShort();
                    }
                    return this.model.getAlignofInt();
                }
                case INT128: {
                    return this.model.getAlignofInt128();
                }
                case DOUBLE: {
                    if (pSimpleType.isLong()) {
                        return this.model.getAlignofLongDouble();
                    }
                    return this.model.getAlignofDouble();
                }
                case FLOAT128: {
                    return this.model.getAlignofFloat128();
                }
            }
            throw new AssertionError((Object)("Unrecognized CBasicType " + pSimpleType.getType()));
        }

        @Override
        public Integer visit(CTypedefType pTypedefType) throws IllegalArgumentException {
            return pTypedefType.getRealType().accept(this);
        }

        @Override
        public Integer visit(CVoidType pVoidType) throws IllegalArgumentException {
            return this.model.getAlignofVoid();
        }

        @Override
        public Integer visit(CBitFieldType pCBitFieldType) throws IllegalArgumentException {
            return pCBitFieldType.getType().accept(this);
        }
    }

    public static class BaseSizeofVisitor
    implements CTypeVisitor<BigInteger, IllegalArgumentException> {
        private final MachineModel model;

        protected BaseSizeofVisitor(MachineModel model) {
            this.model = model;
        }

        @Override
        public BigInteger visit(CArrayType pArrayType) throws IllegalArgumentException {
            CExpression arrayLength = pArrayType.getLength();
            if (arrayLength instanceof CIntegerLiteralExpression) {
                BigInteger length = ((CIntegerLiteralExpression)arrayLength).getValue();
                BigInteger sizeOfType = this.model.getSizeof(pArrayType.getType());
                return length.multiply(sizeOfType);
            }
            return BigInteger.valueOf(this.model.getSizeofPtr());
        }

        @Override
        public BigInteger visit(CCompositeType pCompositeType) throws IllegalArgumentException {
            switch (pCompositeType.getKind()) {
                case STRUCT: {
                    return this.handleSizeOfStruct(pCompositeType);
                }
                case UNION: {
                    return this.handleSizeOfUnion(pCompositeType);
                }
            }
            throw new AssertionError();
        }

        private BigInteger calculateByteSize(BigInteger pBitFieldsSize) {
            if (pBitFieldsSize.compareTo(BigInteger.ZERO) == 0) {
                return BigInteger.ZERO;
            }
            BigInteger charSizeInBits = BigInteger.valueOf(this.model.getSizeofCharInBits());
            BigInteger result = pBitFieldsSize.divide(charSizeInBits);
            if (pBitFieldsSize.mod(charSizeInBits).compareTo(BigInteger.ZERO) > 0) {
                result = result.add(BigInteger.ONE);
            }
            return result;
        }

        private BigInteger handleSizeOfStruct(CCompositeType pCompositeType) {
            return this.model.getFieldOffsetOrSizeOrFieldOffsetsMappedInBits(pCompositeType, null, null);
        }

        private BigInteger handleSizeOfUnion(CCompositeType pCompositeType) {
            BigInteger size = BigInteger.ZERO;
            BigInteger sizeOfType = BigInteger.ZERO;
            for (CCompositeType.CCompositeTypeMemberDeclaration decl : pCompositeType.getMembers()) {
                sizeOfType = decl.getType().accept(this);
                size = size.max(sizeOfType);
            }
            return size;
        }

        @Override
        public BigInteger visit(CElaboratedType pElaboratedType) throws IllegalArgumentException {
            CComplexType def = pElaboratedType.getRealType();
            if (def != null) {
                return def.accept(this);
            }
            if (pElaboratedType.getKind() == CComplexType.ComplexTypeKind.ENUM) {
                return BigInteger.valueOf(this.model.getSizeofInt());
            }
            throw new IllegalArgumentException("Cannot compute size of incomplete type " + pElaboratedType);
        }

        @Override
        public BigInteger visit(CEnumType pEnumType) throws IllegalArgumentException {
            Preconditions.checkState((!pEnumType.getEnumerators().isEmpty() ? 1 : 0) != 0);
            return this.model.getSizeof(((CEnumType.CEnumerator)pEnumType.getEnumerators().get(0)).getType());
        }

        @Override
        public BigInteger visit(CFunctionType pFunctionType) throws IllegalArgumentException {
            return BigInteger.valueOf(this.model.getSizeofPtr());
        }

        @Override
        public BigInteger visit(CPointerType pPointerType) throws IllegalArgumentException {
            return BigInteger.valueOf(this.model.getSizeofPtr());
        }

        @Override
        public BigInteger visit(CProblemType pProblemType) throws IllegalArgumentException {
            throw new IllegalArgumentException("Unknown C-Type: " + pProblemType.getClass());
        }

        @Override
        public BigInteger visit(CSimpleType pSimpleType) throws IllegalArgumentException {
            return BigInteger.valueOf(this.model.getSizeof(pSimpleType));
        }

        @Override
        public BigInteger visit(CTypedefType pTypedefType) throws IllegalArgumentException {
            return pTypedefType.getRealType().accept(this);
        }

        @Override
        public BigInteger visit(CVoidType pVoidType) throws IllegalArgumentException {
            return BigInteger.valueOf(this.model.getSizeofVoid());
        }

        @Override
        public BigInteger visit(CBitFieldType pCBitFieldType) throws IllegalArgumentException {
            return this.calculateByteSize(BigInteger.valueOf(pCBitFieldType.getBitFieldSize()));
        }
    }
}

