/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;

@RunWith(value=Parameterized.class)
@SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Fields are filled by parameterization of JUnit")
public class MachineModelGetOffsetTest {
    private static final String TEST_STRUCT = "testStruct";
    private static final String FIRST_BITFIELD_12 = "firstBitfield";
    private static final String SECOND_BITFIELD_10 = "secondBitfield";
    private static final String THIRD_INT = "thirdInt";
    private static final String LAST_INCOMPLETEARRAY = "lastIncomplete";
    private static final String LONG_BITFIELD_15 = "long_bitfield_15";
    private static final String LONG_BITFIELD_18 = "long_bitfield_18";
    private static final String CHAR = "char";
    private static final MachineModel MODEL64 = MachineModel.LINUX64;
    private static final MachineModel MODEL32 = MachineModel.LINUX32;
    private static final ImmutableList<CCompositeType.CCompositeTypeMemberDeclaration> FIELDS = ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.UNSIGNED_INT, 12), "firstBitfield"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.UNSIGNED_INT, 10), "secondBitfield"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "thirdInt"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CArrayType(false, false, CNumericTypes.LONG_LONG_INT, null), "lastIncomplete"));
    private static final CCompositeType STRUCT = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)FIELDS, "testStruct", "testStruct");
    private static final ImmutableList<CCompositeType.CCompositeTypeMemberDeclaration> FIELDS_2 = ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "thirdInt"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_INT, 15), "long_bitfield_15"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_INT, 18), "long_bitfield_18"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.CHAR, "char"));
    private static final CCompositeType STRUCT_2 = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)FIELDS_2, "testStruct", "testStruct");
    private static final ImmutableList<CCompositeType.CCompositeTypeMemberDeclaration> FIELDS_3 = ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "thirdInt"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_INT, 17), "long_bitfield_15"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_INT, 16), "long_bitfield_18"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.CHAR, "char"));
    private static final CCompositeType STRUCT_3 = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)FIELDS_3, "testStruct", "testStruct");
    @Parameterized.Parameter(value=0)
    public CCompositeType testStruct;
    @Parameterized.Parameter(value=1)
    public String testField;
    @Parameterized.Parameter(value=2)
    public BigInteger expectedOffset;
    @Parameterized.Parameter(value=3)
    public MachineModel model;

    @Parameterized.Parameters(name="{2}: {0}")
    public static Object[][] machineModels() {
        return new Object[][]{{STRUCT, FIRST_BITFIELD_12, BigInteger.ZERO, MODEL32}, {STRUCT, FIRST_BITFIELD_12, BigInteger.ZERO, MODEL64}, {STRUCT, SECOND_BITFIELD_10, BigInteger.valueOf(12L), MODEL32}, {STRUCT, SECOND_BITFIELD_10, BigInteger.valueOf(12L), MODEL64}, {STRUCT, THIRD_INT, BigInteger.valueOf(32L), MODEL32}, {STRUCT, THIRD_INT, BigInteger.valueOf(32L), MODEL64}, {STRUCT, LAST_INCOMPLETEARRAY, BigInteger.valueOf(64L), MODEL32}, {STRUCT, LAST_INCOMPLETEARRAY, BigInteger.valueOf(64L), MODEL64}, {STRUCT_2, CHAR, BigInteger.valueOf(88L), MODEL32}, {STRUCT_2, CHAR, BigInteger.valueOf(88L), MODEL64}, {STRUCT_3, CHAR, BigInteger.valueOf(80L), MODEL32}, {STRUCT_3, CHAR, BigInteger.valueOf(80L), MODEL64}};
    }

    @Test
    public void testGetFieldOffsetInStruct() {
        Truth.assertThat((Comparable)this.model.getFieldOffsetInBits(this.testStruct, this.testField)).isEqualTo((Object)this.expectedOffset);
    }
}

