/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth8;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;

@RunWith(value=Parameterized.class)
@SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Fields are filled by parameterization of JUnit")
public class MachineModelSizeOfVisitorTest {
    private static final String TEST_STRUCT = "testStruct";
    private static final String FIRST_BITFIELD_12 = "firstBitfield";
    private static final String SECOND_BITFIELD_10 = "secondBitfield";
    private static final String LONGLONG = "longlong";
    private static final String THIRD_INT = "thirdInt";
    private static final String CHAR = "char";
    private static final String INT_POINTER = "int_pointer";
    private static final String VOID_POINTER = "void_pointer";
    private static final String LONGLONG_BITFIELD = "longlong_bitfield";
    private static final String CHAR_BITFIELD_5 = "char_bitfield_5";
    private static final String CHAR_BITFIELD_4_1 = "char_bitfield_4_1";
    private static final String CHAR_BITFIELD_4_0 = "char_bitfield_4_0";
    private static final String LONG_BITFIELD_0 = "long_bitfield_0";
    private static final String LONG_BITFIELD_9 = "long_bitfield_9";
    private static final String LONG_BITFIELD_15 = "long_bitfield_15";
    private static final String LONG_BITFIELD_18 = "long_bitfield_18";
    private static final MachineModel MODEL64 = MachineModel.LINUX64;
    private static final MachineModel MODEL32 = MachineModel.LINUX32;
    private static final ImmutableList<CCompositeType.CCompositeTypeMemberDeclaration> FIELDS = ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.UNSIGNED_INT, 12), "firstBitfield"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.UNSIGNED_INT, 10), "secondBitfield"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "thirdInt"));
    private static final CCompositeType STRUCT_1 = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)FIELDS, "testStruct", "testStruct");
    private static final ImmutableList<CCompositeType.CCompositeTypeMemberDeclaration> FIELDS_2 = ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.CHAR, 4), "char_bitfield_4_0"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.CHAR, 4), "char_bitfield_4_1"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.UNSIGNED_INT, 12), "firstBitfield"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.UNSIGNED_INT, 10), "secondBitfield"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "thirdInt"));
    private static final CCompositeType STRUCT_2 = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)FIELDS_2, "testStruct", "testStruct");
    private static final ImmutableList<CCompositeType.CCompositeTypeMemberDeclaration> FIELDS_3 = ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.CHAR, 4), "char_bitfield_4_0"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.CHAR, 5), "char_bitfield_5"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.UNSIGNED_INT, 12), "firstBitfield"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.UNSIGNED_INT, 10), "secondBitfield"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "thirdInt"));
    private static final CCompositeType STRUCT_3 = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)FIELDS_3, "testStruct", "testStruct");
    private static final ImmutableList<CCompositeType.CCompositeTypeMemberDeclaration> FIELDS_4 = ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_LONG_INT, 8), "longlong_bitfield"));
    private static final CCompositeType STRUCT_4 = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)FIELDS_4, "testStruct", "testStruct");
    private static final ImmutableList<CCompositeType.CCompositeTypeMemberDeclaration> FIELDS_5 = ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.CHAR, "char"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.LONG_LONG_INT, "longlong"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CPointerType(false, false, CNumericTypes.INT), "int_pointer"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.CHAR, 5), "char_bitfield_5"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.CHAR, 4), "char_bitfield_4_0"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.INT, 12), "firstBitfield"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_LONG_INT, 3), "longlong_bitfield"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.INT, 2), "secondBitfield"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(CPointerType.POINTER_TO_VOID, "void_pointer"));
    private static final CCompositeType STRUCT_5 = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)FIELDS_5, "testStruct", "testStruct");
    private static final ImmutableList<CCompositeType.CCompositeTypeMemberDeclaration> FIELDS_6 = ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "thirdInt"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_INT, 15), "long_bitfield_15"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_INT, 0), "long_bitfield_0"));
    private static final CCompositeType STRUCT_6 = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)FIELDS_6, "testStruct", "testStruct");
    private static final ImmutableList<CCompositeType.CCompositeTypeMemberDeclaration> FIELDS_7 = ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "thirdInt"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_INT, 15), "long_bitfield_15"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_INT, 18), "long_bitfield_18"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.CHAR, "char"));
    private static final CCompositeType STRUCT_7 = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)FIELDS_7, "testStruct", "testStruct");
    private static final ImmutableList<CCompositeType.CCompositeTypeMemberDeclaration> FIELDS_8 = ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "thirdInt"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_INT, 15), "long_bitfield_15"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_INT, 9), "long_bitfield_9"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.CHAR, "char"));
    private static final CCompositeType STRUCT_8 = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)FIELDS_8, "testStruct", "testStruct");
    private static final ImmutableList<CCompositeType.CCompositeTypeMemberDeclaration> FIELDS_9 = ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "thirdInt"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_INT, 15), "long_bitfield_15"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(new CBitFieldType(CNumericTypes.LONG_INT, 0), "long_bitfield_0"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.CHAR, "char"));
    private static final CCompositeType STRUCT_9 = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, (List<CCompositeType.CCompositeTypeMemberDeclaration>)FIELDS_9, "testStruct", "testStruct");
    @Parameterized.Parameter(value=0)
    public CCompositeType testStruct;
    @Parameterized.Parameter(value=1)
    public MachineModel model;
    @Parameterized.Parameter(value=2)
    public int expectedSize;
    @Parameterized.Parameter(value=3)
    public String name;

    @Parameterized.Parameters(name="{3}: {1}")
    public static Object[][] machineModels() {
        return new Object[][]{{STRUCT_1, MODEL64, 8, "Struct_1"}, {STRUCT_1, MODEL32, 8, "Struct_1"}, {STRUCT_2, MODEL64, 8, "Struct_2"}, {STRUCT_2, MODEL32, 8, "Struct_2"}, {STRUCT_3, MODEL64, 12, "Struct_3"}, {STRUCT_3, MODEL32, 12, "Struct_3"}, {STRUCT_4, MODEL64, 8, "Struct_4"}, {STRUCT_4, MODEL32, 4, "Struct_4"}, {STRUCT_5, MODEL64, 40, "Struct_5"}, {STRUCT_5, MODEL32, 24, "Struct_5"}, {STRUCT_6, MODEL64, 8, "Struct_6"}, {STRUCT_6, MODEL32, 8, "Struct_6"}, {STRUCT_7, MODEL64, 16, "Struct_7"}, {STRUCT_7, MODEL32, 12, "Struct_7"}, {STRUCT_8, MODEL64, 8, "Struct_8"}, {STRUCT_8, MODEL32, 8, "Struct_8"}, {STRUCT_9, MODEL64, 16, "Struct_9"}, {STRUCT_9, MODEL32, 12, "Struct_9"}};
    }

    @Test
    public void testSizeOfStruct() {
        Truth8.assertThat(Optional.of(this.model.getSizeof(this.testStruct))).hasValue((Object)BigInteger.valueOf(this.expectedSize));
    }
}

