/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types;

import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;

@RunWith(value=Parameterized.class)
@SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Fields are filled by parameterization of JUnit")
public class MachineModelTest {
    @Parameterized.Parameter(value=0)
    public CSimpleType type;
    @Parameterized.Parameter(value=1)
    public int sizeInBits;
    @Parameterized.Parameter(value=2)
    public long minValue;
    @Parameterized.Parameter(value=3)
    public long maxValue;
    @Parameterized.Parameter(value=4)
    public MachineModel machineModel;

    @Parameterized.Parameters(name="{4}: {0}")
    public static Object[][] machineModels() {
        Object[][] types = new Object[][]{{CNumericTypes.BOOL, 8, 0L, 1L}, {CNumericTypes.CHAR, 8, -128L, 127L}, {CNumericTypes.SIGNED_CHAR, 8, -128L, 127L}, {CNumericTypes.UNSIGNED_CHAR, 8, 0L, 255L}, {CNumericTypes.SHORT_INT, 16, -32768L, 32767L}, {CNumericTypes.INT, 32, Integer.MIN_VALUE, Integer.MAX_VALUE}, {CNumericTypes.SIGNED_INT, 32, Integer.MIN_VALUE, Integer.MAX_VALUE}, {CNumericTypes.UNSIGNED_INT, 32, 0L, 0xFFFFFFFFL}};
        MachineModel[] machineModels = MachineModel.values();
        Object[][] result = new Object[machineModels.length * types.length][];
        for (int m = 0; m < machineModels.length; ++m) {
            int offset = m * types.length;
            for (int t = 0; t < types.length; ++t) {
                result[offset + t] = Arrays.copyOf(types[t], types[t].length + 1);
                if (types[t][0] == CNumericTypes.CHAR && !machineModels[m].isDefaultCharSigned()) {
                    result[offset + t][2] = 0;
                    result[offset + t][3] = 255;
                }
                result[offset + t][types[t].length] = machineModels[m];
            }
        }
        return result;
    }

    @Test
    public void testSizeOfInBits() {
        Truth.assertThat((Integer)this.machineModel.getSizeofInBits(this.type)).isEqualTo((Object)this.sizeInBits);
    }

    @Test
    public void testMinimalValue() {
        Truth.assertThat((Long)this.machineModel.getMinimalIntegerValue(this.type).longValue()).isEqualTo((Object)this.minValue);
    }

    @Test
    public void testMaximalValue() {
        Truth.assertThat((Long)this.machineModel.getMaximalIntegerValue(this.type).longValue()).isEqualTo((Object)this.maxValue);
    }
}

