/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.OptionalInt;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.AArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public final class CArrayType
extends AArrayType
implements CType {
    private static final long serialVersionUID = -6314468260643330323L;
    private final @Nullable CExpression length;
    private final boolean isConst;
    private final boolean isVolatile;

    public CArrayType(boolean pConst, boolean pVolatile, CType pType, @Nullable CExpression pLength) {
        super(pType);
        this.isConst = pConst;
        this.isVolatile = pVolatile;
        this.length = pLength;
    }

    @Override
    public CType getType() {
        return (CType)super.getType();
    }

    public @Nullable CExpression getLength() {
        return this.length;
    }

    public OptionalInt getLengthAsInt() {
        return this.length instanceof CIntegerLiteralExpression ? OptionalInt.of(((CIntegerLiteralExpression)this.length).getValue().intValueExact()) : OptionalInt.empty();
    }

    public CPointerType asPointerType() {
        return new CPointerType(this.isConst, this.isVolatile, this.getType());
    }

    @Override
    public String toASTString(String pDeclarator) {
        return this.toASTString(pDeclarator, false);
    }

    private String toASTString(String pDeclarator, boolean pQualified) {
        Preconditions.checkNotNull((Object)pDeclarator);
        return (this.isConst() ? "const " : "") + (this.isVolatile() ? "volatile " : "") + this.getType().toASTString(pDeclarator + "[" + (this.length != null ? this.length.toASTString(pQualified) : "") + "]");
    }

    public String toQualifiedASTString(String pDeclarator) {
        return this.toASTString(pDeclarator, true);
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public boolean isIncomplete() {
        return this.length == null;
    }

    @Override
    public boolean hasKnownConstantSize() {
        return this.length instanceof CIntegerLiteralExpression && this.getType().hasKnownConstantSize();
    }

    @Override
    public String toString() {
        return (this.isConst() ? "const " : "") + (this.isVolatile() ? "volatile " : "") + "(" + this.getType() + ")[" + (this.length != null ? this.length.toASTString() : "") + "]";
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.length, this.isConst, this.isVolatile) * 31 + super.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CArrayType) || !super.equals(obj)) {
            return false;
        }
        CArrayType other = (CArrayType)obj;
        if (this.length instanceof CIntegerLiteralExpression && other.length instanceof CIntegerLiteralExpression ? !((CIntegerLiteralExpression)this.length).getValue().equals(((CIntegerLiteralExpression)other.length).getValue()) : !Objects.equals(this.length, other.length)) {
            return false;
        }
        return this.isConst == other.isConst && this.isVolatile == other.isVolatile;
    }

    @Override
    public CArrayType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CArrayType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        return new CArrayType(false, false, this.getType().getCanonicalType(this.isConst || pForceConst, this.isVolatile || pForceVolatile), this.length);
    }
}

