/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Preconditions;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public class CBitFieldType
implements CType {
    private static final long serialVersionUID = 1L;
    private final CType type;
    private final int bitFieldSize;

    public CBitFieldType(CType pBitFieldType, int pBitFieldSize) {
        this.type = this.checkType(pBitFieldType);
        Preconditions.checkArgument((pBitFieldSize >= 0 ? 1 : 0) != 0, (String)"Bit-field size must not be negative, but was %s", (int)pBitFieldSize);
        this.bitFieldSize = pBitFieldSize;
    }

    private CType checkType(CType pBitFieldType) {
        CType canonicalType = pBitFieldType.getCanonicalType();
        if (canonicalType instanceof CSimpleType) {
            CSimpleType simpleType = (CSimpleType)canonicalType;
            CBasicType basicType = simpleType.getType();
            switch (basicType) {
                case BOOL: 
                case CHAR: 
                case INT: {
                    return pBitFieldType;
                }
            }
        } else {
            CElaboratedType elaboratedType;
            if (canonicalType instanceof CEnumType) {
                return pBitFieldType;
            }
            if (canonicalType instanceof CElaboratedType && (elaboratedType = (CElaboratedType)canonicalType).getKind() == CComplexType.ComplexTypeKind.ENUM) {
                return pBitFieldType;
            }
        }
        throw new IllegalArgumentException("Not a valid bit-field type: " + pBitFieldType);
    }

    @Override
    public String toASTString(String pDeclarator) {
        if (this.bitFieldSize == 0) {
            pDeclarator = "";
        }
        return this.type.toASTString(pDeclarator) + " : " + this.bitFieldSize;
    }

    @Override
    public boolean isConst() {
        return this.type.isConst();
    }

    @Override
    public boolean isVolatile() {
        return this.type.isVolatile();
    }

    @Override
    public boolean isIncomplete() {
        return this.type.isIncomplete();
    }

    @Override
    public boolean hasKnownConstantSize() {
        return this.type.hasKnownConstantSize();
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public CType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        CType canonicalBitFieldType = this.type.getCanonicalType(pForceConst, pForceVolatile);
        if (this.type == canonicalBitFieldType) {
            return this;
        }
        return new CBitFieldType(canonicalBitFieldType, this.bitFieldSize);
    }

    public int getBitFieldSize() {
        return this.bitFieldSize;
    }

    public CType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return this.getType() + " : " + this.getBitFieldSize();
    }

    @Override
    public int hashCode() {
        return this.bitFieldSize * 31 + this.type.hashCode();
    }

    @Override
    public boolean equals(Object pObj) {
        if (pObj == this) {
            return true;
        }
        if (pObj instanceof CBitFieldType) {
            CBitFieldType other = (CBitFieldType)pObj;
            return this.bitFieldSize == other.bitFieldSize && this.type.equals(other.type);
        }
        return false;
    }
}

