/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.ClassSanityTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

@RunWith(value=BlockJUnit4ClassRunner.class)
public class CBitFieldTypeTest {
    private final ClassSanityTester tester = new ClassSanityTester();

    public CBitFieldTypeTest() {
        this.tester.setDefault(CType.class, (Object)CNumericTypes.INT);
    }

    @Test
    public void testNulls() {
        this.tester.testNulls(CBitFieldType.class);
    }

    @Test
    public void testEquals() {
        this.tester.testEquals(CBitFieldType.class);
    }

    @Test
    public void testSerializable() {
        SerializableTester.reserializeAndAssert((Object)new CBitFieldType(CNumericTypes.INT, 8));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBaseTypeVoid() {
        new CBitFieldType(CVoidType.VOID, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBaseTypeFloat() {
        new CBitFieldType(CNumericTypes.FLOAT, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBaseTypeDouble() {
        new CBitFieldType(CNumericTypes.DOUBLE, 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBaseTypeProblem() {
        new CBitFieldType(new CProblemType("Problem"), 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBaseTypePointer() {
        new CBitFieldType(new CPointerType(false, false, CNumericTypes.INT), 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBaseTypeElaborateStruct() {
        new CBitFieldType(new CElaboratedType(false, false, CComplexType.ComplexTypeKind.STRUCT, "DummyElaborateStruct", "DummyElaborateStruct", null), 0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeSize() {
        new CBitFieldType(CNumericTypes.INT, -1);
    }

    @Test
    public void testBaseBool() {
        CBitFieldType type = new CBitFieldType(CNumericTypes.BOOL, 0);
        Truth.assertThat((Object)type.getType()).isEqualTo((Object)CNumericTypes.BOOL);
        Truth.assertThat((Integer)type.getBitFieldSize()).isEqualTo((Object)0);
    }

    @Test
    public void testBaseChar() {
        CBitFieldType type = new CBitFieldType(CNumericTypes.CHAR, 0);
        Truth.assertThat((Object)type.getType()).isEqualTo((Object)CNumericTypes.CHAR);
        Truth.assertThat((Integer)type.getBitFieldSize()).isEqualTo((Object)0);
    }

    @Test
    public void testBaseInt() {
        CBitFieldType type = new CBitFieldType(CNumericTypes.INT, 0);
        Truth.assertThat((Object)type.getType()).isEqualTo((Object)CNumericTypes.INT);
        Truth.assertThat((Integer)type.getBitFieldSize()).isEqualTo((Object)0);
    }

    @Test
    public void testBasePositiveSize() {
        CBitFieldType type = new CBitFieldType(CNumericTypes.INT, 3);
        Truth.assertThat((Object)type.getType()).isEqualTo((Object)CNumericTypes.INT);
        Truth.assertThat((Integer)type.getBitFieldSize()).isEqualTo((Object)3);
    }

    @Test
    public void testBaseTypeEnum() {
        new CBitFieldType(new CEnumType(false, false, (List<CEnumType.CEnumerator>)ImmutableList.of(), "DummyEnum", "DummyEnum"), 0);
    }

    @Test
    public void testBaseTypeElaborateEnum() {
        new CBitFieldType(new CElaboratedType(false, false, CComplexType.ComplexTypeKind.ENUM, "DummyElaborateEnum", "DummyElaborateEnum", null), 0);
    }
}

