/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public final class CCompositeType
implements CComplexType {
    private static final long serialVersionUID = -839957929135012583L;
    private final CComplexType.ComplexTypeKind kind;
    private @Nullable List<CCompositeTypeMemberDeclaration> members = null;
    private final String name;
    private final String origName;
    private final boolean isConst;
    private final boolean isVolatile;

    public CCompositeType(boolean pConst, boolean pVolatile, CComplexType.ComplexTypeKind pKind, String pName, String pOrigName) {
        Preconditions.checkNotNull((Object)((Object)pKind));
        Preconditions.checkArgument((pKind == CComplexType.ComplexTypeKind.STRUCT || pKind == CComplexType.ComplexTypeKind.UNION ? 1 : 0) != 0);
        this.isConst = pConst;
        this.isVolatile = pVolatile;
        this.kind = pKind;
        this.name = pName.intern();
        this.origName = pOrigName.intern();
    }

    public CCompositeType(boolean pConst, boolean pVolatile, CComplexType.ComplexTypeKind pKind, List<CCompositeTypeMemberDeclaration> pMembers, String pName, String pOrigName) {
        this(pConst, pVolatile, pKind, pName, pOrigName);
        this.checkMembers(pMembers);
        this.members = ImmutableList.copyOf(pMembers);
    }

    private void checkMembers(List<CCompositeTypeMemberDeclaration> pMembers) {
        Iterator<CCompositeTypeMemberDeclaration> it = pMembers.iterator();
        while (it.hasNext()) {
            CCompositeTypeMemberDeclaration member = it.next();
            if (!member.getType().isIncomplete()) continue;
            Preconditions.checkArgument((this.kind == CComplexType.ComplexTypeKind.STRUCT ? 1 : 0) != 0, (String)"incomplete member %s in %s", (Object)member, (Object)this);
            Preconditions.checkArgument((!it.hasNext() ? 1 : 0) != 0, (String)"incomplete member %s in non-last position of %s", (Object)member, (Object)this);
            Preconditions.checkArgument((boolean)(member.getType().getCanonicalType() instanceof CArrayType), (String)"incomplete non-array member %s in last position of %s", (Object)member, (Object)this);
        }
    }

    @Override
    public CComplexType.ComplexTypeKind getKind() {
        return this.kind;
    }

    public List<CCompositeTypeMemberDeclaration> getMembers() {
        Preconditions.checkState((this.members != null ? 1 : 0) != 0, (Object)"list of CCompositeType members not yet initialized");
        return this.members;
    }

    public void setMembers(List<CCompositeTypeMemberDeclaration> list) {
        Preconditions.checkState((this.members == null ? 1 : 0) != 0, (Object)"list of CCompositeType members already initialized");
        this.checkMembers(list);
        this.members = ImmutableList.copyOf(list);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return (this.kind.toASTString() + " " + this.name).trim();
    }

    @Override
    public String getOrigName() {
        return this.origName;
    }

    @Override
    public boolean isIncomplete() {
        return false;
    }

    @Override
    public boolean hasKnownConstantSize() {
        Iterator<CCompositeTypeMemberDeclaration> it = this.getMembers().iterator();
        while (it.hasNext()) {
            CCompositeTypeMemberDeclaration member = it.next();
            if (member.getType().hasKnownConstantSize() || !it.hasNext() && CCompositeType.isFlexibleArray(member.getType())) continue;
            return false;
        }
        return true;
    }

    private static boolean isFlexibleArray(CType type) {
        return (type = type.getCanonicalType()) instanceof CArrayType && ((CArrayType)type).getLength() == null;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isConst()) {
            result.append("const ");
        }
        if (this.isVolatile()) {
            result.append("volatile ");
        }
        result.append(this.kind.toASTString());
        result.append(' ');
        result.append(this.name);
        return result.toString();
    }

    @Override
    public String toASTString(String pDeclarator) {
        Preconditions.checkNotNull((Object)pDeclarator);
        StringBuilder lASTString = new StringBuilder();
        if (this.isConst()) {
            lASTString.append("const ");
        }
        if (this.isVolatile()) {
            lASTString.append("volatile ");
        }
        lASTString.append(this.kind.toASTString());
        lASTString.append(' ');
        lASTString.append(this.name);
        if (this.members == null) {
            lASTString.append("/* missing member initialization */ ");
        } else {
            lASTString.append(" {\n");
            for (CCompositeTypeMemberDeclaration lMember : this.members) {
                lASTString.append("  ");
                lASTString.append(lMember.toASTString());
                lASTString.append("\n");
            }
            lASTString.append("} ");
        }
        lASTString.append(pDeclarator);
        return lASTString.toString();
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.isConst, this.isVolatile, this.kind, this.name});
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CCompositeType)) {
            return false;
        }
        CCompositeType other = (CCompositeType)obj;
        return this.isConst == other.isConst && this.isVolatile == other.isVolatile && this.kind == other.kind && Objects.equals(this.name, other.name);
    }

    @Override
    public boolean equalsWithOrigName(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CCompositeType)) {
            return false;
        }
        CCompositeType other = (CCompositeType)obj;
        return this.isConst == other.isConst && this.isVolatile == other.isVolatile && this.kind == other.kind && (Objects.equals(this.name, other.name) || this.origName.isEmpty() && other.origName.isEmpty());
    }

    @Override
    public CCompositeType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CCompositeType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        if (this.isConst == pForceConst && this.isVolatile == pForceVolatile) {
            return this;
        }
        CCompositeType result = new CCompositeType(this.isConst || pForceConst, this.isVolatile || pForceVolatile, this.kind, this.name, this.origName);
        if (this.members != null) {
            result.setMembers(this.members);
        }
        return result;
    }

    public static final class CCompositeTypeMemberDeclaration
    implements Serializable {
        private static final long serialVersionUID = 8647666228796784933L;
        private final CType type;
        private final String name;

        public CCompositeTypeMemberDeclaration(CType pType, String pName) {
            this.type = (CType)Preconditions.checkNotNull((Object)pType);
            this.name = pName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 7;
            result = 31 * result + Objects.hashCode(this.name);
            result = 31 * result + Objects.hashCode(this.type);
            return result;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CCompositeTypeMemberDeclaration other = (CCompositeTypeMemberDeclaration)obj;
            return Objects.equals(this.name, other.name) && this.type.getCanonicalType().equals(other.type.getCanonicalType());
        }

        public CType getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public String toASTString() {
            return this.getType().toASTString(Strings.nullToEmpty((String)this.getName())) + ";";
        }

        public String toString() {
            return this.toASTString();
        }
    }
}

