/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public final class CElaboratedType
implements CComplexType {
    private static final long serialVersionUID = -3566628634889842927L;
    private final CComplexType.ComplexTypeKind kind;
    private String name;
    private final String origName;
    private final boolean isConst;
    private final boolean isVolatile;
    private int hashCache = 0;
    private @Nullable CComplexType realType = null;

    public CElaboratedType(boolean pConst, boolean pVolatile, CComplexType.ComplexTypeKind pKind, String pName, String pOrigName, @Nullable CComplexType pRealType) {
        this.isConst = pConst;
        this.isVolatile = pVolatile;
        this.kind = (CComplexType.ComplexTypeKind)((Object)Preconditions.checkNotNull((Object)((Object)pKind)));
        this.name = pName.intern();
        this.origName = pOrigName.intern();
        this.realType = pRealType;
    }

    @Override
    public String getName() {
        if (this.realType != null) {
            return this.realType.getName();
        }
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return (this.kind.toASTString() + " " + this.name).trim();
    }

    @Override
    public String getOrigName() {
        if (this.realType != null) {
            return this.realType.getOrigName();
        }
        return this.origName;
    }

    @Override
    public CComplexType.ComplexTypeKind getKind() {
        return this.kind;
    }

    public @Nullable CComplexType getRealType() {
        if (this.realType instanceof CElaboratedType) {
            return ((CElaboratedType)this.realType).getRealType();
        }
        return this.realType;
    }

    public void setRealType(CComplexType pRealType) {
        Preconditions.checkState((this.getRealType() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)pRealType);
        Preconditions.checkArgument((pRealType != this ? 1 : 0) != 0);
        Preconditions.checkArgument((pRealType.getKind() == this.kind ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)this.name.contains(pRealType.getName()));
        this.realType = pRealType;
        this.name = this.realType.getName();
    }

    @Override
    public String toASTString(String pDeclarator) {
        Preconditions.checkNotNull((Object)pDeclarator);
        StringBuilder lASTString = new StringBuilder();
        if (this.isConst()) {
            lASTString.append("const ");
        }
        if (this.isVolatile()) {
            lASTString.append("volatile ");
        }
        lASTString.append(this.kind.toASTString());
        lASTString.append(" ");
        lASTString.append(this.name);
        lASTString.append(" ");
        lASTString.append(pDeclarator);
        return lASTString.toString();
    }

    @Override
    public String toString() {
        return this.getKind().toASTString() + " " + this.getName();
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public boolean isIncomplete() {
        if (this.realType == null) {
            return this.kind != CComplexType.ComplexTypeKind.ENUM;
        }
        return this.realType.isIncomplete();
    }

    @Override
    public boolean hasKnownConstantSize() {
        if (this.realType == null) {
            return this.kind == CComplexType.ComplexTypeKind.ENUM;
        }
        return this.realType.hasKnownConstantSize();
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = Objects.hash(new Object[]{this.isConst, this.isVolatile, this.kind, this.name, this.realType});
        }
        return this.hashCache;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CElaboratedType)) {
            return false;
        }
        CElaboratedType other = (CElaboratedType)obj;
        return this.isConst == other.isConst && this.isVolatile == other.isVolatile && this.kind == other.kind && Objects.equals(this.name, other.name) && Objects.equals(this.realType, other.realType);
    }

    @Override
    public boolean equalsWithOrigName(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CElaboratedType)) {
            return false;
        }
        CElaboratedType other = (CElaboratedType)obj;
        return this.isConst == other.isConst && this.isVolatile == other.isVolatile && this.kind == other.kind && (Objects.equals(this.name, other.name) || this.origName.isEmpty() && other.origName.isEmpty()) && Objects.equals(this.realType, other.realType);
    }

    @Override
    public CType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        if (this.realType == null) {
            if (this.isConst == pForceConst && this.isVolatile == pForceVolatile) {
                return this;
            }
            return new CElaboratedType(this.isConst || pForceConst, this.isVolatile || pForceVolatile, this.kind, this.name, this.origName, null);
        }
        return this.realType.getCanonicalType(this.isConst || pForceConst, this.isVolatile || pForceVolatile);
    }
}

