/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.AFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

public class CFunctionType
extends AFunctionType
implements CType {
    private static final long serialVersionUID = 4154771254170820716L;
    public static final CFunctionType NO_ARGS_VOID_FUNCTION = CFunctionType.functionTypeWithReturnType(CVoidType.VOID);
    private @Nullable String name = null;

    public static CFunctionType functionTypeWithReturnType(CType pReturnType) {
        return new CFunctionType((CType)Preconditions.checkNotNull((Object)pReturnType), (List<CType>)ImmutableList.of(), false);
    }

    public CFunctionType(CType pReturnType, List<CType> pParameters, boolean pTakesVarArgs) {
        super(pReturnType, pParameters, pTakesVarArgs);
    }

    @Override
    public CType getReturnType() {
        return (CType)super.getReturnType();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String pName) {
        Preconditions.checkState((this.name == null ? 1 : 0) != 0);
        this.name = (String)Preconditions.checkNotNull((Object)pName);
    }

    public List<CType> getParameters() {
        return super.getParameters();
    }

    @Override
    public String toASTString(String pDeclarator) {
        return this.toASTString(pDeclarator, Lists.transform(this.getParameters(), pInput -> pInput.toASTString("")));
    }

    String toASTString(String pDeclarator, Iterable<?> pParameters) {
        Preconditions.checkNotNull((Object)pDeclarator);
        StringBuilder lASTString = new StringBuilder();
        if (pDeclarator.startsWith("*")) {
            lASTString.append("(");
            lASTString.append(pDeclarator);
            lASTString.append(")");
        } else {
            lASTString.append(pDeclarator);
        }
        lASTString.append("(");
        Joiner.on((String)", ").appendTo(lASTString, pParameters);
        if (this.takesVarArgs()) {
            if (!this.getParameters().isEmpty()) {
                lASTString.append(", ");
            }
            lASTString.append("...");
        }
        lASTString.append(")");
        String nameAndParams = lASTString.toString();
        return this.getReturnType().toASTString(nameAndParams);
    }

    @Override
    public boolean isConst() {
        return false;
    }

    @Override
    public boolean isVolatile() {
        return false;
    }

    @Override
    public boolean isIncomplete() {
        return false;
    }

    @Override
    public boolean hasKnownConstantSize() {
        return true;
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof CFunctionType && super.equals(obj);
    }

    @Override
    public CFunctionType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CFunctionType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        ImmutableList.Builder newParameterTypes = ImmutableList.builder();
        for (CType parameter : this.getParameters()) {
            newParameterTypes.add((Object)parameter.getCanonicalType());
        }
        return new CFunctionType(this.getReturnType().getCanonicalType(), (List<CType>)newParameterTypes.build(), this.takesVarArgs());
    }
}

