/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public final class CFunctionTypeWithNames
extends CFunctionType
implements CType {
    private static final long serialVersionUID = -3585082910610497708L;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="writeReplace() takes care of this")
    private final List<CParameterDeclaration> parameters;

    public CFunctionTypeWithNames(CType pReturnType, List<CParameterDeclaration> pParameters, boolean pTakesVarArgs) {
        super(pReturnType, (List<CType>)Collections3.transformedImmutableListCopy(pParameters, CParameterDeclaration::getType), pTakesVarArgs);
        this.parameters = ImmutableList.copyOf(pParameters);
    }

    public List<CParameterDeclaration> getParameterDeclarations() {
        return this.parameters;
    }

    @Override
    public String toString() {
        return this.toASTString(Strings.nullToEmpty((String)this.getName()), this.getParameterDeclarations());
    }

    @Override
    public String toASTString(String pDeclarator) {
        return this.toASTString(pDeclarator, this.getParameterDeclarations());
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.parameters) * 31 + super.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CFunctionTypeWithNames) || !super.equals(obj)) {
            return false;
        }
        CFunctionTypeWithNames other = (CFunctionTypeWithNames)obj;
        return Objects.equals(this.parameters, other.parameters);
    }

    private Object writeReplace() {
        return new CFunctionType(this.getReturnType(), this.getParameters(), this.takesVarArgs());
    }
}

