/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

public final class CPointerType
implements CType,
Serializable {
    private static final long serialVersionUID = -6423006826454509009L;
    public static final CPointerType POINTER_TO_VOID = new CPointerType(false, false, CVoidType.VOID);
    public static final CPointerType POINTER_TO_CHAR = new CPointerType(false, false, CNumericTypes.CHAR);
    public static final CPointerType POINTER_TO_CONST_CHAR = new CPointerType(false, false, CNumericTypes.CHAR.getCanonicalType(true, false));
    private final CType type;
    private final boolean isConst;
    private final boolean isVolatile;

    public CPointerType(boolean pConst, boolean pVolatile, CType pType) {
        this.isConst = pConst;
        this.isVolatile = pVolatile;
        this.type = (CType)Preconditions.checkNotNull((Object)pType);
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    public CType getType() {
        return this.type;
    }

    @Override
    public boolean isIncomplete() {
        return false;
    }

    @Override
    public boolean hasKnownConstantSize() {
        return true;
    }

    @Override
    public String toString() {
        String decl = "(" + this.type + ")*";
        return (this.isConst() ? "const " : "") + (this.isVolatile() ? "volatile " : "") + decl;
    }

    @Override
    public String toASTString(String pDeclarator) {
        Preconditions.checkNotNull((Object)pDeclarator);
        StringBuilder inner = new StringBuilder("*");
        if (this.isConst()) {
            inner.append(" const");
        }
        if (this.isVolatile()) {
            inner.append(" volatile");
        }
        if (inner.length() > 1) {
            inner.append(' ');
        }
        inner.append(pDeclarator);
        if (this.type instanceof CArrayType) {
            return this.type.toASTString("(" + inner + ")");
        }
        return this.type.toASTString(inner.toString());
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.isConst, this.isVolatile, this.type);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CPointerType)) {
            return false;
        }
        CPointerType other = (CPointerType)obj;
        return this.isConst == other.isConst && this.isVolatile == other.isVolatile && Objects.equals(this.type, other.type);
    }

    @Override
    public CPointerType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CPointerType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        return new CPointerType(this.isConst || pForceConst, this.isVolatile || pForceVolatile, this.type.getCanonicalType());
    }
}

