/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.errorprone.annotations.Immutable;
import com.google.errorprone.annotations.concurrent.LazyInit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

@Immutable
public final class CSimpleType
implements CType,
Serializable {
    private static final long serialVersionUID = -8279630814725098867L;
    private final CBasicType type;
    private final boolean isLong;
    private final boolean isShort;
    private final boolean isSigned;
    private final boolean isUnsigned;
    private final boolean isComplex;
    private final boolean isImaginary;
    private final boolean isLongLong;
    private final boolean isConst;
    private final boolean isVolatile;
    @LazyInit
    private int hashCache = 0;

    public CSimpleType(boolean pConst, boolean pVolatile, CBasicType pType, boolean pIsLong, boolean pIsShort, boolean pIsSigned, boolean pIsUnsigned, boolean pIsComplex, boolean pIsImaginary, boolean pIsLongLong) {
        this.isConst = pConst;
        this.isVolatile = pVolatile;
        this.type = (CBasicType)((Object)Preconditions.checkNotNull((Object)((Object)pType)));
        this.isLong = pIsLong;
        this.isShort = pIsShort;
        this.isSigned = pIsSigned;
        this.isUnsigned = pIsUnsigned;
        this.isComplex = pIsComplex;
        this.isImaginary = pIsImaginary;
        this.isLongLong = pIsLongLong;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    public CBasicType getType() {
        return this.type;
    }

    public boolean isLong() {
        return this.isLong;
    }

    public boolean isShort() {
        return this.isShort;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public boolean isImaginary() {
        return this.isImaginary;
    }

    public boolean isLongLong() {
        return this.isLongLong;
    }

    @Override
    public boolean isIncomplete() {
        return false;
    }

    @Override
    public boolean hasKnownConstantSize() {
        return true;
    }

    @Override
    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = Objects.hash(new Object[]{this.isComplex, this.isConst, this.isVolatile, this.isImaginary, this.isLong, this.isLongLong, this.isShort, this.isSigned, this.isUnsigned, this.type});
        }
        return this.hashCache;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CSimpleType)) {
            return false;
        }
        CSimpleType other = (CSimpleType)obj;
        return this.isComplex == other.isComplex && this.isConst == other.isConst && this.isVolatile == other.isVolatile && this.isImaginary == other.isImaginary && this.isLong == other.isLong && this.isLongLong == other.isLongLong && this.isShort == other.isShort && this.isSigned == other.isSigned && this.isUnsigned == other.isUnsigned && this.type == other.type;
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public String toString() {
        return this.toASTString("");
    }

    @Override
    public String toASTString(String pDeclarator) {
        Preconditions.checkNotNull((Object)pDeclarator);
        ArrayList<String> parts = new ArrayList<String>();
        if (this.isConst()) {
            parts.add("const");
        }
        if (this.isVolatile()) {
            parts.add("volatile");
        }
        if (this.isUnsigned) {
            parts.add("unsigned");
        } else if (this.isSigned) {
            parts.add("signed");
        }
        if (this.isLongLong) {
            parts.add("long long");
        } else if (this.isLong) {
            parts.add("long");
        } else if (this.isShort) {
            parts.add("short");
        }
        if (this.isImaginary) {
            parts.add("_Imaginary");
        }
        if (this.isComplex) {
            parts.add("_Complex");
        }
        parts.add(Strings.emptyToNull((String)this.type.toASTString()));
        parts.add(Strings.emptyToNull((String)pDeclarator));
        return Joiner.on((char)' ').skipNulls().join(parts);
    }

    @Override
    public CSimpleType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CSimpleType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        CBasicType newType = this.type;
        if (newType == CBasicType.UNSPECIFIED) {
            newType = CBasicType.INT;
        }
        boolean newIsSigned = this.isSigned;
        if (!(newType != CBasicType.INT && newType != CBasicType.INT128 || this.isSigned || this.isUnsigned)) {
            newIsSigned = true;
        }
        if (this.isConst == pForceConst && this.isVolatile == pForceVolatile && this.type == newType && this.isSigned == newIsSigned) {
            return this;
        }
        return new CSimpleType(this.isConst || pForceConst, this.isVolatile || pForceVolatile, newType, this.isLong, this.isShort, newIsSigned, this.isUnsigned, this.isComplex, this.isImaginary, this.isLongLong);
    }
}

