/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.Type;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

public interface CType
extends Type {
    public boolean isConst();

    public String toString();

    public boolean isVolatile();

    public boolean isIncomplete();

    public boolean hasKnownConstantSize();

    public int hashCode();

    public boolean equals(@Nullable Object var1);

    public <R, X extends Exception> R accept(CTypeVisitor<R, X> var1) throws X;

    public CType getCanonicalType();

    public CType getCanonicalType(boolean var1, boolean var2);

    default public boolean canBeAssignedFrom(CType pType) {
        CType leftHandSide = this.getCanonicalType();
        CType rightHandSide = pType.getCanonicalType();
        if (CTypes.isArithmeticType(leftHandSide)) {
            if (CTypes.isArithmeticType(rightHandSide)) {
                return true;
            }
            if (leftHandSide instanceof CSimpleType && ((CSimpleType)leftHandSide).getType().equals((Object)CBasicType.BOOL) && rightHandSide instanceof CPointerType) {
                return true;
            }
        }
        if (leftHandSide instanceof CCompositeType && rightHandSide instanceof CCompositeType) {
            CType plainCompositeLeft = CTypes.copyDequalified(leftHandSide);
            CType plainCompositeRight = CTypes.copyDequalified(rightHandSide);
            return CTypes.areTypesCompatible(plainCompositeLeft, plainCompositeRight);
        }
        if (leftHandSide instanceof CPointerType && ((CPointerType)leftHandSide).getType() instanceof CVoidType && (rightHandSide.isIncomplete() || CTypes.isObjectType(rightHandSide))) {
            return true;
        }
        if (rightHandSide instanceof CPointerType && leftHandSide instanceof CPointerType) {
            CPointerType pointerLeft = (CPointerType)leftHandSide;
            CPointerType pointerRight = (CPointerType)rightHandSide;
            CType leftPointedToType = pointerLeft.getType();
            CType rightPointedToType = pointerRight.getType();
            if (leftPointedToType instanceof CProblemType || rightPointedToType instanceof CProblemType) {
                return true;
            }
            return !(!leftPointedToType.isConst() && rightPointedToType.isConst() || !leftPointedToType.isVolatile() && rightPointedToType.isVolatile() || !(leftPointedToType instanceof CVoidType) && !(rightPointedToType instanceof CVoidType) && !CTypes.areTypesCompatible(CTypes.copyDequalified(leftPointedToType), CTypes.copyDequalified(rightPointedToType)));
        }
        if (leftHandSide instanceof CPointerType && rightHandSide instanceof CArrayType) {
            CPointerType pointerLeft = (CPointerType)leftHandSide;
            CArrayType arrayRight = (CArrayType)rightHandSide;
            return CTypes.areTypesCompatible(pointerLeft.getType(), arrayRight.getType());
        }
        return false;
    }
}

