/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.file.Path;
import java.util.List;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.parser.Parsers;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.exceptions.CParserException;

@RunWith(value=Parameterized.class)
@SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="Fields are filled by parameterization of JUnit")
public class CTypeToStringTest {
    private static final String VAR = "var";
    private static final CType CONST_VOLATILE_INT = new CSimpleType(true, true, CBasicType.INT, false, false, false, false, false, false, false);
    @Parameterized.Parameter(value=0)
    public String stringRepr;
    @Parameterized.Parameter(value=1)
    public CType type;
    private static CParser parser;

    @Parameterized.Parameters(name="{0} [{1}]")
    public static Object[][] types() {
        return new Object[][]{{"int *var", new CPointerType(false, false, CNumericTypes.INT)}, {"int * const volatile var", new CPointerType(true, true, CNumericTypes.INT)}, {"const volatile int *var", new CPointerType(false, false, CONST_VOLATILE_INT)}, {"const volatile int * const volatile var", new CPointerType(true, true, CONST_VOLATILE_INT)}, {"int var[1]", new CArrayType(false, false, CNumericTypes.INT, CIntegerLiteralExpression.ONE)}, {"const volatile int var[1]", new CArrayType(true, true, CNumericTypes.INT, CIntegerLiteralExpression.ONE)}, {"const volatile int var[1]", new CArrayType(false, false, CONST_VOLATILE_INT, CIntegerLiteralExpression.ONE)}, {"const volatile const volatile int var[1]", new CArrayType(true, true, CONST_VOLATILE_INT, CIntegerLiteralExpression.ONE)}, {"int *var[1]", new CArrayType(false, false, new CPointerType(false, false, CNumericTypes.INT), CIntegerLiteralExpression.ONE)}, {"int * const volatile var[1]", new CArrayType(false, false, new CPointerType(true, true, CNumericTypes.INT), CIntegerLiteralExpression.ONE)}, {"const volatile int *var[1]", new CArrayType(false, false, new CPointerType(false, false, CONST_VOLATILE_INT), CIntegerLiteralExpression.ONE)}, {"const volatile int * const volatile var[1]", new CArrayType(false, false, new CPointerType(true, true, CONST_VOLATILE_INT), CIntegerLiteralExpression.ONE)}, {"int (*var)[1]", new CPointerType(false, false, new CArrayType(false, false, CNumericTypes.INT, CIntegerLiteralExpression.ONE))}, {"int (* const volatile var)[1]", new CPointerType(true, true, new CArrayType(false, false, CNumericTypes.INT, CIntegerLiteralExpression.ONE))}, {"const volatile int (*var)[1]", new CPointerType(false, false, new CArrayType(false, false, CONST_VOLATILE_INT, CIntegerLiteralExpression.ONE))}, {"const volatile int (* const volatile var)[1]", new CPointerType(true, true, new CArrayType(false, false, CONST_VOLATILE_INT, CIntegerLiteralExpression.ONE))}, {"double *var(int)", new CFunctionType(new CPointerType(false, false, CNumericTypes.DOUBLE), (List<CType>)ImmutableList.of((Object)CNumericTypes.INT), false)}, {"double * const volatile var(int)", new CFunctionType(new CPointerType(true, true, CNumericTypes.DOUBLE), (List<CType>)ImmutableList.of((Object)CNumericTypes.INT), false)}, {"double *var(int)", new CFunctionType(new CPointerType(false, false, CNumericTypes.DOUBLE), (List<CType>)ImmutableList.of((Object)CNumericTypes.INT), false)}, {"void (*var(int))(double)", new CFunctionType(new CPointerType(false, false, new CFunctionType(CVoidType.VOID, (List<CType>)ImmutableList.of((Object)CNumericTypes.DOUBLE), false)), (List<CType>)ImmutableList.of((Object)CNumericTypes.INT), false)}, {"void (* const volatile var(int))(double)", new CFunctionType(new CPointerType(true, true, new CFunctionType(CVoidType.VOID, (List<CType>)ImmutableList.of((Object)CNumericTypes.DOUBLE), false)), (List<CType>)ImmutableList.of((Object)CNumericTypes.INT), false)}, {"char *(*var(int))(double)", new CFunctionType(new CPointerType(false, false, new CFunctionType(new CPointerType(false, false, CNumericTypes.CHAR), (List<CType>)ImmutableList.of((Object)CNumericTypes.DOUBLE), false)), (List<CType>)ImmutableList.of((Object)CNumericTypes.INT), false)}};
    }

    @BeforeClass
    public static void setupParser() {
        parser = Parsers.getCParser(LogManager.createTestLogManager(), new Parsers.EclipseCParserOptions(), MachineModel.LINUX32, ShutdownNotifier.createDummy());
    }

    @Test
    public void testToString() {
        Truth.assertThat((String)this.type.toASTString(VAR)).isEqualTo((Object)this.stringRepr);
    }

    @Test
    public void testParse() throws CParserException, InterruptedException {
        CType parsed = (CType)parser.parseString(Path.of("dummy", new String[0]), this.stringRepr + ";").getGlobalDeclarations().get(0).getFirst().getType();
        Truth.assertThat((Object)parsed.getCanonicalType()).isEqualTo((Object)this.type.getCanonicalType());
    }
}

