/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;

public final class CTypedefType
implements CType,
Serializable {
    private static final long serialVersionUID = -3461236537115147688L;
    private final String name;
    private final CType realType;
    private final boolean isConst;
    private final boolean isVolatile;
    private int hashCache = 0;

    public CTypedefType(boolean pConst, boolean pVolatile, String pName, CType pRealType) {
        this.isConst = pConst;
        this.isVolatile = pVolatile;
        this.name = pName.intern();
        this.realType = (CType)Preconditions.checkNotNull((Object)pRealType);
    }

    public String getName() {
        return this.name;
    }

    public CType getRealType() {
        return this.realType;
    }

    @Override
    public String toString() {
        return this.toASTString("");
    }

    @Override
    public String toASTString(String pDeclarator) {
        Preconditions.checkNotNull((Object)pDeclarator);
        return (this.isConst() ? "const " : "") + (this.isVolatile() ? "volatile " : "") + this.name + " " + pDeclarator;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public boolean isIncomplete() {
        return this.realType.isIncomplete();
    }

    @Override
    public boolean hasKnownConstantSize() {
        return this.realType.hasKnownConstantSize();
    }

    @Override
    public <R, X extends Exception> R accept(CTypeVisitor<R, X> pVisitor) throws X {
        return pVisitor.visit(this);
    }

    @Override
    public int hashCode() {
        if (this.hashCache == 0) {
            this.hashCache = Objects.hash(this.name, this.isConst, this.isVolatile, this.realType);
        }
        return this.hashCache;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CTypedefType)) {
            return false;
        }
        CTypedefType other = (CTypedefType)obj;
        return Objects.equals(this.name, other.name) && this.isConst == other.isConst && this.isVolatile == other.isVolatile && Objects.equals(this.realType, other.realType);
    }

    @Override
    public CType getCanonicalType() {
        return this.getCanonicalType(false, false);
    }

    @Override
    public CType getCanonicalType(boolean pForceConst, boolean pForceVolatile) {
        return this.realType.getCanonicalType(this.isConst || pForceConst, this.isVolatile || pForceVolatile);
    }
}

