/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CBitFieldType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypeVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.exceptions.NoException;

public final class CTypes {
    private CTypes() {
    }

    public static boolean isCharacterType(CType type) {
        return (type = type.getCanonicalType()) instanceof CSimpleType && ((CSimpleType)type).getType() == CBasicType.CHAR;
    }

    public static boolean isRealType(CType type) {
        return (type = type.getCanonicalType()) instanceof CEnumType || type instanceof CBitFieldType || type instanceof CSimpleType && !((CSimpleType)type).isComplex();
    }

    public static boolean isIntegerType(CType type) {
        return (type = type.getCanonicalType()) instanceof CEnumType || type instanceof CBitFieldType || type instanceof CSimpleType && ((CSimpleType)type).getType().isIntegerType();
    }

    public static boolean isSignedIntegerType(CType type) {
        return (type = type.getCanonicalType()) instanceof CBitFieldType && CTypes.isSignedIntegerType(((CBitFieldType)type).getType()) || type instanceof CSimpleType && ((CSimpleType)type).getType().isIntegerType() && ((CSimpleType)type).isSigned();
    }

    public static boolean isArithmeticType(CType type) {
        return (type = type.getCanonicalType()) instanceof CEnumType || type instanceof CBitFieldType || type instanceof CSimpleType || type instanceof CComplexType && ((CComplexType)type).getKind() == CComplexType.ComplexTypeKind.ENUM;
    }

    public static boolean isScalarType(CType type) {
        return (type = type.getCanonicalType()) instanceof CPointerType || CTypes.isArithmeticType(type);
    }

    public static boolean isAggregateType(CType type) {
        return (type = type.getCanonicalType()) instanceof CArrayType || type instanceof CCompositeType && ((CCompositeType)type).getKind() == CComplexType.ComplexTypeKind.STRUCT;
    }

    public static boolean isObjectType(CType type) {
        return !((type = type.getCanonicalType()) instanceof CFunctionType);
    }

    public static boolean isFunctionPointer(CType type) {
        CType innerType;
        return (type = type.getCanonicalType()) instanceof CPointerType && (innerType = ((CPointerType)type).getType()) instanceof CFunctionType;
    }

    public static Equivalence<CType> canonicalTypeEquivalence() {
        return CanonicalCTypeEquivalence.INSTANCE;
    }

    public static <T extends CType> T withoutConst(T type) {
        if (type instanceof CProblemType) {
            return type;
        }
        if (!type.isConst()) {
            return type;
        }
        CType result = type.accept(ForceConstVisitor.FALSE);
        return (T)result;
    }

    public static <T extends CType> T withConst(T type) {
        if (type instanceof CProblemType) {
            return type;
        }
        if (type.isConst()) {
            return type;
        }
        CType result = type.accept(ForceConstVisitor.TRUE);
        return (T)result;
    }

    public static <T extends CType> T withoutVolatile(T type) {
        if (type instanceof CProblemType) {
            return type;
        }
        if (!type.isVolatile()) {
            return type;
        }
        CType result = type.accept(ForceVolatileVisitor.FALSE);
        return (T)result;
    }

    public static <T extends CType> T withVolatile(T type) {
        if (type instanceof CProblemType) {
            return type;
        }
        if (type.isVolatile()) {
            return type;
        }
        CType result = type.accept(ForceVolatileVisitor.TRUE);
        return (T)result;
    }

    public static boolean areTypesCompatible(CType pTypeA, CType pTypeB) {
        if (CTypes.canonicalTypeEquivalence().equivalent((Object)pTypeA, (Object)pTypeB)) {
            return true;
        }
        if (pTypeA.isConst() != pTypeB.isConst() || pTypeA.isVolatile() != pTypeB.isVolatile()) {
            return false;
        }
        if (pTypeA instanceof CPointerType && pTypeB instanceof CPointerType) {
            CPointerType pointerA = (CPointerType)pTypeA;
            CPointerType pointerB = (CPointerType)pTypeB;
            return CTypes.areTypesCompatible(pointerA.getType(), pointerB.getType());
        }
        CSimpleType basicSignedInt = CNumericTypes.INT.getCanonicalType(pTypeA.isConst(), pTypeA.isVolatile());
        if (pTypeA instanceof CEnumType && pTypeB instanceof CSimpleType) {
            return pTypeB.getCanonicalType().equals(basicSignedInt.getCanonicalType());
        }
        if (pTypeA instanceof CSimpleType && pTypeB instanceof CEnumType) {
            return pTypeA.getCanonicalType().equals(basicSignedInt.getCanonicalType());
        }
        if (pTypeA instanceof CArrayType && pTypeB instanceof CArrayType) {
            CArrayType arrayA = (CArrayType)pTypeA;
            CArrayType arrayB = (CArrayType)pTypeB;
            if (CTypes.areTypesCompatible(arrayA.getType(), arrayB.getType())) {
                OptionalInt lengthA = arrayA.getLengthAsInt();
                OptionalInt lengthB = arrayB.getLengthAsInt();
                if (lengthA.isPresent() && lengthB.isPresent()) {
                    if (lengthA.orElseThrow() == lengthB.orElseThrow()) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        if (pTypeA instanceof CFunctionType && pTypeB instanceof CFunctionType) {
            CFunctionType functionA = (CFunctionType)pTypeA;
            CFunctionType functionB = (CFunctionType)pTypeB;
            if (!CTypes.areTypesCompatible(functionA.getReturnType(), functionB.getReturnType())) {
                return false;
            }
            List<CType> paramsA = functionA.getParameters();
            List<CType> paramsB = functionB.getParameters();
            if (paramsA.size() != paramsB.size() || functionA.takesVarArgs() != functionB.takesVarArgs()) {
                return false;
            }
            Iterator<CType> iteratorA = paramsA.iterator();
            Iterator<CType> iteratorB = paramsB.iterator();
            while (iteratorA.hasNext() && iteratorB.hasNext()) {
                CType paramOfA = iteratorA.next();
                CType paramOfB = iteratorB.next();
                if (paramOfA instanceof CPointerType && !(paramOfB instanceof CPointerType)) {
                    paramOfB = CTypes.adjustFunctionOrArrayType(paramOfB);
                } else if (paramOfB instanceof CPointerType) {
                    paramOfA = CTypes.adjustFunctionOrArrayType(paramOfA);
                }
                if (CTypes.areTypesCompatible(paramOfA = CTypes.copyDequalified(paramOfA), paramOfB = CTypes.copyDequalified(paramOfB))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static @Nullable CType adjustFunctionOrArrayType(@Nullable CType pType) {
        if (pType == null) {
            return pType;
        }
        if (pType instanceof CArrayType) {
            CType innerType = ((CArrayType)pType).getType();
            CExpression sizeExpression = ((CArrayType)pType).getLength();
            if (sizeExpression == null) {
                pType = new CPointerType(false, false, innerType);
            } else {
                CType sizeType = sizeExpression.getExpressionType();
                pType = new CPointerType(sizeType.isConst(), sizeType.isVolatile(), innerType);
            }
        } else if (pType instanceof CFunctionType) {
            pType = new CPointerType(pType.isConst(), pType.isVolatile(), pType);
        }
        return pType;
    }

    public static CType copyDequalified(CType pType) {
        pType = CTypes.withoutConst(pType);
        pType = CTypes.withoutVolatile(pType);
        return pType;
    }

    private static enum ForceVolatileVisitor implements CTypeVisitor<CType, NoException>
    {
        FALSE(false),
        TRUE(true);

        private final boolean volatileValue;

        private ForceVolatileVisitor(boolean pVolatileValue) {
            this.volatileValue = pVolatileValue;
        }

        @Override
        public CArrayType visit(CArrayType t) {
            return new CArrayType(t.isConst(), this.volatileValue, t.getType(), t.getLength());
        }

        @Override
        public CCompositeType visit(CCompositeType t) {
            return new CCompositeType(t.isConst(), this.volatileValue, t.getKind(), t.getMembers(), t.getName(), t.getOrigName());
        }

        @Override
        public CElaboratedType visit(CElaboratedType t) {
            return new CElaboratedType(t.isConst(), this.volatileValue, t.getKind(), t.getName(), t.getOrigName(), t.getRealType());
        }

        @Override
        public CEnumType visit(CEnumType t) {
            return new CEnumType(t.isConst(), this.volatileValue, (List<CEnumType.CEnumerator>)t.getEnumerators(), t.getName(), t.getOrigName());
        }

        @Override
        public CFunctionType visit(CFunctionType t) {
            Preconditions.checkArgument((!this.volatileValue ? 1 : 0) != 0, (Object)"Cannot create const function type, this is undefined");
            return t;
        }

        @Override
        public CPointerType visit(CPointerType t) {
            return new CPointerType(t.isConst(), this.volatileValue, t.getType());
        }

        @Override
        public CProblemType visit(CProblemType t) {
            return t;
        }

        @Override
        public CSimpleType visit(CSimpleType t) {
            return new CSimpleType(t.isConst(), this.volatileValue, t.getType(), t.isLong(), t.isShort(), t.isSigned(), t.isUnsigned(), t.isComplex(), t.isImaginary(), t.isLongLong());
        }

        @Override
        public CTypedefType visit(CTypedefType t) {
            return new CTypedefType(t.isConst(), this.volatileValue, t.getName(), t.getRealType());
        }

        @Override
        public CType visit(CVoidType t) {
            return CVoidType.create(t.isConst(), this.volatileValue);
        }

        @Override
        public CType visit(CBitFieldType pCBitFieldType) {
            return new CBitFieldType(pCBitFieldType.getType().accept(this), pCBitFieldType.getBitFieldSize());
        }
    }

    private static enum ForceConstVisitor implements CTypeVisitor<CType, NoException>
    {
        FALSE(false),
        TRUE(true);

        private final boolean constValue;

        private ForceConstVisitor(boolean pConstValue) {
            this.constValue = pConstValue;
        }

        @Override
        public CArrayType visit(CArrayType t) {
            return new CArrayType(this.constValue, t.isVolatile(), t.getType(), t.getLength());
        }

        @Override
        public CCompositeType visit(CCompositeType t) {
            return new CCompositeType(this.constValue, t.isVolatile(), t.getKind(), t.getMembers(), t.getName(), t.getOrigName());
        }

        @Override
        public CElaboratedType visit(CElaboratedType t) {
            return new CElaboratedType(this.constValue, t.isVolatile(), t.getKind(), t.getName(), t.getOrigName(), t.getRealType());
        }

        @Override
        public CEnumType visit(CEnumType t) {
            return new CEnumType(this.constValue, t.isVolatile(), (List<CEnumType.CEnumerator>)t.getEnumerators(), t.getName(), t.getOrigName());
        }

        @Override
        public CFunctionType visit(CFunctionType t) {
            Preconditions.checkArgument((!this.constValue ? 1 : 0) != 0, (Object)"Cannot create const function type, this is undefined");
            return t;
        }

        @Override
        public CPointerType visit(CPointerType t) {
            return new CPointerType(this.constValue, t.isVolatile(), t.getType());
        }

        @Override
        public CProblemType visit(CProblemType t) {
            return t;
        }

        @Override
        public CSimpleType visit(CSimpleType t) {
            return new CSimpleType(this.constValue, t.isVolatile(), t.getType(), t.isLong(), t.isShort(), t.isSigned(), t.isUnsigned(), t.isComplex(), t.isImaginary(), t.isLongLong());
        }

        @Override
        public CTypedefType visit(CTypedefType t) {
            return new CTypedefType(this.constValue, t.isVolatile(), t.getName(), t.getRealType());
        }

        @Override
        public CType visit(CVoidType t) {
            return CVoidType.create(this.constValue, t.isVolatile());
        }

        @Override
        public CType visit(CBitFieldType pCBitFieldType) {
            return new CBitFieldType(pCBitFieldType.getType().accept(this), pCBitFieldType.getBitFieldSize());
        }
    }

    private static class CanonicalCTypeEquivalence
    extends Equivalence<CType> {
        private static final CanonicalCTypeEquivalence INSTANCE = new CanonicalCTypeEquivalence();

        private CanonicalCTypeEquivalence() {
        }

        protected boolean doEquivalent(CType pA, CType pB) {
            return pA.getCanonicalType().equals(pB.getCanonicalType());
        }

        protected int doHash(CType pT) {
            return pT.getCanonicalType().hashCode();
        }
    }
}

