/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.math.BigInteger;
import java.util.List;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CCompositeType;
import org.sosy_lab.cpachecker.cfa.types.c.CElaboratedType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CStorageClass;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;

@RunWith(value=Parameterized.class)
public class CTypesTest {
    private static final MachineModel TEST_MACHINE_MODEL = MachineModel.LINUX32;
    public static final CIntegerLiteralExpression TWO = CIntegerLiteralExpression.createDummyLiteral(2L, CNumericTypes.INT);
    private static final CIdExpression VAR_N = new CIdExpression(FileLocation.DUMMY, CNumericTypes.INT, "n", new CVariableDeclaration(FileLocation.DUMMY, true, CStorageClass.AUTO, CNumericTypes.INT, "n", "n", "n", null));
    private static final CIdExpression VAR_CONST = new CIdExpression(FileLocation.DUMMY, CTypes.withConst(CNumericTypes.INT), "c", new CVariableDeclaration(FileLocation.DUMMY, true, CStorageClass.AUTO, CTypes.withConst(CNumericTypes.INT), "c", "c", "c", new CInitializerExpression(FileLocation.DUMMY, TWO)));
    private static final CArrayType CONSTANT_ARRAY = new CArrayType(false, false, CNumericTypes.INT, TWO);
    private static final CArrayType VARIABLE_ARRAY = new CArrayType(false, false, CNumericTypes.INT, VAR_N);
    private static final CArrayType UNKNOWN_ARRAY = new CArrayType(false, false, CNumericTypes.INT, null);
    @Parameterized.Parameter(value=0)
    public CType type;
    @Parameterized.Parameter(value=1)
    public boolean isComplete;
    @Parameterized.Parameter(value=2)
    public boolean hasKnownConstantSize;
    @Parameterized.Parameter(value=3)
    public int size;

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> parameters() {
        CCompositeType simpleStruct = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, "simpleStruct", "simpleStruct");
        simpleStruct.setMembers((List<CCompositeType.CCompositeTypeMemberDeclaration>)ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "i")));
        CCompositeType arrayStruct = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, "arrayStruct", "arrayStruct");
        arrayStruct.setMembers((List<CCompositeType.CCompositeTypeMemberDeclaration>)ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(CONSTANT_ARRAY, "a")));
        CCompositeType flexibleArrayStruct = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, "flexibleArrayStruct", "flexibleArrayStruct");
        flexibleArrayStruct.setMembers((List<CCompositeType.CCompositeTypeMemberDeclaration>)ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "i"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(UNKNOWN_ARRAY, "a")));
        CCompositeType variableArrayStruct = new CCompositeType(false, false, CComplexType.ComplexTypeKind.STRUCT, "variableArrayStruct", "variableArrayStruct");
        variableArrayStruct.setMembers((List<CCompositeType.CCompositeTypeMemberDeclaration>)ImmutableList.of((Object)new CCompositeType.CCompositeTypeMemberDeclaration(CNumericTypes.INT, "i"), (Object)new CCompositeType.CCompositeTypeMemberDeclaration(VARIABLE_ARRAY, "a")));
        return ImmutableList.of((Object)new Object[]{CONSTANT_ARRAY, true, true, 8}, (Object)new Object[]{UNKNOWN_ARRAY, false, false, -1}, (Object)new Object[]{VARIABLE_ARRAY, true, false, -1}, (Object)new Object[]{new CArrayType(false, false, CNumericTypes.INT, VAR_CONST), true, false, -1}, (Object)new Object[]{new CArrayType(false, false, CONSTANT_ARRAY, TWO), true, true, 16}, (Object)new Object[]{new CArrayType(false, false, CONSTANT_ARRAY, null), false, false, -1}, (Object)new Object[]{new CArrayType(false, false, CONSTANT_ARRAY, VAR_N), true, false, -1}, (Object)new Object[]{new CArrayType(false, false, VARIABLE_ARRAY, TWO), true, false, -1}, (Object)new Object[]{new CElaboratedType(false, false, CComplexType.ComplexTypeKind.ENUM, "e", "e", null), true, true, 4}, (Object)new Object[]{new CElaboratedType(false, false, CComplexType.ComplexTypeKind.STRUCT, "s", "s", null), false, false, -1}, (Object)new Object[]{simpleStruct, true, true, 4}, (Object)new Object[]{arrayStruct, true, true, 8}, (Object[])new Object[][]{{flexibleArrayStruct, true, true, 4}, {variableArrayStruct, true, false, -1}, {CNumericTypes.CHAR, true, true, 1}, {CVoidType.VOID, false, true, 1}});
    }

    @Test
    public void testIsIncomplete() {
        Truth.assertWithMessage((String)"Result of isIncomplete() is wrong").that(Boolean.valueOf(this.type.isIncomplete())).isEqualTo((Object)(!this.isComplete ? 1 : 0));
    }

    @Test
    public void testHasKnownConstantSize() {
        Truth.assertWithMessage((String)"Result of hasKnownConstantSize() is wrong").that(Boolean.valueOf(this.type.hasKnownConstantSize())).isEqualTo((Object)this.hasKnownConstantSize);
    }

    @Test
    public void testConstantSizeof() {
        TruthJUnit.assume().that(Boolean.valueOf(this.hasKnownConstantSize)).isTrue();
        Truth.assertThat((Comparable)TEST_MACHINE_MODEL.getSizeof(this.type)).isEqualTo((Object)BigInteger.valueOf(this.size));
    }

    @Test
    @Ignore
    public void testSizeofShouldThrowIfNotConstant() {
        TruthJUnit.assume().that(Boolean.valueOf(this.hasKnownConstantSize)).isFalse();
        Assert.assertThrows(IllegalArgumentException.class, () -> TEST_MACHINE_MODEL.getSizeof(this.type));
    }
}

