/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.c;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.c.CArrayType;
import org.sosy_lab.cpachecker.cfa.types.c.CBasicType;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypedefType;
import org.sosy_lab.cpachecker.cfa.types.c.CTypes;

public class CanonicalTypeTest {
    private static final CType VOLATILE_CONST_INT = CTypes.withVolatile(CTypes.withConst(CNumericTypes.INT)).getCanonicalType();

    @Test
    public void simpleTypeChar() {
        Truth.assertThat((Object)CNumericTypes.CHAR.getCanonicalType()).isNotEqualTo((Object)CNumericTypes.SIGNED_CHAR);
        Truth.assertThat((Object)CNumericTypes.CHAR.getCanonicalType()).isNotEqualTo((Object)CNumericTypes.UNSIGNED_CHAR);
        Truth.assertThat((Object)CNumericTypes.SIGNED_CHAR.getCanonicalType()).isNotEqualTo((Object)CNumericTypes.UNSIGNED_CHAR);
        Truth.assertThat((Object)CNumericTypes.UNSIGNED_CHAR.getCanonicalType()).isNotEqualTo((Object)CNumericTypes.CHAR);
    }

    @Test
    public void simpleTypeInt() {
        Truth.assertThat((Object)CNumericTypes.INT.getCanonicalType()).isEqualTo((Object)CNumericTypes.SIGNED_INT);
        Truth.assertThat((Object)CNumericTypes.SIGNED_INT.getCanonicalType()).isEqualTo((Object)CNumericTypes.SIGNED_INT);
        Truth.assertThat((Object)CNumericTypes.UNSIGNED_INT.getCanonicalType()).isEqualTo((Object)CNumericTypes.UNSIGNED_INT);
        CSimpleType longType = new CSimpleType(false, false, CBasicType.UNSPECIFIED, true, false, false, false, false, false, false);
        Truth.assertThat((Object)longType.getCanonicalType()).isEqualTo((Object)CNumericTypes.SIGNED_LONG_INT);
    }

    @Test
    public void typedefQualifiers() {
        CTypedefType typedef = new CTypedefType(true, true, "TYPEDEF", CNumericTypes.INT);
        Truth.assertThat((Object)typedef.getCanonicalType()).isEqualTo((Object)VOLATILE_CONST_INT);
    }

    @Test
    public void arrayQualifiers() {
        CArrayType array = new CArrayType(true, true, CNumericTypes.INT, null);
        CArrayType expected = new CArrayType(false, false, VOLATILE_CONST_INT, null);
        Truth.assertThat((Object)array.getCanonicalType()).isEqualTo((Object)expected);
    }

    @Test
    public void arrayTypedefQualifiers() {
        CTypedefType typedef = new CTypedefType(true, false, "TYPEDEF", CNumericTypes.INT);
        CArrayType array = new CArrayType(false, true, typedef, null);
        CArrayType expected = new CArrayType(false, false, VOLATILE_CONST_INT, null);
        Truth.assertThat((Object)array.getCanonicalType()).isEqualTo((Object)expected);
    }

    @Test
    public void typedefArrayQualifiers() {
        CArrayType array = new CArrayType(false, true, CNumericTypes.INT, null);
        CTypedefType typedef = new CTypedefType(true, false, "TYPEDEF", array);
        CArrayType expected = new CArrayType(false, false, VOLATILE_CONST_INT, null);
        Truth.assertThat((Object)typedef.getCanonicalType()).isEqualTo((Object)expected);
    }

    @Test
    public void functionType() {
        CTypedefType typedef = new CTypedefType(false, false, "TYPEDEF", CNumericTypes.INT);
        CFunctionType function = new CFunctionType(typedef, (List<CType>)ImmutableList.of((Object)typedef), false);
        CFunctionType expected = new CFunctionType(CNumericTypes.SIGNED_INT, (List<CType>)ImmutableList.of((Object)CNumericTypes.SIGNED_INT), false);
        Truth.assertThat((Object)function.getCanonicalType()).isEqualTo((Object)expected);
    }
}

