/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.java;

import org.sosy_lab.cpachecker.cfa.types.AArrayType;
import org.sosy_lab.cpachecker.cfa.types.java.JReferenceType;
import org.sosy_lab.cpachecker.cfa.types.java.JType;

public class JArrayType
extends AArrayType
implements JReferenceType {
    private static final long serialVersionUID = -120299232751433551L;
    private final int dimension;

    public JArrayType(JType pElementType, int pDimension) {
        super(pElementType);
        this.dimension = pDimension;
    }

    @Override
    public String toASTString(String pDeclarator) {
        StringBuilder astString = new StringBuilder(this.getElementType().toASTString(""));
        for (int dim = 0; dim < this.dimension; ++dim) {
            astString.append("[]");
        }
        astString.append(" ");
        astString.append(pDeclarator);
        return astString.toString();
    }

    public JType getElementType() {
        return (JType)super.getType();
    }

    public int getDimensions() {
        return this.dimension;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + Integer.hashCode(this.dimension);
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JArrayType) && !super.equals(obj)) {
            return false;
        }
        JArrayType other = (JArrayType)obj;
        return this.dimension == other.dimension;
    }

    public String toString() {
        return this.toASTString("");
    }
}

