/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JReferenceType;

public class JClassType
extends JClassOrInterfaceType
implements JReferenceType {
    private static final long serialVersionUID = 2051770436134716617L;
    private static final String NAME_OF_CLASS_OBJECT = "java.lang.Object";
    private static final String SIMPLE_NAME_OF_CLASS_OBJECT = "Object";
    private static final JClassType typeOfObject = new JClassType();
    private static final JClassType UNRESOLVABLE_TYPE = new JClassType("_unspecified_", "_unspecified_", VisibilityModifier.NONE, false, false, false, JClassType.getTypeOfObject(), new HashSet<JInterfaceType>());
    private final boolean isFinal;
    private final boolean isAbstract;
    private final boolean isStrictFp;
    private final @Nullable JClassType superClass;
    private final Set<JInterfaceType> implementedInterfaces;
    private final Set<JClassType> directSubClasses = new HashSet<JClassType>();

    JClassType(String fullyQualifiedName, String pSimpleName, VisibilityModifier pVisibility, boolean pIsFinal, boolean pIsAbstract, boolean pStrictFp, JClassType pSuperClass, Set<JInterfaceType> pImplementedInterfaces) {
        super(fullyQualifiedName, pSimpleName, pVisibility);
        Preconditions.checkNotNull(pImplementedInterfaces);
        Preconditions.checkNotNull((Object)pSuperClass);
        Preconditions.checkArgument((!pIsFinal || !pIsAbstract ? 1 : 0) != 0, (Object)"Classes can't be abstract and final");
        Preconditions.checkArgument((this.getVisibility() != VisibilityModifier.PRIVATE && this.getVisibility() != VisibilityModifier.PROTECTED ? 1 : 0) != 0, (Object)"Classes that are not inner classes can't be private or protected");
        this.isFinal = pIsFinal;
        this.isAbstract = pIsAbstract;
        this.isStrictFp = pStrictFp;
        this.superClass = pSuperClass;
        this.implementedInterfaces = ImmutableSet.copyOf(pImplementedInterfaces);
        pSuperClass.registerSubType(this);
        this.notifyImplementedInterfacesOfThisClass();
        this.checkSuperClassConsistency();
    }

    JClassType(String fullyQualifiedName, String pSimpleName, VisibilityModifier pVisibility, boolean pIsFinal, boolean pIsAbstract, boolean pStrictFp, JClassType pSuperClass, Set<JInterfaceType> pImplementedInterfaces, JClassOrInterfaceType pEnclosingType) {
        super(fullyQualifiedName, pSimpleName, pVisibility, pEnclosingType);
        Preconditions.checkNotNull(pImplementedInterfaces);
        Preconditions.checkNotNull((Object)pSuperClass);
        Preconditions.checkArgument((!pIsFinal || !pIsAbstract ? 1 : 0) != 0, (Object)"Classes can't be abstract and final");
        this.isFinal = pIsFinal;
        this.isAbstract = pIsAbstract;
        this.isStrictFp = pStrictFp;
        this.superClass = pSuperClass;
        this.implementedInterfaces = ImmutableSet.copyOf(pImplementedInterfaces);
        pSuperClass.registerSubType(this);
        this.notifyImplementedInterfacesOfThisClass();
        this.checkSuperClassConsistency();
    }

    private void checkSuperClassConsistency() {
        HashSet<JClassType> found = new HashSet<JClassType>();
        for (JClassType nextSuperClass = this.superClass; nextSuperClass != null; nextSuperClass = nextSuperClass.getParentClass()) {
            found.add(nextSuperClass);
            Preconditions.checkArgument((!found.contains(this) ? 1 : 0) != 0, (String)"Class %s may not be a super class of itself.", (Object)this.getName());
        }
        Preconditions.checkArgument((boolean)found.contains(typeOfObject), (String)"Class %s must be a sub class of Object", (Object)this.getName());
    }

    private JClassType() {
        super(NAME_OF_CLASS_OBJECT, SIMPLE_NAME_OF_CLASS_OBJECT, VisibilityModifier.PUBLIC);
        this.superClass = null;
        this.implementedInterfaces = new HashSet<JInterfaceType>();
        this.isFinal = false;
        this.isAbstract = false;
        this.isStrictFp = false;
    }

    public static JClassType getTypeOfObject() {
        return typeOfObject;
    }

    public static JClassType valueOf(String fullyQualifiedName, String pSimpleName, VisibilityModifier pVisibility, boolean pIsFinal, boolean pIsAbstract, boolean pStrictFp, JClassType pSuperClass, Set<JInterfaceType> pImplementedInterfaces) {
        return new JClassType(fullyQualifiedName, pSimpleName, pVisibility, pIsFinal, pIsAbstract, pStrictFp, pSuperClass, pImplementedInterfaces);
    }

    public static JClassType valueOf(String fullyQualifiedName, String pSimpleName, VisibilityModifier pVisibility, boolean pIsFinal, boolean pIsAbstract, boolean pStrictFp, JClassType pSuperClass, Set<JInterfaceType> pImplementedInterfaces, JClassOrInterfaceType pEnclosingType) {
        return new JClassType(fullyQualifiedName, pSimpleName, pVisibility, pIsFinal, pIsAbstract, pStrictFp, pSuperClass, pImplementedInterfaces, pEnclosingType);
    }

    private void notifyImplementedInterfacesOfThisClass() {
        for (JInterfaceType implementedInterface : this.implementedInterfaces) {
            implementedInterface.registerSubType(this);
        }
    }

    public final boolean isFinal() {
        return this.isFinal;
    }

    public final boolean isAbstract() {
        return this.isAbstract;
    }

    public final boolean isStrictFp() {
        return this.isStrictFp;
    }

    public final @Nullable JClassType getParentClass() {
        return this.superClass;
    }

    public final Set<JClassType> getDirectSubClasses() {
        return ImmutableSet.copyOf(this.directSubClasses);
    }

    public final Set<JInterfaceType> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    private void registerSubType(JClassType pChild) {
        Preconditions.checkArgument((!this.directSubClasses.contains(pChild) ? 1 : 0) != 0);
        this.directSubClasses.add(pChild);
    }

    public final Set<JClassType> getAllSuperClasses() {
        HashSet<JClassType> result = new HashSet<JClassType>();
        for (JClassType nextSuperClass = this.superClass; nextSuperClass != null; nextSuperClass = nextSuperClass.getParentClass()) {
            result.add(nextSuperClass);
        }
        return result;
    }

    public final Set<JInterfaceType> getAllImplementedInterfaces() {
        HashSet<JInterfaceType> result = new HashSet<JInterfaceType>();
        Set<JClassType> classes = this.getAllSuperClasses();
        classes.add(this);
        for (JClassType iClass : classes) {
            result.addAll(iClass.getImplementedInterfaces());
            for (JInterfaceType implementedInterface : iClass.getImplementedInterfaces()) {
                result.addAll(implementedInterface.getAllSuperInterfaces());
            }
        }
        return result;
    }

    public final Set<JClassOrInterfaceType> getAllSuperTypesOfClass() {
        HashSet<JClassOrInterfaceType> result = new HashSet<JClassOrInterfaceType>();
        result.addAll(this.getAllSuperClasses());
        result.addAll(this.getAllImplementedInterfaces());
        return result;
    }

    public final Set<JClassType> getAllSubTypesOfClass() {
        HashSet<JClassType> result = new HashSet<JClassType>(this.directSubClasses);
        for (JClassType directSubClass : this.directSubClasses) {
            result.addAll(directSubClass.getAllSubTypesOfClass());
        }
        return result;
    }

    public static JClassType createUnresolvableType() {
        return UNRESOLVABLE_TYPE;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }
}

