/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cfa.types.java;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.java.VisibilityModifier;
import org.sosy_lab.cpachecker.cfa.types.java.JClassOrInterfaceType;
import org.sosy_lab.cpachecker.cfa.types.java.JClassType;
import org.sosy_lab.cpachecker.cfa.types.java.JReferenceType;

public final class JInterfaceType
extends JClassOrInterfaceType
implements JReferenceType {
    private static final long serialVersionUID = 1985477760453866693L;
    private static final JInterfaceType UNRESOLVABLE_TYPE = new JInterfaceType("_unspecified_", "_unspecified_", VisibilityModifier.NONE, new HashSet<JInterfaceType>());
    private final Set<JClassType> interfaceImplementingClasses = new HashSet<JClassType>();
    private final Set<JInterfaceType> superInterfaces;
    private final Set<JInterfaceType> directSubInterfaces = new HashSet<JInterfaceType>();

    private JInterfaceType(String pFullyQualifiedName, String pSimpleName, VisibilityModifier pVisibility, Set<JInterfaceType> pExtendedInterfaces) {
        super(pFullyQualifiedName, pSimpleName, pVisibility);
        Preconditions.checkNotNull(pExtendedInterfaces);
        this.superInterfaces = ImmutableSet.copyOf(pExtendedInterfaces);
        this.notifySuperTypes();
        this.checkInterfaceConsistency();
    }

    public JInterfaceType(String pFullyQualifiedName, String pSimpleName, VisibilityModifier pVisibility, Set<JInterfaceType> pExtendedInterfaces, JClassOrInterfaceType pEnclosingType) {
        super(pFullyQualifiedName, pSimpleName, pVisibility, pEnclosingType);
        Preconditions.checkNotNull(pExtendedInterfaces);
        this.superInterfaces = ImmutableSet.copyOf(pExtendedInterfaces);
        this.notifySuperTypes();
        this.checkInterfaceConsistency();
    }

    private void checkInterfaceConsistency() {
        this.checkInterfaceConsistencyRec(this);
    }

    private void checkInterfaceConsistencyRec(JInterfaceType basisType) {
        Preconditions.checkArgument((!this.superInterfaces.contains(basisType) ? 1 : 0) != 0);
        for (JInterfaceType directSuperInterface : this.superInterfaces) {
            directSuperInterface.checkInterfaceConsistencyRec(basisType);
        }
    }

    private void notifySuperTypes() {
        for (JInterfaceType superInterface : this.superInterfaces) {
            superInterface.registerSubType(this);
        }
    }

    public Set<JClassType> getKnownInterfaceImplementingClasses() {
        return this.interfaceImplementingClasses;
    }

    public Set<JInterfaceType> getSuperInterfaces() {
        return this.superInterfaces;
    }

    public Set<JInterfaceType> getDirectSubInterfaces() {
        return this.directSubInterfaces;
    }

    void registerSubType(JClassOrInterfaceType subType) {
        if (subType instanceof JInterfaceType) {
            Preconditions.checkArgument((!this.directSubInterfaces.contains(subType) ? 1 : 0) != 0);
            this.directSubInterfaces.add((JInterfaceType)subType);
        } else {
            Preconditions.checkArgument((!this.interfaceImplementingClasses.contains(subType) ? 1 : 0) != 0);
            this.interfaceImplementingClasses.add((JClassType)subType);
        }
    }

    public Set<JInterfaceType> getAllSubInterfacesOfInterface() {
        HashSet<JInterfaceType> result = new HashSet<JInterfaceType>(this.directSubInterfaces);
        for (JInterfaceType directSubInterface : this.directSubInterfaces) {
            result.addAll(directSubInterface.getAllSubInterfacesOfInterface());
        }
        return result;
    }

    public Set<JInterfaceType> getAllSuperInterfaces() {
        HashSet<JInterfaceType> result = new HashSet<JInterfaceType>(this.superInterfaces);
        for (JInterfaceType directSuperInterface : this.superInterfaces) {
            result.addAll(directSuperInterface.getAllSuperInterfaces());
        }
        return result;
    }

    public Set<JClassType> getAllKnownImplementingClassesOfInterface() {
        HashSet<JClassType> result = new HashSet<JClassType>();
        Set<JInterfaceType> interfaces = this.getAllSubInterfacesOfInterface();
        interfaces.add(this);
        for (JInterfaceType itInterface : interfaces) {
            result.addAll(itInterface.getKnownInterfaceImplementingClasses());
            for (JClassType implementingClasses : itInterface.getKnownInterfaceImplementingClasses()) {
                result.addAll(implementingClasses.getAllSubTypesOfClass());
            }
        }
        return result;
    }

    public List<JClassOrInterfaceType> getAllSubTypesOfInterfaces() {
        return ImmutableList.builder().addAll(this.getAllSubInterfacesOfInterface()).addAll(this.getAllKnownImplementingClassesOfInterface()).build();
    }

    public static JInterfaceType valueOf(String pFullyQualifiedName, String pSimpleName, VisibilityModifier pVisibility, Set<JInterfaceType> pExtendedInterfaces) {
        return new JInterfaceType(pFullyQualifiedName, pSimpleName, pVisibility, pExtendedInterfaces);
    }

    public static JInterfaceType createUnresolvableType() {
        return UNRESOLVABLE_TYPE;
    }

    public static JInterfaceType valueOf(String pFullyQualifiedName, String pSimpleName, VisibilityModifier pVisibility, Set<JInterfaceType> pExtendedInterfaces, JClassOrInterfaceType pEnclosingType) {
        return new JInterfaceType(pFullyQualifiedName, pSimpleName, pVisibility, pExtendedInterfaces, pEnclosingType);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 7;
        result = 31 * result + super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || super.equals(obj);
    }
}

