/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Closer;
import com.google.common.io.MoreFiles;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.converters.FileTypeConverter;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.io.DuplicateOutputStream;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.log.LoggingOptions;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cmdline.CmdLineArguments;
import org.sosy_lab.cpachecker.cmdline.ForceTerminationOnShutdown;
import org.sosy_lab.cpachecker.cmdline.Output;
import org.sosy_lab.cpachecker.cmdline.ShutdownHook;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.algorithm.pcc.ProofGenerator;
import org.sosy_lab.cpachecker.core.counterexample.ReportGenerator;
import org.sosy_lab.cpachecker.core.specification.Property;
import org.sosy_lab.cpachecker.core.specification.PropertyFileParser;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonGraphmlParser;
import org.sosy_lab.cpachecker.cpa.testtargets.TestTargetType;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;

@SuppressForbidden(value="System.out in this class is ok")
public class CPAMain {
    static final int ERROR_EXIT_CODE = 1;
    private static final ImmutableMap<String, String> EXTERN_OPTION_DEFAULTS = ImmutableMap.of((Object)"log.level", (Object)Level.INFO.toString());
    private static final String SPECIFICATION_OPTION = "specification";
    private static final String ENTRYFUNCTION_OPTION = "analysis.entryFunction";
    public static final String APPROACH_NAME_OPTION = "analysis.name";
    private static final ImmutableSet<? extends Property> MEMSAFETY_PROPERTY_TYPES = Sets.immutableEnumSet((Enum)Property.CommonVerificationProperty.VALID_DEREF, (Enum[])new Property.CommonVerificationProperty[]{Property.CommonVerificationProperty.VALID_FREE, Property.CommonVerificationProperty.VALID_MEMTRACK});
    private static final String LANGUAGE_HINT = String.format(" Please specify a language directly with the option 'language=%s'.", Arrays.toString((Object[])Language.values()));
    private static final ImmutableMap<Property, TestTargetType> TARGET_TYPES = ImmutableMap.builder().put((Object)Property.CommonCoverageProperty.COVERAGE_BRANCH, (Object)TestTargetType.TEST_COMP_ASSUME).put((Object)Property.CommonCoverageProperty.COVERAGE_CONDITION, (Object)TestTargetType.ASSUME).put((Object)Property.CommonCoverageProperty.COVERAGE_ERROR, (Object)TestTargetType.ERROR_CALL).put((Object)Property.CommonCoverageProperty.COVERAGE_STATEMENT, (Object)TestTargetType.STATEMENT).buildOrThrow();

    public static void main(String[] args) {
        LoggingOptions logOptions;
        Locale.setDefault(Locale.US);
        if (args.length == 0) {
            args = new String[]{"-help"};
        }
        Configuration cpaConfig = null;
        String outputDirectory = null;
        try {
            try {
                Config p = CPAMain.createConfiguration(args);
                cpaConfig = p.configuration;
                outputDirectory = p.outputPath;
            }
            catch (CmdLineArguments.InvalidCmdlineArgumentException e) {
                throw Output.fatalError("Could not process command line arguments: %s", e.getMessage());
            }
            catch (IOException e) {
                throw Output.fatalError("Could not read config file %s", e.getMessage());
            }
            catch (InterruptedException e) {
                throw Output.fatalError("Interrupted: %s", e.getMessage());
            }
            logOptions = new LoggingOptions(cpaConfig);
        }
        catch (InvalidConfigurationException e) {
            throw Output.fatalError("Invalid configuration: %s", e.getMessage());
        }
        LogManager logManager = BasicLogManager.create((LoggingOptions)logOptions);
        cpaConfig.enableLogging(logManager);
        if (!System.getProperty("file.encoding", "UTF-8").equalsIgnoreCase("UTF-8")) {
            logManager.logf(Level.WARNING, "JVM property file.encoding is set to non-standard value '%s'. This is not recommended and output files might be written in unexpected encodings.", new Object[]{System.getProperty("file.encoding")});
        }
        ShutdownManager shutdownManager = ShutdownManager.create();
        ShutdownNotifier shutdownNotifier = shutdownManager.getNotifier();
        CPAchecker cpachecker = null;
        ProofGenerator proofGenerator = null;
        ResourceLimitChecker limits = null;
        ReportGenerator reportGenerator = null;
        MainOptions options = new MainOptions();
        try {
            cpaConfig.inject((Object)options);
            if (options.programs.isEmpty()) {
                throw new InvalidConfigurationException("Please specify a program to analyze on the command line.");
            }
            CPAMain.dumpConfiguration(options, cpaConfig, logManager);
            cpaConfig = CPAMain.detectFrontendLanguageIfNecessary(options, cpaConfig, logManager);
            limits = ResourceLimitChecker.fromConfiguration(cpaConfig, logManager, shutdownManager);
            limits.start();
            cpachecker = new CPAchecker(cpaConfig, logManager, shutdownManager);
            if (options.doPCC) {
                proofGenerator = new ProofGenerator(cpaConfig, logManager, shutdownNotifier);
            }
            reportGenerator = new ReportGenerator(cpaConfig, logManager, logOptions.getOutputFile(), options.programs);
        }
        catch (InvalidConfigurationException e) {
            logManager.logUserException(Level.SEVERE, (Throwable)e, "Invalid configuration");
            System.exit(1);
            return;
        }
        ShutdownHook shutdownHook = new ShutdownHook(shutdownManager);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        ShutdownNotifier.ShutdownRequestListener forcedExitOnShutdown = ForceTerminationOnShutdown.createShutdownListener(logManager, shutdownHook);
        shutdownNotifier.register(forcedExitOnShutdown);
        CPAcheckerResult result = cpachecker.run((List<String>)options.programs);
        if (proofGenerator != null) {
            proofGenerator.generateProof(result);
        }
        shutdownHook.disableShutdownRequests();
        shutdownNotifier.unregister(forcedExitOnShutdown);
        ForceTerminationOnShutdown.cancelPendingTermination();
        limits.cancel();
        Thread.interrupted();
        try {
            CPAMain.printResultAndStatistics(result, outputDirectory, options, reportGenerator, logManager);
        }
        catch (IOException e) {
            logManager.logUserException(Level.WARNING, (Throwable)e, "Could not write statistics to file");
        }
        System.out.flush();
        System.err.flush();
        logManager.flush();
    }

    private static void dumpConfiguration(MainOptions options, Configuration config, LogManager logManager) {
        if (options.configurationOutputFile != null) {
            try {
                IO.writeFile((Path)options.configurationOutputFile, (Charset)Charset.defaultCharset(), (Object)config.asPropertiesString());
            }
            catch (IOException e) {
                logManager.logUserException(Level.WARNING, (Throwable)e, "Could not dump configuration to file");
            }
        }
    }

    private static Config createConfiguration(String[] args) throws InvalidConfigurationException, CmdLineArguments.InvalidCmdlineArgumentException, IOException, InterruptedException {
        boolean secureMode;
        Map<String, String> cmdLineOptions = CmdLineArguments.processArguments(args);
        boolean bl = secureMode = cmdLineOptions.remove("secureMode") != null;
        if (secureMode) {
            Configuration.enableSecureModeGlobally();
        }
        Set<Property> properties = CPAMain.handlePropertyFile(cmdLineOptions);
        Optional<String> configFile = Optional.ofNullable(cmdLineOptions.remove("configuration.file"));
        ConfigurationBuilder configBuilder = Configuration.builder();
        configBuilder.setOptions(EXTERN_OPTION_DEFAULTS);
        if (configFile.isPresent()) {
            configBuilder.setOption(APPROACH_NAME_OPTION, CPAMain.extractApproachNameFromConfigName(configFile.orElseThrow()));
            configBuilder.loadFromFile(configFile.orElseThrow());
        }
        configBuilder.setOptions(cmdLineOptions);
        Configuration config = configBuilder.build();
        FileTypeConverter fileTypeConverter = secureMode ? FileTypeConverter.createWithSafePathsOnly((Configuration)config) : FileTypeConverter.create((Configuration)config);
        String outputDirectory = fileTypeConverter.getOutputDirectory();
        Configuration.getDefaultConverters().put(FileOption.class, fileTypeConverter);
        config = Configuration.builder().copyFrom(config).addConverter(FileOption.class, (TypeConverter)fileTypeConverter).build();
        config = CPAMain.handleWitnessOptions(config, cmdLineOptions, configFile);
        BootstrapOptions options = new BootstrapOptions();
        config.inject((Object)options);
        config = CPAMain.handlePropertyOptions(config, options, cmdLineOptions, properties);
        if (options.printUsedOptions) {
            config.dumpUsedOptionsTo(System.out);
        }
        return new Config(config, outputDirectory);
    }

    private static String extractApproachNameFromConfigName(String configFilename) {
        String filename = Path.of(configFilename, new String[0]).getFileName().toString();
        return filename.contains(".") ? filename.substring(0, filename.lastIndexOf(".")) : filename;
    }

    @VisibleForTesting
    static Configuration detectFrontendLanguageIfNecessary(MainOptions pOptions, Configuration pConfig, LogManager pLogManager) throws InvalidConfigurationException {
        if (pOptions.language == null) {
            Language frontendLanguage = CPAMain.areJavaOptionsSet(pConfig) ? Language.JAVA : CPAMain.detectFrontendLanguageFromFileEndings(pOptions.programs);
            Preconditions.checkNotNull((Object)((Object)frontendLanguage));
            ConfigurationBuilder configBuilder = Configuration.builder();
            configBuilder.copyFrom(pConfig);
            configBuilder.setOption("language", frontendLanguage.name());
            pConfig = configBuilder.build();
            pOptions.language = frontendLanguage;
            pLogManager.logf(Level.INFO, "Language %s detected and set for analysis", new Object[]{frontendLanguage});
        }
        Preconditions.checkNotNull((Object)((Object)pOptions.language));
        return pConfig;
    }

    private static boolean areJavaOptionsSet(Configuration pConfig) {
        return pConfig.hasProperty("java.sourcepath") || pConfig.hasProperty("java.classpath");
    }

    private static Language detectFrontendLanguageFromFileEndings(ImmutableList<String> pPrograms) throws InvalidConfigurationException {
        Preconditions.checkArgument((!pPrograms.isEmpty() ? 1 : 0) != 0, (Object)"Empty list of programs");
        Language frontendLanguage = null;
        for (String program : pPrograms) {
            Language language;
            String suffix;
            switch (suffix = program.substring(program.lastIndexOf(".") + 1)) {
                case "ll": 
                case "bc": {
                    language = Language.LLVM;
                    break;
                }
                default: {
                    language = Language.C;
                }
            }
            Preconditions.checkNotNull((Object)((Object)language));
            if (frontendLanguage == null) {
                frontendLanguage = language;
            }
            if (frontendLanguage == language) continue;
            throw new InvalidConfigurationException(String.format("Differing file formats detected: %s and %s files are declared for analysis.", new Object[]{frontendLanguage, language}) + LANGUAGE_HINT);
        }
        return frontendLanguage;
    }

    private static Configuration handlePropertyOptions(Configuration config, BootstrapOptions options, Map<String, String> cmdLineOptions, Set<Property> properties) throws InvalidConfigurationException, IOException {
        Path alternateConfigFile;
        if (!Collections.disjoint(properties, MEMSAFETY_PROPERTY_TYPES)) {
            if (!MEMSAFETY_PROPERTY_TYPES.containsAll(properties)) {
                throw new InvalidConfigurationException("Unsupported combination of properties: " + properties);
            }
            alternateConfigFile = CPAMain.check(options.memsafetyConfig, "memory safety", "memorysafety.config");
        } else if (properties.contains(Property.CommonVerificationProperty.VALID_MEMCLEANUP)) {
            if (properties.size() != 1) {
                throw new InvalidConfigurationException("Unsupported combination of properties: " + properties);
            }
            alternateConfigFile = CPAMain.check(options.memcleanupConfig, "memory cleanup", "memorycleanup.config");
        } else if (properties.contains(Property.CommonVerificationProperty.OVERFLOW)) {
            if (properties.size() != 1) {
                throw new InvalidConfigurationException("Unsupported combination of properties: " + properties);
            }
            alternateConfigFile = CPAMain.check(options.overflowConfig, "overflows", "overflow.config");
        } else if (properties.contains(Property.CommonVerificationProperty.DATA_RACE)) {
            if (properties.size() != 1) {
                throw new InvalidConfigurationException("Unsupported combination of properties: " + properties);
            }
            alternateConfigFile = CPAMain.check(options.dataraceConfig, "data races", "datarace.config");
        } else if (properties.contains(Property.CommonVerificationProperty.TERMINATION)) {
            if (properties.size() != 1) {
                throw new InvalidConfigurationException("Unsupported combination of properties: " + properties);
            }
            alternateConfigFile = CPAMain.check(options.terminationConfig, "termination", "termination.config");
        } else {
            if (properties.contains(Property.CommonCoverageProperty.COVERAGE_ERROR) || properties.contains(Property.CommonCoverageProperty.COVERAGE_BRANCH) || properties.contains(Property.CommonCoverageProperty.COVERAGE_CONDITION) || properties.contains(Property.CommonCoverageProperty.COVERAGE_STATEMENT)) {
                if (properties.size() != 1) {
                    throw new InvalidConfigurationException("Unsupported combination of properties: " + properties);
                }
                return Configuration.builder().copyFrom(config).setOption("testcase.targets.type", ((TestTargetType)((Object)TARGET_TYPES.get((Object)properties.iterator().next()))).name()).build();
            }
            if (FluentIterable.from(properties).anyMatch(p -> p instanceof Property.CoverFunctionCallProperty)) {
                if (properties.size() != 1) {
                    throw new InvalidConfigurationException("Unsupported combination of properties: " + properties);
                }
                return Configuration.builder().copyFrom(config).setOption("testcase.targets.type", "FUN_CALL").setOption("testcase.targets.funName", ((Property.CoverFunctionCallProperty)properties.iterator().next()).getCoverFunction()).build();
            }
            alternateConfigFile = null;
        }
        if (alternateConfigFile != null) {
            return Configuration.builder().loadFromFile(alternateConfigFile).setOptions(cmdLineOptions).clearOption("memorysafety.config").clearOption("memorycleanup.config").clearOption("overflow.config").clearOption("datarace.config").clearOption("termination.config").clearOption("output.disable").clearOption("output.path").clearOption("rootDirectory").clearOption("witness.validation.file").build();
        }
        return config;
    }

    private static Path check(Path config, String verificationTarget, String optionName) throws InvalidConfigurationException {
        if (config == null) {
            throw new InvalidConfigurationException(String.format("Verifying %s is not supported if option %s is not specified.", verificationTarget, optionName));
        }
        return config;
    }

    private static Set<Property> handlePropertyFile(Map<String, String> cmdLineOptions) throws CmdLineArguments.InvalidCmdlineArgumentException {
        List specificationFiles = Splitter.on((char)',').trimResults().omitEmptyStrings().splitToList((CharSequence)cmdLineOptions.getOrDefault(SPECIFICATION_OPTION, ""));
        ImmutableList propertyFiles = FluentIterable.from((Iterable)specificationFiles).filter(file -> file.endsWith(".prp")).toList();
        if (propertyFiles.isEmpty()) {
            return ImmutableSet.of();
        }
        if (propertyFiles.size() > 1) {
            throw new CmdLineArguments.InvalidCmdlineArgumentException("Multiple property files are not supported.");
        }
        String propertyFile = (String)propertyFiles.get(0);
        PropertyFileParser parser = new PropertyFileParser(Path.of(propertyFile, new String[0]));
        try {
            parser.parse();
        }
        catch (PropertyFileParser.InvalidPropertyFileException e) {
            throw new CmdLineArguments.InvalidCmdlineArgumentException(String.format("Invalid property file '%s': %s", propertyFile, e.getMessage()), e);
        }
        catch (IOException e) {
            throw new CmdLineArguments.InvalidCmdlineArgumentException("Could not read property file: " + e.getMessage(), e);
        }
        if (cmdLineOptions.containsKey(ENTRYFUNCTION_OPTION)) {
            if (!cmdLineOptions.get(ENTRYFUNCTION_OPTION).equals(parser.getEntryFunction())) {
                throw new CmdLineArguments.InvalidCmdlineArgumentException("Mismatching names for entry function on command line and in property file");
            }
        } else {
            cmdLineOptions.put(ENTRYFUNCTION_OPTION, parser.getEntryFunction());
        }
        return parser.getProperties();
    }

    private static Configuration handleWitnessOptions(Configuration config, Map<String, String> overrideOptions, Optional<String> configFileName) throws InvalidConfigurationException, IOException, InterruptedException {
        Path validationConfigFile;
        WitnessOptions options = new WitnessOptions();
        config.inject((Object)options);
        if (options.witness == null) {
            return config;
        }
        if (options.useACSLAnnotatedProgram) {
            validationConfigFile = options.correctnessWitnessValidationConfig;
            CPAMain.appendWitnessToSpecificationOption(options, overrideOptions);
        } else {
            AutomatonGraphmlCommon.WitnessType witnessType = AutomatonGraphmlParser.getWitnessType(options.witness);
            switch (witnessType) {
                case VIOLATION_WITNESS: {
                    validationConfigFile = options.violationWitnessValidationConfig;
                    CPAMain.appendWitnessToSpecificationOption(options, overrideOptions);
                    break;
                }
                case CORRECTNESS_WITNESS: {
                    validationConfigFile = options.correctnessWitnessValidationConfig;
                    if (options.validateInvariantsSpecificationAutomaton) {
                        CPAMain.appendWitnessToSpecificationOption(options, overrideOptions);
                        break;
                    }
                    overrideOptions.put("invariantGeneration.kInduction.invariantsAutomatonFile", options.witness.toString());
                    break;
                }
                default: {
                    throw new InvalidConfigurationException("Witness type " + witnessType + " of witness " + options.witness + " is not supported");
                }
            }
        }
        if (validationConfigFile == null) {
            throw new InvalidConfigurationException("Validating (violation|correctness) witnesses is not supported if option witness.validation.(violation|correctness).config is not specified.");
        }
        ConfigurationBuilder configBuilder = Configuration.builder().loadFromFile(validationConfigFile).setOptions(overrideOptions).clearOption("witness.validation.file").clearOption("witness.validation.violation.config").clearOption("witness.validation.correctness.config").clearOption("witness.validation.correctness.acsl").clearOption("output.path").clearOption("rootDirectory");
        if (configFileName.isPresent()) {
            configBuilder.setOption(APPROACH_NAME_OPTION, CPAMain.extractApproachNameFromConfigName(configFileName.orElseThrow()));
        }
        return configBuilder.build();
    }

    private static void appendWitnessToSpecificationOption(WitnessOptions pOptions, Map<String, String> pOverrideOptions) {
        String specs = pOverrideOptions.get(SPECIFICATION_OPTION);
        String witnessSpec = pOptions.witness.toString();
        specs = specs == null ? witnessSpec : specs + "," + witnessSpec;
        pOverrideOptions.put(SPECIFICATION_OPTION, specs);
    }

    private static void printResultAndStatistics(CPAcheckerResult mResult, String outputDirectory, MainOptions options, ReportGenerator reportGenerator, LogManager logManager) throws IOException {
        PrintStream console = options.printStatistics ? System.out : null;
        OutputStream file = null;
        Closer closer = Closer.create();
        if (options.exportStatistics && options.exportStatisticsFile != null) {
            try {
                MoreFiles.createParentDirectories((Path)options.exportStatisticsFile, (FileAttribute[])new FileAttribute[0]);
                file = (OutputStream)closer.register((Closeable)Files.newOutputStream(options.exportStatisticsFile, new OpenOption[0]));
            }
            catch (IOException e) {
                logManager.logUserException(Level.WARNING, (Throwable)e, "Could not write statistics to file");
            }
        }
        PrintStream stream = CPAMain.makePrintStream(DuplicateOutputStream.mergeStreams((OutputStream)console, file));
        ByteArrayOutputStream statistics = new ByteArrayOutputStream();
        try {
            PrintStream statisticsStream = CPAMain.makePrintStream(DuplicateOutputStream.mergeStreams((OutputStream)stream, (OutputStream)statistics));
            mResult.printStatistics(statisticsStream);
            stream.println();
            if (!options.printStatistics) {
                stream = CPAMain.makePrintStream(DuplicateOutputStream.mergeStreams((OutputStream)System.out, (OutputStream)file));
            }
            mResult.printResult(stream);
            mResult.writeOutputFiles();
            if (outputDirectory != null) {
                stream.println("More details about the verification run can be found in the directory \"" + outputDirectory + "\".");
            }
            stream.flush();
        }
        catch (Throwable t) {
            throw closer.rethrow(t);
        }
        finally {
            closer.close();
        }
        if (mResult.getResult() != CPAcheckerResult.Result.NOT_YET_STARTED) {
            reportGenerator.generate(mResult.getResult(), mResult.getCfa(), mResult.getReached(), statistics.toString(Charset.defaultCharset()));
        }
    }

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="Default encoding is the correct one for stdout.")
    private static PrintStream makePrintStream(OutputStream stream) {
        if (stream instanceof PrintStream) {
            return (PrintStream)stream;
        }
        return new PrintStream(stream);
    }

    private CPAMain() {
    }

    private static class Config {
        private final Configuration configuration;
        private final String outputPath;

        public Config(Configuration pConfiguration, String pOutputPath) {
            this.configuration = pConfiguration;
            this.outputPath = pOutputPath;
        }
    }

    @Options
    private static class WitnessOptions {
        @Option(secure=true, name="witness.validation.file", description="The witness to validate.")
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        private @Nullable Path witness = null;
        @Option(secure=true, name="witness.validation.violation.config", description="When validating a violation witness, use this configuration file instead of the current one.")
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        private @Nullable Path violationWitnessValidationConfig = null;
        @Option(secure=true, name="witness.validation.correctness.config", description="When validating a correctness witness, use this configuration file instead of the current one.")
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        private @Nullable Path correctnessWitnessValidationConfig = null;
        @Option(secure=true, name="witness.validation.correctness.isa", description="Use correctness witness as invariants specification automaton (ISA).")
        private boolean validateInvariantsSpecificationAutomaton = false;
        @Option(secure=true, name="witness.validation.correctness.acsl", description="Validate program using invariants from ACSL annotations.")
        private boolean useACSLAnnotatedProgram = false;

        private WitnessOptions() {
        }
    }

    @Options
    @VisibleForTesting
    protected static class MainOptions {
        @Option(secure=true, name="analysis.programNames", description="A String, denoting the programs to be analyzed")
        private ImmutableList<String> programs = ImmutableList.of();
        @Option(secure=true, description="Programming language of the input program. If not given explicitly, auto-detection will occur")
        private Language language = null;
        @Option(secure=true, name="configuration.dumpFile", description="Dump the complete configuration to a file.")
        @FileOption(value=FileOption.Type.OUTPUT_FILE)
        private Path configurationOutputFile = Path.of("UsedConfiguration.properties", new String[0]);
        @Option(secure=true, name="statistics.export", description="write some statistics to disk")
        private boolean exportStatistics = true;
        @Option(secure=true, name="statistics.file", description="write some statistics to disk")
        @FileOption(value=FileOption.Type.OUTPUT_FILE)
        private Path exportStatisticsFile = Path.of("Statistics.txt", new String[0]);
        @Option(secure=true, name="statistics.print", description="print statistics to console")
        private boolean printStatistics = false;
        @Option(secure=true, name="pcc.proofgen.doPCC", description="Generate and dump a proof")
        private boolean doPCC = false;

        protected MainOptions() {
        }
    }

    @Options
    private static class BootstrapOptions {
        @Option(secure=true, name="memorysafety.config", description="When checking for memory safety properties, use this configuration file instead of the current one.")
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        private @Nullable Path memsafetyConfig = null;
        @Option(secure=true, name="memorycleanup.config", description="When checking for memory cleanup properties, use this configuration file instead of the current one.")
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        private @Nullable Path memcleanupConfig = null;
        @Option(secure=true, name="overflow.config", description="When checking for the overflow property, use this configuration file instead of the current one.")
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        private @Nullable Path overflowConfig = null;
        @Option(secure=true, name="datarace.config", description="When checking for the data race property, use this configuration file instead of the current one.")
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        private @Nullable Path dataraceConfig = null;
        @Option(secure=true, name="termination.config", description="When checking for the termination property, use this configuration file instead of the current one.")
        @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
        private @Nullable Path terminationConfig = null;
        @Option(secure=true, name="log.usedOptions.export", description="all used options are printed")
        private boolean printUsedOptions = false;

        private BootstrapOptions() {
        }
    }
}

