/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cmdline.CPAMain;

@RunWith(value=Parameterized.class)
public class CPAMainTest {
    @Parameterized.Parameter(value=0)
    public Language language;
    private final LogManager logManager = LogManager.createTestLogManager();
    private final Multimap<Language, String> languageToInputFile = HashMultimap.create();
    private ConfigurationBuilder configBuilder;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAllLanguages() {
        return Language.values();
    }

    @Before
    public void init() {
        this.languageToInputFile.put((Object)Language.C, (Object)"test.c");
        this.languageToInputFile.put((Object)Language.C, (Object)"test.i");
        this.languageToInputFile.put((Object)Language.C, (Object)"test.h");
        this.languageToInputFile.put((Object)Language.C, (Object)"test.c, test.i, test.h");
        this.languageToInputFile.put((Object)Language.JAVA, (Object)"Test");
        this.languageToInputFile.put((Object)Language.LLVM, (Object)"test.ll");
        this.languageToInputFile.put((Object)Language.LLVM, (Object)"test.bc");
        this.languageToInputFile.put((Object)Language.LLVM, (Object)"test.ll, test.bc");
    }

    @Before
    public void setUp() {
        this.configBuilder = Configuration.builder();
    }

    @Test
    public void testLanguageDetection_BasedOnFileSuffix_DetectsCorrectly() throws InvalidConfigurationException {
        for (Language languageToTest : ImmutableList.of((Object)((Object)Language.C), (Object)((Object)Language.LLVM))) {
            for (String inputPrograms : this.languageToInputFile.get((Object)languageToTest)) {
                this.configBuilder.setOption("analysis.programNames", inputPrograms);
                Configuration config = this.configBuilder.build();
                CPAMain.MainOptions options = new CPAMain.MainOptions();
                config.inject((Object)options);
                Configuration newConfig = CPAMain.detectFrontendLanguageIfNecessary(options, config, this.logManager);
                Truth.assertThat((String)newConfig.getProperty("language")).isEqualTo((Object)languageToTest.name());
            }
        }
    }

    @Test
    public void testLanguageDetection_WithJavaClassPath_DetectsCorrectly() throws InvalidConfigurationException {
        for (String inputPrograms : this.languageToInputFile.get((Object)Language.JAVA)) {
            this.configBuilder.setOption("analysis.programNames", inputPrograms);
            this.configBuilder.setOption("java.classpath", "lib");
            Configuration config = this.configBuilder.build();
            CPAMain.MainOptions options = new CPAMain.MainOptions();
            config.inject((Object)options);
            Configuration newConfig = CPAMain.detectFrontendLanguageIfNecessary(options, config, this.logManager);
            Truth.assertThat((String)newConfig.getProperty("language")).isEqualTo((Object)Language.JAVA.name());
        }
    }

    @Test
    public void testLanguageDetection_WithJavaSourcePath_DetectsCorrectly() throws InvalidConfigurationException {
        for (String inputPrograms : this.languageToInputFile.get((Object)Language.JAVA)) {
            this.configBuilder.setOption("analysis.programNames", inputPrograms);
            this.configBuilder.setOption("java.classpath", "src");
            Configuration config = this.configBuilder.build();
            CPAMain.MainOptions options = new CPAMain.MainOptions();
            config.inject((Object)options);
            Configuration newConfig = CPAMain.detectFrontendLanguageIfNecessary(options, config, this.logManager);
            Truth.assertThat((String)newConfig.getProperty("language")).isEqualTo((Object)Language.JAVA.name());
        }
    }

    @Test
    public void testLanguageDetection_GivenByUser_IsNotOverwritten() throws InvalidConfigurationException {
        String declLanguage = this.language.name();
        for (Language fileLanguage : Language.values()) {
            for (String file : this.languageToInputFile.get((Object)fileLanguage)) {
                this.configBuilder.setOption("language", declLanguage);
                this.configBuilder.setOption("analysis.programNames", file);
                Configuration config = this.configBuilder.build();
                CPAMain.MainOptions options = new CPAMain.MainOptions();
                config.inject((Object)options);
                Configuration newConfig = CPAMain.detectFrontendLanguageIfNecessary(options, config, this.logManager);
                Truth.assertThat((String)newConfig.getProperty("language")).isEqualTo((Object)declLanguage);
            }
        }
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testLanguageDetection_MultipleLanguagesGiven_Fails() throws InvalidConfigurationException {
        this.configBuilder.setOption("analysis.programNames", "test.c, test.i, test.h, test.java, test.ll, test.bc");
        Configuration config = this.configBuilder.build();
        CPAMain.MainOptions options = new CPAMain.MainOptions();
        config.inject((Object)options);
        CPAMain.detectFrontendLanguageIfNecessary(options, config, this.logManager);
        Truth.assert_().fail();
    }
}

