/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sosy_lab.cpachecker.cmdline.CmdLineArguments;

abstract class CmdLineArgument
implements Comparable<CmdLineArgument> {
    private final ImmutableSet<String> names;
    private String description = "";

    CmdLineArgument(String ... pNames) {
        this.names = ImmutableSet.copyOf((Object[])pNames);
    }

    @CanIgnoreReturnValue
    CmdLineArgument withDescription(String pDescription) {
        this.description = pDescription;
        return this;
    }

    @Override
    public int compareTo(CmdLineArgument other) {
        return this.names.toString().compareTo(other.names.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof CmdLineArgument && this.names.equals(((CmdLineArgument)o).names);
    }

    public int hashCode() {
        return this.names.hashCode();
    }

    public String toString() {
        String s = Joiner.on((String)"/").join(this.names);
        if (this.description.isEmpty()) {
            return s;
        }
        return String.format("%1$-20s %2$s", s, this.description);
    }

    boolean apply(Map<String, String> properties, String currentArg, Iterator<String> argsIt) throws CmdLineArguments.InvalidCmdlineArgumentException {
        if (this.names.contains((Object)currentArg)) {
            this.apply0(properties, currentArg, argsIt);
            return true;
        }
        return false;
    }

    abstract void apply0(Map<String, String> var1, String var2, Iterator<String> var3) throws CmdLineArguments.InvalidCmdlineArgumentException;

    static class PropertyAddingCmdLineArgument
    extends CmdLineArgument {
        private final Map<String, String> additionalIfNotExistentArgs = new HashMap<String, String>();
        private final Map<String, String> additionalArgs = new HashMap<String, String>();

        PropertyAddingCmdLineArgument(String pName) {
            super(pName);
        }

        @CanIgnoreReturnValue
        PropertyAddingCmdLineArgument settingProperty(String pName, String pValue) {
            this.additionalIfNotExistentArgs.put(pName, pValue);
            return this;
        }

        @CanIgnoreReturnValue
        PropertyAddingCmdLineArgument overridingProperty(String pName, String pValue) {
            this.additionalArgs.put(pName, pValue);
            return this;
        }

        @Override
        void apply0(Map<String, String> properties, String currentArg, Iterator<String> args) throws CmdLineArguments.InvalidCmdlineArgumentException {
            for (Map.Entry<String, String> e : this.additionalIfNotExistentArgs.entrySet()) {
                CmdLineArguments.putIfNotExistent(properties, e.getKey(), e.getValue());
            }
            for (Map.Entry<String, String> e : this.additionalArgs.entrySet()) {
                properties.put(e.getKey(), e.getValue());
            }
        }
    }

    static class CmdLineArgument1
    extends CmdLineArgument {
        private final String option;

        CmdLineArgument1(String pName) {
            super(pName);
            this.option = "";
        }

        CmdLineArgument1(String pName, String pOption) {
            super(pName);
            this.option = pOption;
        }

        CmdLineArgument1(String pName1, String pName2, String pOption) {
            super(pName1, pName2);
            this.option = pOption;
        }

        String getOption() {
            return this.option;
        }

        @Override
        final void apply0(Map<String, String> properties, String currentArg, Iterator<String> args) throws CmdLineArguments.InvalidCmdlineArgumentException {
            if (!args.hasNext()) {
                throw new CmdLineArguments.InvalidCmdlineArgumentException(currentArg + " argument missing.");
            }
            this.handleArg(properties, args.next());
        }

        void handleArg(Map<String, String> pProperties, String pArg) throws CmdLineArguments.InvalidCmdlineArgumentException {
            CmdLineArguments.putIfNotExistent(pProperties, this.option, pArg);
        }
    }
}

