/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.Classes;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.common.configuration.OptionCollector;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.cpachecker.cmdline.CmdLineArgument;
import org.sosy_lab.cpachecker.cmdline.Output;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.cpa.composite.CompositeCPA;

class CmdLineArguments {
    private static final Splitter SETPROP_OPTION_SPLITTER = Splitter.on((char)'=').trimResults().limit(2);
    private static final Pattern DEFAULT_CONFIG_FILES_PATTERN = Pattern.compile("^[a-zA-Z0-9-+]+$");
    private static final ImmutableMap<String, String> DEFAULT_CONFIG_FILES_TEMPLATES = ImmutableMap.of((Object)"config/%s.properties", (Object)"", (Object)"config/unmaintained/%s.properties", (Object)"The configuration %s is unmaintained and may not work correctly.");
    static final String CONFIGURATION_FILE_OPTION = "configuration.file";
    private static final String CMC_CONFIGURATION_FILES_OPTION = "restartAlgorithm.configFiles";
    private static final Pattern SPECIFICATION_FILES_PATTERN = DEFAULT_CONFIG_FILES_PATTERN;
    private static final String SPECIFICATION_FILES_TEMPLATE = "config/specification/%s.spc";
    static final String SECURE_MODE_OPTION = "secureMode";
    static final String PRINT_USED_OPTIONS_OPTION = "log.usedOptions.export";
    private static final ImmutableSortedSet<CmdLineArgument> CMD_LINE_ARGS = ImmutableSortedSet.of((Comparable)new CmdLineArgument.PropertyAddingCmdLineArgument("-stats").settingProperty("statistics.print", "true").withDescription("collect statistics during the analysis and print them afterwards"), (Comparable)new CmdLineArgument.PropertyAddingCmdLineArgument("-noout").settingProperty("output.disable", "true").withDescription("disable all output (except directly specified files)"), (Comparable)new CmdLineArgument.PropertyAddingCmdLineArgument("-java").settingProperty("language", "JAVA").withDescription("language of the sourcefile"), (Comparable)new CmdLineArgument.PropertyAddingCmdLineArgument("-32").settingProperty("analysis.machineModel", "Linux32").withDescription("set machine model to LINUX32"), (Comparable)new CmdLineArgument.PropertyAddingCmdLineArgument("-64").settingProperty("analysis.machineModel", "Linux64").withDescription("set machine model to LINUX64"), (Comparable)new CmdLineArgument.PropertyAddingCmdLineArgument("-preprocess").settingProperty("parser.usePreprocessor", "true").withDescription("execute a preprocessor before starting the analysis"), (Comparable[])new CmdLineArgument[]{new CmdLineArgument.PropertyAddingCmdLineArgument("-clang").settingProperty("parser.useClang", "true").withDescription("use clang together with llvm frontend"), new CmdLineArgument.PropertyAddingCmdLineArgument("-secureMode").settingProperty("secureMode", "true").withDescription("allow to use only secure options"), new CmdLineArgument.CmdLineArgument1("-witness", "witness.validation.file").withDescription("the witness to validate"), new CmdLineArgument.CmdLineArgument1("-outputpath", "output.path").withDescription("where to store the files with results, statistics, logs"), new CmdLineArgument.CmdLineArgument1("-logfile", "log.file").withDescription("set a direct logfile"), new CmdLineArgument.CmdLineArgument1("-entryfunction", "analysis.entryFunction").withDescription("set the initial function for the analysis"), new CmdLineArgument.CmdLineArgument1("-config", "configuration.file").withDescription("set the configuration for the analysis"), new CmdLineArgument.CmdLineArgument1("-timelimit", "limits.time.cpu").withDescription("set a timelimit for the analysis"), new CmdLineArgument.CmdLineArgument1("-sourcepath", "java.sourcepath").withDescription("set the sourcepath for the analysis of Java programs"), new CmdLineArgument.CmdLineArgument1("-cp", "-classpath", "java.classpath").withDescription("set the classpath for the analysis of Java programs"), new CmdLineArgument.CmdLineArgument1("-spec", "specification"){

        @Override
        void handleArg(Map<String, String> properties, String arg) {
            if (SPECIFICATION_FILES_PATTERN.matcher(arg).matches()) {
                arg = CmdLineArguments.resolveSpecificationFileOrExit(arg).toString();
            }
            CmdLineArguments.appendOptionValue(properties, this.getOption(), arg);
        }
    }.withDescription("set the specification for the main analysis"), new CmdLineArgument(new String[]{"-cmc"}){

        @Override
        void apply0(Map<String, String> properties, String pCurrentArg, Iterator<String> argsIt) throws InvalidCmdlineArgumentException {
            CmdLineArguments.handleCmc(argsIt, properties);
        }
    }.withDescription("use conditional model checking"), new CmdLineArgument.CmdLineArgument1("-cpas"){

        @Override
        void handleArg(Map<String, String> properties, String arg) {
            properties.put("cpa", CompositeCPA.class.getName());
            properties.put(CompositeCPA.class.getSimpleName() + ".cpas", arg);
        }
    }.withDescription("set CPAs for the analysis"), new CmdLineArgument.PropertyAddingCmdLineArgument("-cbmc").settingProperty("analysis.checkCounterexamples", "true").settingProperty("counterexample.checker", "CBMC").withDescription("use CBMC as counterexample checker"), new CmdLineArgument.PropertyAddingCmdLineArgument("-nolog").settingProperty("log.level", "off").settingProperty("log.consoleLevel", "off").withDescription("disable logging"), new CmdLineArgument.PropertyAddingCmdLineArgument("-skipRecursion").settingProperty("analysis.summaryEdges", "true").settingProperty("cpa.callstack.skipRecursion", "true").withDescription("skip recursive function calls"), new CmdLineArgument.PropertyAddingCmdLineArgument("-benchmark").settingProperty("output.disable", "true").settingProperty("coverage.enabled", "false").settingProperty("statistics.memory", "false").withDescription("disable assertions and optional features such as output files for improved performance"), new CmdLineArgument.CmdLineArgument1("-setprop"){

        @Override
        void handleArg(Map<String, String> properties, String arg) throws InvalidCmdlineArgumentException {
            List bits = SETPROP_OPTION_SPLITTER.splitToList((CharSequence)arg);
            if (bits.size() != 2) {
                throw new InvalidCmdlineArgumentException("-setprop argument must be a key=value pair, but \"" + arg + "\" is not.");
            }
            CmdLineArguments.putIfNotExistent(properties, (String)bits.get(0), (String)bits.get(1));
        }
    }.withDescription("set an option directly"), new CmdLineArgument(new String[]{"-printOptions"}){

        @Override
        @SuppressFBWarnings(value={"DM_EXIT"})
        @SuppressForbidden(value="System.out is correct here")
        void apply0(Map<String, String> properties, String pCurrentArg, Iterator<String> argsIt) {
            boolean verbose = false;
            if (argsIt.hasNext()) {
                String nextArg = argsIt.next();
                verbose = "-v".equals(nextArg) || "-verbose".equals(nextArg);
            }
            PrintStream out = System.out;
            OptionCollector.collectOptions((boolean)verbose, (boolean)true, (PrintStream)out);
            System.exit(0);
        }
    }.withDescription("print all possible options on StdOut"), new CmdLineArgument.PropertyAddingCmdLineArgument("-printUsedOptions").settingProperty("log.usedOptions.export", "true").settingProperty("analysis.disable", "true").overridingProperty("log.consoleLevel", "SEVERE").withDescription("print all used options"), new CmdLineArgument(new String[]{"-version"}){

        @Override
        @SuppressFBWarnings(value={"DM_EXIT"})
        @SuppressForbidden(value="System.out is correct here")
        void apply0(Map<String, String> pProperties, String pCurrentArg, Iterator<String> pArgsIt) {
            CmdLineArguments.printVersion(System.out);
            System.exit(0);
        }
    }.withDescription("print version number"), new CmdLineArgument(new String[]{"-h", "-help"}){

        @Override
        @SuppressFBWarnings(value={"DM_EXIT"})
        @SuppressForbidden(value="System.out is correct here")
        void apply0(Map<String, String> pProperties, String pCurrentArg, Iterator<String> pArgsIt) {
            CmdLineArguments.printHelp(System.out);
            System.exit(0);
        }
    }.withDescription("print help message")});

    private CmdLineArguments() {
    }

    static Map<String, String> processArguments(String[] args) throws InvalidCmdlineArgumentException {
        HashMap<String, String> properties = new HashMap<String, String>();
        ArrayList<String> programs = new ArrayList<String>();
        Iterator<String> argsIt = Arrays.asList(args).iterator();
        while (argsIt.hasNext()) {
            String arg = argsIt.next();
            boolean foundMatchingArg = false;
            for (CmdLineArgument cmdLineArg : CMD_LINE_ARGS) {
                if (!cmdLineArg.apply(properties, arg, argsIt)) continue;
                foundMatchingArg = true;
                break;
            }
            if (foundMatchingArg) continue;
            if (arg.startsWith("-") && Files.notExists(Path.of(arg, new String[0]), new LinkOption[0])) {
                String argName = arg.substring(1);
                if (DEFAULT_CONFIG_FILES_PATTERN.matcher(argName).matches()) {
                    @Nullable Path configFile = CmdLineArguments.resolveConfigFile(argName);
                    if (configFile != null) {
                        try {
                            IO.checkReadableFile((Path)configFile);
                            CmdLineArguments.putIfNotExistent(properties, CONFIGURATION_FILE_OPTION, configFile.toString());
                            continue;
                        }
                        catch (FileNotFoundException e) {
                            throw Output.fatalError("Invalid configuration %s (%s)", argName, e.getMessage());
                        }
                    }
                    throw Output.fatalErrorWithHelptext("Invalid option %s\nIf you meant to specify a configuration file, the file %s does not exist.", arg, String.format((String)FluentIterable.from((Iterable)DEFAULT_CONFIG_FILES_TEMPLATES.keySet()).get(0), argName));
                }
                throw Output.fatalErrorWithHelptext("Invalid option %s", arg);
            }
            programs.add(arg);
        }
        if (!programs.isEmpty()) {
            CmdLineArguments.putIfNotExistent(properties, "analysis.programNames", Joiner.on((String)", ").join(programs));
        }
        return properties;
    }

    private static void handleCmc(Iterator<String> argsIt, Map<String, String> properties) throws InvalidCmdlineArgumentException {
        String newValue;
        properties.put("analysis.restartAfterUnknown", "true");
        if (argsIt.hasNext()) {
            Path configFile;
            newValue = argsIt.next();
            if (DEFAULT_CONFIG_FILES_PATTERN.matcher(newValue).matches() && Files.notExists(Path.of(newValue, new String[0]), new LinkOption[0]) && (configFile = CmdLineArguments.resolveConfigFile(newValue)) != null) {
                newValue = configFile.toString();
            }
        } else {
            throw new InvalidCmdlineArgumentException("-cmc argument missing.");
        }
        Object value = properties.get(CMC_CONFIGURATION_FILES_OPTION);
        value = value != null ? (String)value + "," + newValue : newValue;
        properties.put(CMC_CONFIGURATION_FILES_OPTION, (String)value);
    }

    private static void printVersion(PrintStream out) {
        out.println();
        out.printf("CPAchecker %s (%s)%n", CPAchecker.getPlainVersion(), CPAchecker.getJavaInformation());
    }

    static void printHelp(PrintStream out) {
        CmdLineArguments.printVersion(out);
        out.println();
        out.println("OPTIONS:");
        for (CmdLineArgument cmdLineArg : CMD_LINE_ARGS) {
            out.println(" " + cmdLineArg);
        }
        out.println();
        out.println("You can also specify any of the configuration files in the directory config/");
        out.println("with -CONFIG_FILE, e.g., -default for config/default.properties.");
        out.println();
        out.println("More information on how to configure CPAchecker can be found in 'doc/Configuration.md'.");
    }

    static void putIfNotExistent(Map<String, String> properties, String key, String value) throws InvalidCmdlineArgumentException {
        if (properties.containsKey(key) && !properties.get(key).equals(value)) {
            throw new InvalidCmdlineArgumentException(String.format("Option %s specified twice on command-line with values '%s' and '%s'.", key, properties.get(key), value));
        }
        properties.put(key, value);
    }

    static void appendOptionValue(Map<String, String> options, String option, String newValue) {
        if (newValue != null) {
            Object value = options.get(option);
            value = value != null ? (String)value + "," + newValue : newValue;
            options.put(option, (String)value);
        }
    }

    static Path resolveSpecificationFileOrExit(String pSpecification) {
        Path specFile = CmdLineArguments.findFile(SPECIFICATION_FILES_TEMPLATE, pSpecification);
        if (specFile != null) {
            return specFile;
        }
        throw Output.fatalError("Checking for property %s is currently not supported by CPAchecker.", pSpecification);
    }

    static @Nullable Path resolveConfigFile(String pName) {
        for (Map.Entry template : DEFAULT_CONFIG_FILES_TEMPLATES.entrySet()) {
            Path file = CmdLineArguments.findFile((String)template.getKey(), pName);
            if (file == null) continue;
            if (!((String)template.getValue()).isEmpty()) {
                Output.warning((String)template.getValue(), pName);
            }
            return file;
        }
        return null;
    }

    private static @Nullable Path findFile(String template, String name) {
        String fileName = String.format(template, name);
        Path file = Path.of(fileName, new String[0]);
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        file = Classes.getCodeLocation(CmdLineArguments.class).resolveSibling(fileName);
        if (Files.exists(file, new LinkOption[0])) {
            return file;
        }
        return null;
    }

    public static class InvalidCmdlineArgumentException
    extends Exception {
        private static final long serialVersionUID = -6526968677815416436L;

        InvalidCmdlineArgumentException(String msg) {
            super(msg);
        }

        public InvalidCmdlineArgumentException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

