/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.reflect.ClassPath;
import com.google.common.testing.TestLogHandler;
import com.google.common.truth.Expect;
import com.google.common.truth.StreamSubject;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.configuration.converters.FileTypeConverter;
import org.sosy_lab.common.configuration.converters.TypeConverter;
import org.sosy_lab.common.log.BasicLogManager;
import org.sosy_lab.common.log.ConsoleLogFormatter;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.core.CPAchecker;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

@RunWith(value=Parameterized.class)
public class ConfigurationFileChecks {
    private static final Pattern INDICATES_MISSING_FILES = Pattern.compile(".*File .* does not exist.*|.*Witness file is missing in specification.*|.*Configuration requires exactly one specification automaton, but none were given.*|.*Could not read precision from file.*|.*The SMT solver MATHSAT5 is not available on this machine because of missing libraries \\(no optimathsat5j in java\\.library\\.path.*|.*The SMT solver Z3 is not available on this machine because of missing libraries .* version `GLIBCXX_3.4.26' not found.*", 32);
    private static final Pattern ALLOWED_WARNINGS = Pattern.compile("The following configuration options were specified but are not used:.*|MathSAT5 is available for research and evaluation purposes only.*|Using unsound approximation of (ints with (unbounded integers|rationals))?( and )?(floats with (unbounded integers|rationals))? for encoding program semantics.|Handling of pointer aliasing is disabled, analysis is unsound if aliased pointers exist.|Finding target locations was interrupted.*|.*One of the parallel analyses has finished successfully, cancelling all other runs.*", 32);
    private static final Pattern PARALLEL_ALGORITHM_ALLOWED_WARNINGS_AFTER_SUCCESS = Pattern.compile(".*Skipping one analysis because the configuration file .* could not be read.*", 32);
    private static final Pattern MPI_PORTFOLIO_ALGORITHM_ALLOWED_WARNINGS_FOR_MISSING_LIBS = Pattern.compile("Invalid configuration (mpiexec is required for performing the portfolio-analysis, but could not find it in PATH)", 32);
    private static final Pattern UNMAINTAINED_CPA_WARNING = Pattern.compile("Using ConfigurableProgramAnalysis .*, which is unmaintained and may not work correctly\\.");
    private static final ImmutableSet<String> UNUSED_OPTIONS = ImmutableSet.of((Object)"java.sourcepath", (Object)"differential.program", (Object)"output.disable", (Object)"report.export", (Object)"statistics.print", (Object)"limits.time.cpu", (Object[])new String[]{"limits.time.cpu::required", "limits.time.cpu.thread", "log.consoleLevel", "log.truncateSize", "memorysafety.config", "memorycleanup.config", "overflow.config", "datarace.config", "termination.config", "termination.violation.witness", "witness.validation.violation.config", "witness.validation.correctness.acsl", "witness.validation.correctness.config", "witness.validation.correctness.isa", "pcc.proofgen.doPCC", "pcc.strategy", "pcc.cmc.configFiles", "pcc.cmc.file", "cpa.automaton.breakOnTargetState", "cpa.automaton.treatErrorsAsTargets", "WitnessAutomaton.cpa.automaton.treatErrorsAsTargets", "witness.stopNotBreakAtSinkStates", "witness.invariantsSpecificationAutomaton", "invariantGeneration.config", "invariantGeneration.kInduction.async", "invariantGeneration.kInduction.guessCandidatesFromCFA", "invariantGeneration.kInduction.terminateOnCounterexample", "counterexample.export.allowImpreciseCounterexamples", "solver.z3.requireProofs", "counterexample.checker", "counterexample.checker.config", "ARGCPA.cpa", "cegar.refiner", "cpa.predicate.refinement.performInitialStaticRefinement", "pcc.proof", "pcc.partial.stopAddingAtReachedSetSize"});
    private static final Path CONFIG_DIR = Path.of("config", new String[0]);
    private static final Path SPEC_DIR = CONFIG_DIR.resolve("specification");
    private static final Path OUTPUT_DIR = Path.of("output", new String[0]);
    @Parameterized.Parameter(value=0)
    public @Nullable Object configFile;
    @Rule
    public final Expect expect = Expect.create();
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Parameterized.Parameters(name="{0}")
    public static Object[] getConfigFiles() throws IOException {
        Stream<URL> configResources = ClassPath.from((ClassLoader)ConfigurationFileChecks.class.getClassLoader()).getResources().stream().filter(resource -> resource.getResourceName().endsWith(".properties")).filter(resource -> resource.getResourceName().contains("cpachecker")).map(ClassPath.ResourceInfo::url);
        try (Stream<Path> configFiles = Files.walk(CONFIG_DIR, new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(".properties")).sorted();){
            Object[] objectArray = Stream.concat(configResources, configFiles).toArray();
            return objectArray;
        }
    }

    @Test
    public void parse() throws URISyntaxException {
        try {
            ConfigurationFileChecks.parse(this.configFile).build();
        }
        catch (IOException | InvalidConfigurationException e) {
            Truth.assertWithMessage((String)"Error during parsing of configuration file %s : %s", (Object[])new Object[]{this.configFile, e.getMessage()}).fail();
        }
    }

    private static ConfigurationBuilder parse(Object pConfigFile) throws IOException, InvalidConfigurationException, URISyntaxException {
        Path configFile;
        if (pConfigFile instanceof Path) {
            configFile = (Path)pConfigFile;
        } else if (pConfigFile instanceof URL) {
            configFile = Path.of(((URL)pConfigFile).toURI());
        } else {
            throw new AssertionError((Object)("Unexpected config file " + pConfigFile));
        }
        return Configuration.builder().loadFromFile(configFile);
    }

    @Test
    public void checkUndesiredOptions() {
        Configuration config;
        try {
            config = ConfigurationFileChecks.parse(this.configFile).build();
        }
        catch (IOException | URISyntaxException | InvalidConfigurationException e) {
            Assume.assumeNoException((Throwable)e);
            throw new AssertionError((Object)e);
        }
        TruthJUnit.assume().withMessage("Test configs (which are loaded from URL resources) may contain any option").that(this.configFile).isNotInstanceOf(URL.class);
        this.checkOption(config, "analysis.entryFunction");
        this.checkOption(config, "analysis.programNames");
        this.checkOption(config, "java.classpath");
        this.checkOption(config, "java.sourcepath");
        this.checkOption(config, "java.version");
        this.checkOption(config, "parser.usePreprocessor");
        this.checkOption(config, "parser.useClang");
        if (!this.configFile.toString().contains("ldv")) {
            this.checkOption(config, "analysis.machineModel");
            if (!this.configFile.toString().contains("svcomp")) {
                if (!this.configFile.toString().contains("lockator")) {
                    this.checkOption(config, "cpa.predicate.memoryAllocationsAlwaysSucceed");
                }
                this.checkOption(config, "cpa.smg.arrayAllocationFunctions");
                this.checkOption(config, "cpa.smg.deallocationFunctions");
                this.checkOption(config, "cpa.smg.memoryAllocationFunctions");
                this.checkOption(config, "cpa.smg.zeroingMemoryAllocation");
            }
            this.checkOption(config, "cfa.assumeFunctions");
            this.checkOption(config, "cpa.predicate.memoryAllocationFunctions");
            this.checkOption(config, "cpa.predicate.memoryAllocationFunctionsWithZeroing");
            this.checkOption(config, "cpa.predicate.memoryAllocationFunctionsWithSuperfluousParameters");
            this.checkOption(config, "cpa.predicate.memoryAllocationFunctions");
            this.checkOption(config, "cpa.predicate.memoryFreeFunctionName");
            this.checkOption(config, "cpa.predicate.nondetFunctionsRegexp");
            this.checkOption(config, "cpa.smg.externalAllocationFunction");
        }
    }

    private void checkOption(Configuration config, String option) {
        if (config.hasProperty(option)) {
            this.expect.withMessage("Configuration has value for option %s with value '%s', which should usually not be present in config files", new Object[]{option, config.getProperty(option)}).fail();
        }
    }

    private boolean isUnmaintainedConfig() {
        if (!(this.configFile instanceof Path)) {
            return false;
        }
        Path basePath = CONFIG_DIR.relativize((Path)this.configFile);
        return basePath.getName(0).equals(Path.of("unmaintained", new String[0]));
    }

    @BeforeClass
    public static void createDummyInputFiles() throws IOException {
        Files.createDirectories(OUTPUT_DIR, new FileAttribute[0]);
        Files.copy(Path.of("test/config/automata/AssumptionAutomaton.spc", new String[0]), OUTPUT_DIR.resolve("AssumptionAutomaton.txt"), StandardCopyOption.REPLACE_EXISTING);
    }

    @Before
    public void createDummyInputAutomatonFiles() throws IOException {
        this.tempFolder.newFile("Goals.txt");
        Path tmpSpecDir = this.tempFolder.newFolder(SPEC_DIR.toString()).toPath();
        for (String file : ImmutableList.of((Object)"AssumptionGuidingAutomaton.spc", (Object)"modifications-present.spc", (Object)"TargetState.spc", (Object)"test-comp-terminatingfunctions.spc")) {
            Files.copy(SPEC_DIR.resolve(file), tmpSpecDir.resolve(file), new CopyOption[0]);
        }
        Files.copy(Path.of("test/config/automata/AssumptionAutomaton.spc", new String[0]), this.tempFolder.newFolder(OUTPUT_DIR.toString()).toPath().resolve("AssumptionAutomaton.txt"), new CopyOption[0]);
    }

    @Test
    public void checkDefaultSpecification() throws InvalidConfigurationException {
        TruthJUnit.assume().that(this.configFile).isInstanceOf(Path.class);
        Iterable<Path> basePath = CONFIG_DIR.relativize((Path)this.configFile);
        if (this.isUnmaintainedConfig()) {
            basePath = Iterables.skip((Iterable)basePath, (int)1);
        }
        TruthJUnit.assume().that((Iterable)basePath).hasSize(1);
        Configuration config = this.createConfigurationForTestInstantiation();
        OptionsWithSpecialHandlingInTest options = new OptionsWithSpecialHandlingInTest();
        config.inject((Object)options);
        String spec = config.getProperty("specification");
        String cpas = Objects.requireNonNullElse(config.getProperty("CompositeCPA.cpas"), "");
        String cpaBelowArgCpa = Objects.requireNonNullElse(config.getProperty("ARGCPA.cpa"), "");
        boolean isSvcompConfig = basePath.toString().contains("svcomp");
        boolean isTestGenerationConfig = basePath.toString().contains("testCaseGeneration");
        boolean isDifferentialConfig = basePath.toString().contains("differentialAutomaton");
        boolean isConditionalTesting = basePath.toString().contains("conditional-testing");
        if (options.language == Language.JAVA) {
            Truth.assertThat((String)spec).endsWith("specification/JavaAssertion.spc");
        } else if (ConfigurationFileChecks.isOptionEnabled(config, "analysis.checkCounterexamplesWithBDDCPARestriction")) {
            Truth.assertThat((String)spec).contains((CharSequence)"specification/BDDCPAErrorLocation.spc");
        } else if (ConfigurationFileChecks.isOptionEnabled(config, "cfa.checkNullPointers")) {
            Truth.assertThat((String)spec).endsWith("specification/null-deref.spc");
        } else if (ConfigurationFileChecks.isOptionEnabled(config, "analysis.algorithm.termination") || ConfigurationFileChecks.isOptionEnabled(config, "analysis.algorithm.nonterminationWitnessCheck") || basePath.toString().contains("validation-termination")) {
            Truth.assertThat((String)spec).isEmpty();
        } else if (basePath.toString().contains("overflow")) {
            if (isSvcompConfig) {
                Truth.assertThat((String)spec).endsWith("specification/sv-comp-overflow.spc");
            } else {
                Truth.assertThat((String)spec).endsWith("specification/overflow.spc");
            }
        } else if (basePath.toString().toLowerCase().contains("datarace")) {
            if (isSvcompConfig) {
                Truth.assertThat((String)spec).endsWith("specification/sv-comp-datarace.spc");
            } else {
                Truth.assertThat((String)spec).endsWith("specification/datarace.spc");
            }
        } else if (cpas.contains("cpa.uninitvars.UninitializedVariablesCPA")) {
            Truth.assertThat((String)spec).endsWith("specification/UninitializedVariables.spc");
        } else if (cpaBelowArgCpa.contains("cpa.singleSuccessorCompactor.SingleSuccessorCompactorCPA")) {
            Truth.assertThat((String)spec).isAnyOf((Object)"specification/multiPropertyCex.spc", (Object)"../specification/default.spc", new Object[0]);
        } else if (cpas.contains("cpa.smg.SMGCPA")) {
            if (isSvcompConfig) {
                Truth.assertThat((String)spec).matches(".*specification/sv-comp-memory(cleanup|safety).spc$");
            } else if (!spec.contains("specification/sv-comp-memorycleanup.spc")) {
                Truth.assertThat((String)spec).contains((CharSequence)"specification/memorysafety.spc");
            }
        } else if (basePath.toString().startsWith("ldv")) {
            Truth.assertThat((String)spec).endsWith("specification/sv-comp-errorlabel.spc");
        } else if (isSvcompConfig) {
            if (basePath.toString().matches(".*svcomp1[234].*")) {
                Truth.assertThat((String)spec).endsWith("specification/sv-comp-errorlabel.spc");
            } else {
                Truth.assertThat((String)spec).endsWith("specification/sv-comp-reachability.spc");
            }
        } else if (isTestGenerationConfig) {
            Truth.assertThat((String)spec).isAnyOf(null, (Object)"", new Object[0]);
        } else if (isDifferentialConfig) {
            if (!Strings.isNullOrEmpty((String)spec)) {
                Truth.assertThat((String)spec).endsWith("specification/modifications-present.spc");
            }
        } else if (isConditionalTesting) {
            Truth.assertThat((String)spec).endsWith("specification/StopAtLeaves.spc");
        } else if (spec != null) {
            Truth.assertThat((String)spec).endsWith("specification/default.spc");
        }
    }

    @Test
    public void instantiate_and_run() throws IOException, InvalidConfigurationException {
        CPAcheckerResult result;
        CPAchecker cpachecker;
        if (this.configFile instanceof Path) {
            TruthJUnit.assume().that((Iterable)this.configFile).containsNoneOf((Object)Path.of("includes", new String[0]), (Object)Path.of("pcc", new String[0]), new Object[]{Path.of("witnessValidation.properties", new String[0]), Path.of("craigInterpolation-violationWitness.properties", new String[0]), Path.of("wacsl.properties", new String[0]), Path.of("distributed-block-summaries", new String[0])});
        }
        OptionsWithSpecialHandlingInTest options = new OptionsWithSpecialHandlingInTest();
        Configuration config = this.createConfigurationForTestInstantiation();
        config.inject((Object)options);
        if (options.cpuTimeRequired.compareTo(TimeSpan.empty()) >= 0) {
            ConfigurationBuilder configBuilder = Configuration.builder().copyFrom(config);
            configBuilder.setOption("limits.time.cpu", options.cpuTimeRequired.toString());
            configBuilder.copyOptionFromIfPresent(config, "limits.time.cpu");
            config = configBuilder.build();
        }
        boolean isJava = options.language == Language.JAVA;
        TestLogHandler logHandler = new TestLogHandler();
        logHandler.setLevel(Level.ALL);
        LogManager logger = BasicLogManager.createWithHandler((Handler)logHandler);
        try {
            cpachecker = new CPAchecker(config, logger, ShutdownManager.create());
        }
        catch (InvalidConfigurationException e) {
            Truth.assertWithMessage((String)"Invalid configuration in configuration file %s : %s", (Object[])new Object[]{this.configFile, e.getMessage()}).fail();
            return;
        }
        try {
            result = cpachecker.run((List<String>)ImmutableList.of((Object)this.createEmptyProgram(isJava)));
        }
        catch (IllegalArgumentException e) {
            if (isJava) {
                TruthJUnit.assume().withMessage("Java frontend has a bug and cannot be run twice").fail();
            }
            throw e;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            Assume.assumeNoException((Throwable)e);
            throw new AssertionError((Object)e);
        }
        ((StreamSubject)Truth.assert_().withMessage("Failure in CPAchecker run with following log\n%s\n\nlog with level WARNING or higher", new Object[]{ConfigurationFileChecks.formatLogRecords(logHandler.getStoredLogRecords())}).about(StreamSubject.streams()).that(this.getSevereMessages(options, logHandler))).isEmpty();
        ((StreamSubject)TruthJUnit.assume().withMessage("messages indicating missing input files").about(StreamSubject.streams()).that(logHandler.getStoredLogRecords().stream().map(LogRecord::getMessage).filter(s -> INDICATES_MISSING_FILES.matcher((CharSequence)s).matches()))).isEmpty();
        if (!ConfigurationFileChecks.isOptionEnabled(config, "analysis.disable") && !options.useMPIProcessAlgorithm) {
            Truth.assert_().withMessage("Failure in CPAchecker run with following log\n%s\n", new Object[]{ConfigurationFileChecks.formatLogRecords(logHandler.getStoredLogRecords())}).that((Comparable)((Object)result.getResult())).isNotEqualTo((Object)CPAcheckerResult.Result.NOT_YET_STARTED);
        }
        if (!options.useParallelAlgorithm && !options.useRestartingAlgorithm || options.useCompositionAlgorithm) {
            Truth.assert_().withMessage("Failure in CPAchecker run with following log\n%s\n\nlist of unused options", new Object[]{ConfigurationFileChecks.formatLogRecords(logHandler.getStoredLogRecords())}).that((Iterable)Sets.difference((Set)config.getUnusedProperties(), UNUSED_OPTIONS)).isEmpty();
        }
    }

    private Configuration createConfigurationForTestInstantiation() {
        try {
            FileTypeConverter fileTypeConverter = FileTypeConverter.create((Configuration)Configuration.builder().setOption("rootDirectory", this.tempFolder.getRoot().toString()).build());
            Configuration.getDefaultConverters().put(FileOption.class, fileTypeConverter);
            return ConfigurationFileChecks.parse(this.configFile).addConverter(FileOption.class, (TypeConverter)fileTypeConverter).setOption("java.sourcepath", this.tempFolder.getRoot().toString()).setOption("differential.program", this.createEmptyProgram(false)).setOption("statistics.memory", "false").build();
        }
        catch (IOException | URISyntaxException | InvalidConfigurationException e) {
            Assume.assumeNoException((Throwable)e);
            throw new AssertionError((Object)e);
        }
    }

    private String createEmptyProgram(boolean pIsJava) throws IOException {
        return TestDataTools.getEmptyProgram(this.tempFolder, pIsJava);
    }

    private Stream<String> getSevereMessages(OptionsWithSpecialHandlingInTest pOptions, final TestLogHandler pLogHandler) {
        Stream logRecords = pLogHandler.getStoredLogRecords().stream();
        if (pOptions.useParallelAlgorithm) {
            Iterator<LogRecord> logRecordIterator = new Iterator<LogRecord>(){
                private Iterator<LogRecord> underlyingIterator;
                private boolean oneComponentSuccessful;
                {
                    this.underlyingIterator = pLogHandler.getStoredLogRecords().iterator();
                    this.oneComponentSuccessful = false;
                }

                @Override
                public boolean hasNext() {
                    return this.underlyingIterator.hasNext();
                }

                @Override
                public LogRecord next() {
                    LogRecord result = this.underlyingIterator.next();
                    if (!this.oneComponentSuccessful && Level.INFO.equals(result.getLevel()) && result.getMessage().endsWith("finished successfully.")) {
                        this.oneComponentSuccessful = true;
                        this.underlyingIterator = Iterators.filter(this.underlyingIterator, r -> !Level.WARNING.equals(r.getLevel()) || !PARALLEL_ALGORITHM_ALLOWED_WARNINGS_AFTER_SUCCESS.matcher(r.getMessage()).matches());
                    }
                    return result;
                }
            };
            logRecords = Streams.stream((Iterator)logRecordIterator);
        }
        Stream<String> result = logRecords.filter(record -> record.getLevel().intValue() >= Level.WARNING.intValue()).map(LogRecord::getMessage).filter(s -> !INDICATES_MISSING_FILES.matcher((CharSequence)s).matches()).filter(s -> !ALLOWED_WARNINGS.matcher((CharSequence)s).matches()).filter(s -> MPI_PORTFOLIO_ALGORITHM_ALLOWED_WARNINGS_FOR_MISSING_LIBS.matcher((CharSequence)s).matches());
        if (this.isUnmaintainedConfig()) {
            result = result.filter(s -> !UNMAINTAINED_CPA_WARNING.matcher((CharSequence)s).matches());
        }
        return result;
    }

    private static String formatLogRecords(Collection<? extends LogRecord> log) {
        return log.stream().map(ConsoleLogFormatter.withoutColors()::format).flatMap(s -> Pattern.compile("\n").splitAsStream((CharSequence)s)).map(s -> "| " + s).collect(Collectors.joining("\n")).trim();
    }

    private static boolean isOptionEnabled(Configuration config, String key) {
        String value = config.getProperty(key);
        return Boolean.parseBoolean(Objects.requireNonNullElse(value, "false"));
    }

    @Options
    private static class OptionsWithSpecialHandlingInTest {
        @Option(secure=true, description="C, Java, or LLVM IR?")
        private Language language = Language.C;
        @Option(secure=true, name="analysis.restartAfterUnknown", description="restart the analysis using a different configuration after unknown result")
        private boolean useRestartingAlgorithm = false;
        @Option(secure=true, name="analysis.useParallelAnalyses", description="Use analyses parallely. The resulting reachedset is the one of the first analysis finishing in time. All other analyses are terminated.")
        private boolean useParallelAlgorithm = false;
        @Option(secure=true, name="useCompositionAnalysis", description="select an analysis from a set of analyses after unknown result")
        private boolean useCompositionAlgorithm = false;
        @Option(secure=true, name="analysis.algorithm.MPI", description="Use MPI for running analyses in new subprocesses. The resulting reachedset is the one of the first analysis returning in time. All other mpi-processes will get aborted.")
        private boolean useMPIProcessAlgorithm = false;
        @Option(secure=true, name="limits.time.cpu::required", description="Enforce that the given CPU time limit is set as the value of limits.time.cpu.")
        @TimeSpanOption(codeUnit=TimeUnit.NANOSECONDS, defaultUserUnit=TimeUnit.SECONDS, min=-1L)
        private TimeSpan cpuTimeRequired = TimeSpan.ofNanos((long)-1L);

        private OptionsWithSpecialHandlingInTest() {
        }
    }
}

