/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import org.sosy_lab.common.Concurrency;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cmdline.ShutdownHook;

class ForceTerminationOnShutdown
implements Runnable {
    private static final AtomicReference<Thread> forceTerminationOnShutdownThread = new AtomicReference();
    private static final AtomicBoolean canceled = new AtomicBoolean();
    private static final int SHUTDOWN_GRACE_PERIOD = 10;
    private static final int SHUTDOWN_GRACE_PERIOD_2 = 1;
    private final LogManager logger;
    private final Thread mainThread;
    private final ShutdownHook shutdownHook;

    private ForceTerminationOnShutdown(LogManager pLogger, Thread pMainThread, ShutdownHook pShutdownHook) {
        this.logger = pLogger;
        this.mainThread = pMainThread;
        this.shutdownHook = pShutdownHook;
    }

    static ShutdownNotifier.ShutdownRequestListener createShutdownListener(final LogManager logger, final ShutdownHook shutdownHook) {
        final Thread mainThread = Thread.currentThread();
        return new ShutdownNotifier.ShutdownRequestListener(){

            public void shutdownRequested(String pReason) {
                if (forceTerminationOnShutdownThread.get() != null) {
                    logger.log(Level.WARNING, new Object[]{"Shutdown requested", "(" + pReason + "),", "but there is already a thread waiting to terminate the JVM."});
                    return;
                }
                if (canceled.get()) {
                    return;
                }
                logger.log(Level.WARNING, new Object[]{"Shutdown requested", "(" + pReason + "),", "waiting for termination."});
                Thread t = Concurrency.newDaemonThread((String)"ForceTerminationOnShutdown", (Runnable)new ForceTerminationOnShutdown(logger, mainThread, shutdownHook));
                boolean success = forceTerminationOnShutdownThread.compareAndSet(null, t);
                if (success) {
                    t.start();
                }
            }
        };
    }

    static void cancelPendingTermination() {
        canceled.set(true);
        Thread t = forceTerminationOnShutdownThread.getAndSet(null);
        if (t != null) {
            t.interrupt();
        }
    }

    @Override
    @SuppressForbidden(value="need to call Thread.stop")
    @SuppressFBWarnings(value={"DM_EXIT"})
    public void run() {
        try {
            TimeUnit.SECONDS.sleep(10L);
        }
        catch (InterruptedException e) {
            return;
        }
        if (canceled.get()) {
            return;
        }
        this.logger.log(Level.WARNING, new Object[]{"Shutdown was requested but CPAchecker is still running after", "10s, forcing immediate termination now."});
        if (this.mainThread.isAlive()) {
            this.logger.log(Level.INFO, new Object[]{"For your information: CPAchecker is currently hanging at\n", Joiner.on((char)'\n').join((Object[])this.mainThread.getStackTrace()), "\n"});
        } else {
            this.logger.log(Level.INFO, new Object[]{"For your information: CPAchecker is currently hanging because the following threads did not yet terminate:\n", this.buildLiveThreadInfo()});
        }
        this.logger.flush();
        this.mainThread.stop();
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e) {
            return;
        }
        if (canceled.get()) {
            return;
        }
        this.shutdownHook.disableAndStop();
        System.exit(0);
    }

    private StringBuilder buildLiveThreadInfo() {
        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
        StringBuilder output = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> threadInfo : traces.entrySet()) {
            Thread thread = threadInfo.getKey();
            StackTraceElement[] trace = threadInfo.getValue();
            if (!thread.isAlive() || thread.isDaemon()) continue;
            output.append(thread);
            if (trace.length > 0) {
                output.append(" at " + trace[0]);
            }
            output.append("\n");
        }
        return output;
    }
}

