/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cmdline;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.io.PrintStream;
import org.checkerframework.dataflow.qual.TerminatesExecution;
import org.sosy_lab.common.annotations.SuppressForbidden;
import org.sosy_lab.cpachecker.cmdline.CmdLineArguments;

@SuppressForbidden(value="System.out in this class is ok")
class Output {
    private static final PrintStream ERROR_OUTPUT = System.err;
    private static final boolean USE_COLORS = System.console() != null && !System.getProperty("os.name", "").startsWith("Windows");
    private static final String ERROR_COLOR = "\u001b[31;1m";
    private static final String WARNING_COLOR = "\u001b[1m";
    private static final String REGULAR_COLOR = "\u001b[m";

    Output() {
    }

    @TerminatesExecution
    @FormatMethod
    static RuntimeException fatalError(String msg, Object ... args) {
        Output.coloredOutput(ERROR_COLOR, msg, args);
        System.exit(1);
        return new RuntimeException("never reached");
    }

    @TerminatesExecution
    @FormatMethod
    static RuntimeException fatalErrorWithHelptext(String msg, Object ... args) {
        Output.coloredOutput(ERROR_COLOR, msg, args);
        CmdLineArguments.printHelp(ERROR_OUTPUT);
        System.exit(1);
        return new RuntimeException("never reached");
    }

    @FormatMethod
    static void warning(String msg, Object ... args) {
        Output.coloredOutput(WARNING_COLOR, msg, args);
        ERROR_OUTPUT.println();
    }

    @FormatMethod
    private static void coloredOutput(String color, @FormatString String msg, Object ... args) {
        ERROR_OUTPUT.println();
        if (USE_COLORS) {
            ERROR_OUTPUT.print(color);
        }
        ERROR_OUTPUT.printf(msg, args);
        if (USE_COLORS) {
            ERROR_OUTPUT.print(REGULAR_COLOR);
        }
        ERROR_OUTPUT.println();
    }
}

